/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.integration.jboss42;

//$Id: ProcessDeploymentHelper.java 3271 2008-12-08 14:27:35Z thomas.diesler@jboss.com $

import java.net.URL;

import org.jboss.bpm.api.config.Configuration;
import org.jboss.bpm.api.deployment.Deployment;
import org.jboss.bpm.api.service.DeploymentService;
import org.jboss.bpm.api.service.ProcessEngine;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;

/**
 * A deployer helper that manages BPM Process Deployments
 * 
 * @author Thomas.Diesler@jboss.org
 * @since 08-Dec-2008
 */
class ProcessDeploymentHelper 
{
  // provide logging
  private static Logger log = Logger.getLogger(ProcessDeploymentHelper.class);
  
  private DeploymentService depService;

  @SuppressWarnings("unchecked")
  public void create(DeploymentInfo di) throws DeploymentException
  {
    URL pdURL = getProcessDefinitionURL(di);
    log.info("Deploy ProcessDefinition: " + pdURL);

    try
    {
      DeploymentService depService = getDeploymentService();
      Deployment dep = depService.createDeployment(pdURL);
      depService.deploy(dep);

      // Remember the procDefID
      di.context.put(Deployment.class.getName(), dep);
    }
    catch (RuntimeException rte)
    {
      throw rte;
    }
    catch (Exception ex)
    {
      throw new DeploymentException("Cannot deploy: " + pdURL, ex);
    }
  }

  public void destroy(DeploymentInfo di) throws DeploymentException
  {
    URL pdURL = getProcessDefinitionURL(di);
    log.info("Undeploy ProcessDefinition: " + pdURL);

    Deployment dep = (Deployment)di.context.get(Deployment.class.getName());
    if (dep != null)
    {
      try
      {
        DeploymentService depService = getDeploymentService();
        depService.undeploy(dep);
      }
      catch (RuntimeException rte)
      {
        throw rte;
      }
      catch (Exception ex)
      {
        throw new DeploymentException("Cannot deploy: " + pdURL, ex);
      }
    }
  }

  private URL getProcessDefinitionURL(DeploymentInfo di)
  {
    URL pdURL = di.localUrl != null ? di.localUrl : di.url;
    if (pdURL == null)
      throw new IllegalStateException("Cannot obtain process definition URL");

    return pdURL;
  }

  private DeploymentService getDeploymentService()
  {
    // This is done lazily because the deployers become available before MC beans 
    if (depService == null)
    {
      ProcessEngine engine = Configuration.getProcessEngine();
      depService = engine.getService(DeploymentService.class);
    }
    return depService;
  }
}