/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.api.test;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class APITestHelper {
    private static final String SYSPROP_TEST_RESOURCES_DIRECTORY = "test.resources.directory";
    private static final String SYSPROP_TEST_ARCHIVE_DIRECTORY = "test.archive.directory";
    private static String testResourcesDir;
    private static String testArchiveDir;

    public URL getResourceURL(String resource) {
        URL resURL = null;
        try {
            File resourceFile = this.getResourceFile(resource);
            resURL = resourceFile.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return resURL;
    }

    public File getResourceFile(String resource) {
        File file = new File(resource);
        if (file.exists()) {
            return file;
        }
        file = new File(this.getTestResourcesDir() + "/" + resource);
        if (file.exists()) {
            return file;
        }
        throw new IllegalArgumentException("Cannot obtain '" + this.getTestResourcesDir() + "/" + resource + "'");
    }

    public String getTestResourcesDir() {
        if (testResourcesDir == null) {
            testResourcesDir = System.getProperty(SYSPROP_TEST_RESOURCES_DIRECTORY, "target/test-classes");
        }
        return testResourcesDir;
    }

    public URL getTestArchiveURL(String archive) throws MalformedURLException {
        return this.getTestArchiveFile(archive).toURI().toURL();
    }

    public File getTestArchiveFile(String archive) {
        File file = new File(archive);
        if (file.exists()) {
            return file;
        }
        file = new File(this.getTestArchiveDir() + "/" + archive);
        if (file.exists()) {
            return file;
        }
        String notSet = this.getTestArchiveDir() == null ? " System property 'test.archive.directory' not set." : "";
        throw new IllegalArgumentException("Cannot obtain '" + this.getTestArchiveDir() + "/" + archive + "'." + notSet);
    }

    public String getTestArchiveDir() {
        if (testArchiveDir == null) {
            testArchiveDir = System.getProperty(SYSPROP_TEST_ARCHIVE_DIRECTORY, "target/test-libs");
        }
        return testArchiveDir;
    }
}

