/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.api.config.internal;

import java.io.InputStream;
import java.net.URL;
import org.jboss.bpm.api.NotImplementedException;
import org.jboss.bpm.api.config.ConfigurationProvider;
import org.jboss.bpm.api.config.internal.EmbeddedBeansDeployer;
import org.jboss.bpm.api.config.internal.KernelLocator;
import org.jboss.bpm.api.service.ProcessEngine;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;

public class MicrocontainerConfigurationProvider
implements ConfigurationProvider {
    public static final String DEFAULT_BEAN_NAME = "BPMProcessEngine";
    public static final String DEFAULT_BEANS_CONFIG = "bpm-spec-beans.xml";
    private Kernel kernel;
    private ProcessEngine engine;

    public ProcessEngine getProcessEngine() {
        return this.getProcessEngine(DEFAULT_BEAN_NAME);
    }

    public ProcessEngine getProcessEngine(String engineName) {
        if (this.engine == null) {
            this.kernel = KernelLocator.getKernel();
            if (this.kernel == null) {
                this.configureWithDefault();
            }
            KernelRegistryEntry entry = this.kernel.getRegistry().getEntry((Object)engineName);
            this.engine = (ProcessEngine)entry.getTarget();
        }
        return this.engine;
    }

    private void configureWithDefault() {
        URL urlConfig = Thread.currentThread().getContextClassLoader().getResource(DEFAULT_BEANS_CONFIG);
        if (urlConfig == null) {
            throw new IllegalStateException("Cannot find resource: bpm-spec-beans.xml");
        }
        this.configure(urlConfig);
    }

    public void configure(InputStream streamConfig) {
        throw new NotImplementedException("Cannot bootstrap JBossMC from InputStream");
    }

    public void configure(String resourceConfig) {
        URL urlConfig = Thread.currentThread().getContextClassLoader().getResource(resourceConfig);
        if (urlConfig == null) {
            throw new IllegalStateException("Cannot find resource: " + resourceConfig);
        }
        this.configure(urlConfig);
    }

    public void configure(URL urlConfig) {
        EmbeddedBeansDeployer deployer = new EmbeddedBeansDeployer();
        deployer.deploy(urlConfig);
        this.kernel = KernelLocator.getKernel();
        if (this.kernel == null) {
            throw new IllegalStateException("Cannot obtain kernel from KernelLocator.");
        }
    }
}

