/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.incubator.service;

// $Id: ThreadingService.java 3484 2008-12-20 14:32:41Z thomas.diesler@jboss.com $

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import org.jboss.bpm.api.model.ProcessInstance;
import org.jboss.bpm.api.model.ProcessInstance.ProcessStatus;
import org.jboss.bpm.api.runtime.Attachments;
import org.jboss.bpm.api.service.internal.AbstractService;
import org.jboss.bpm.incubator.model.StartEvent;

/**
 * The ThreadingService executes processes
 * 
 * @author thomas.diesler@jboss.com
 * @since 18-Jun-2008
 */
public abstract class ThreadingService extends AbstractService
{
  private ExecutorService procExecutor = Executors.newCachedThreadPool();

  // Hide public constructor
  protected ThreadingService()
  {
  }

  /**
   * Get the process executor service
   */
  public ExecutorService getProcessExecutor()
  {
    return procExecutor;
  }

  /**
   * Start the Process from a given start event
   * 
   * @param start The StartEvent that triggers the process
   * @param att The Attachments in the ExecutionContext
   */
  public abstract void startProcess(ProcessInstance proc, StartEvent start, Attachments att);

  /**
   * All Tokens that are generated at the Start Event for that Process must eventually arrive at an End Event. The
   * Process will be in a running state until all Tokens are consumed. <p/> This method until the process ends without
   * timeout.
   */
  public abstract ProcessStatus waitForEnd(ProcessInstance proc);

  /**
   * All Tokens that are generated at the Start Event for that Process must eventually arrive at an End Event. The
   * Process will be in a running state until all Tokens are consumed. <p/> This method until the process ends with a
   * given timeout.
   */
  public abstract ProcessStatus waitForEnd(ProcessInstance proc, long timeout);
}
