/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.incubator.service;

// $Id: PersistenceService.java 3484 2008-12-20 14:32:41Z thomas.diesler@jboss.com $

import javax.management.ObjectName;

import org.hibernate.Session;
import org.jboss.bpm.api.model.Node;
import org.jboss.bpm.api.model.ProcessDefinition;
import org.jboss.bpm.api.model.ProcessInstance;
import org.jboss.bpm.api.service.internal.AbstractService;

/**
 * The persistence service.
 * 
 * @author thomas.diesler@jboss.com
 * @since 17-Sep-2008
 */
public abstract class PersistenceService extends AbstractService
{
  /**
   * Create a new persistence session
   */
  public abstract Session createSession();

  /**
   * Save the ProcessDefinition to persistent storage
   */
  public abstract ObjectName saveProcessDefinition(ProcessDefinition procDef);

  /**
   * Load the ProcessDefinition from persistent storage
   */
  public abstract ProcessDefinition loadProcessDefinition(ObjectName procDefID);

  /**
   * Delete the ProcessDefinition from persistent storage
   */
  public abstract void deleteProcessDefinition(ProcessDefinition procDef);

  /**
   * Save the Process to persistent storage
   */
  public abstract ObjectName saveProcess(ProcessInstance proc);

  /**
   * Load the Process from persistent storage
   */
  public abstract ProcessInstance loadProcess(ObjectName procID);

  /**
   * Delete the Process from persistent storage
   */
  public abstract void deleteProcess(ProcessInstance proc);

  /**
   * Save the Node to persistent storage
   */
  public abstract ObjectName saveNode(Session session, Node node);

  /**
   * Load the Node from persistent storage
   */
  public abstract <T extends Node> T loadNode(Session session, Class<T> clazz, ObjectName nodeID);
}