/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.incubator.model.builder;

//$Id: TaskBuilder.java 3449 2008-12-19 17:39:28Z thomas.diesler@jboss.com $

import org.jboss.bpm.api.model.Message;
import org.jboss.bpm.incubator.model.Expression.ExpressionLanguage;

/**
 * The TaskBuilder can be used to build a Task dynamically.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface TaskBuilder extends ProcessBuilderExt
{
  /**
   * Add an outgoing {@link Message} reference.
   * <p/>
   * The {@link Message} must be defined at {@link Process} level
   */
  TaskBuilder addOutMessageRef(String msgName);
  
  /**
   * Add an incomming {@link Message} reference.
   * <p/>
   * The {@link Message} must be defined at {@link Process} level
   */
  TaskBuilder addInMessageRef(String msgName);
  
  /**
   * Add an InputSet
   */
  TaskBuilder addInputSet();

  /**
   * Add an Property Input
   */
  TaskBuilder addPropertyInput(String name);

  /**
   * Add an OutputSet
   */
  TaskBuilder addOutputSet();

  /**
   * Add an Property Output
   */
  TaskBuilder addPropertyOutput(String name, String value);
  
  /**
   * Add an IORule Expression
   */
  TaskBuilder addIORule(String body, ExpressionLanguage lang);
}