/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.incubator.model.builder;

import org.jboss.bpm.incubator.model.Gate;
import org.jboss.bpm.incubator.model.Expression.ExpressionLanguage;


//$Id: GatewayBuilder.java 3449 2008-12-19 17:39:28Z thomas.diesler@jboss.com $

/**
 * The GatewayBuilder can be used to build a Gateway dynamically.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface GatewayBuilder extends ProcessBuilder
{
  /**
   * Add the default {@link Gate}
   */
  GatewayBuilder addDefaultGate(String targetName);
  
  /**
   * Add a conditional {@link Gate}
   */
  GatewayBuilder addConditionalGate(String targetName, ExpressionLanguage exprLang, String exprBody);

  /**
   * Add an unconditional {@link Gate}
   */
  GatewayBuilder addGate(String targetName);
}