/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.incubator.model;

import org.jboss.bpm.api.model.Message;



//$Id: SendTask.java 3449 2008-12-19 17:39:28Z thomas.diesler@jboss.com $

/**
 * A Send Task.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface SendTask extends Task
{
  /**
   * A Message for the MessageRef attribute MUST be entered. This indicates that the Message will be sent by the Task. The Message in this context is equivalent to an
   * out-only message pattern (Web service). One or more corresponding outgoing Message Flow MAY be shown on the diagram. However, the display of the Message Flow is
   * not required. The Message is applied to all outgoing Message Flow and the Message will be sent down all outgoing Message Flow at the completion of a single
   * instance of the Task.
   */
  Message getMessageRef();

  /**
   * This attribute specifies the technology that will be used to send or receive the message. A Web service is the default technology.
   */
  // Implementation getImplementation();
}