/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.incubator.model;

//$Id: $

import java.io.Serializable;

/**
 * An Expression, which is used in the definition of attributes for StartEvent,
 * IntermediateEvent, Activity, ComplexGateway, and SequenceFlow
 *  
 * @author thomas.diesler@jboss.com
 * @since 21-Jul-2008
 */
public interface Expression extends Serializable
{
  enum ExpressionLanguage
  {
    MVEL
  }

  /**
   * An ExpressionBody MUST be entered to provide the text of the expression, which
   * will be written in the language defined by the ExpressionLanguage attribute.
   */
  String getExpressionBody();
  
  /**
   * A Language MUST be provided to identify the language of the ExpressionBody.
   * The value of the ExpressionLanguage should follow the naming conventions for the
   * version of the specified language.
   */
  ExpressionLanguage getExpressionLanguage();

}
