/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.incubator.model;


//$Id: ExclusiveGateway.java 3449 2008-12-19 17:39:28Z thomas.diesler@jboss.com $

/**
 * Exclusive Gateways (Decisions) are locations within a business process where the Sequence Flow can take two or more
 * alternative paths. This is basically the “fork in the road” for a process. For a given performance (or instance) of the
 * process, only one of the paths can be taken (this should not be confused with forking of paths—refer to “Forking Flow”)
 * 
 * A Decision is not an activity from the business process perspective, but is a type of Gateway that controls
 * the Sequence Flow between activities. It can be thought of as a question that is asked at that point in the Process. The
 * question has a defined set of alternative answers (Gates). Each Decision Gate is associated with a condition expression
 * found within an outgoing Sequence Flow. When a Gate is chosen during the performance of the Process, the
 * corresponding Sequence Flow is then chosen. A Token arriving at the Decision would be directed down the appropriate
 * path, based on the chosen Gate.
 * 
 * The Exclusive Decision has two or more outgoing Sequence Flow, but only one of them may be taken during the
 * performance of the Process. Thus, the Exclusive Decision defines a set of alternative paths for the Token to take as it
 * traverses the Flow. There are two types of Exclusive Decisions: Data-Based and Event-Based.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface ExclusiveGateway extends Gateway
{
  enum ExclusiveType
  {
    Data, Event
  }
  
  /**
   * ExclusiveType is by default Data. The ExclusiveType MAY be set to Event.
   */
  ExclusiveType getExclusiveType();
}