/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.api.test;

// $Id: IntegrationTestCase.java 3153 2008-11-28 16:40:34Z thomas.diesler@jboss.com $

import java.net.URL;

import javax.management.MBeanServerConnection;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * An integration test case
 * 
 * @author Thomas.Diesler@jboss.org
 * @since 25-Sep-2008
 */
public class IntegrationTestCase extends APITestCase
{
  // Provide logging
  final Logger log = LoggerFactory.getLogger(IntegrationTestCase.class);

  IntegrationTestHelper delegate = new IntegrationTestHelper();
  
  public boolean isTargetJBoss500()
  {
    return delegate.isTargetJBoss500();
  }
  
  public boolean isTargetJBoss423()
  {
    return delegate.isTargetJBoss423();
  }
  
  public boolean isTargetJBoss422()
  {
    return delegate.isTargetJBoss422();
  }
  
  public void deploy(String archive) throws Exception
  {
    delegate.deploy(archive);
  }

  public void deploy(URL archive) throws Exception
  {
    delegate.deploy(archive);
  }

  public void undeploy(String archive) throws Exception
  {
    delegate.undeploy(archive);
  }

  public void undeploy(URL archive) throws Exception
  {
    delegate.undeploy(archive);
  }

  public MBeanServerConnection getServer()
  {
    return delegate.getServer();
  }
}
