/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.api.service;

//$Id: DeploymentService.java 3164 2008-12-02 15:41:16Z thomas.diesler@jboss.com $

import java.net.URL;

import org.jboss.bpm.api.deployment.Deployment;
import org.jboss.bpm.api.model.ProcessDefinition;

/**
 * The DeploymentService creates, deployes and undeployes ProcessDefinitions.
 * 
 * @author thomas.diesler@jboss.com
 * @since 25-Sep-2008
 */
public interface DeploymentService
{
  /**
   * Create a Deployment from the given URL
   */
  Deployment createDeployment(URL depURL);

  /**
   * Deploy a ProcessDefinition to the ProcessDefinitionService.
   */
  ProcessDefinition deploy(Deployment deployment);

  /**
   * Undeploy a ProcessDefinition from the ProcessDefinitionService.
   */
  boolean undeploy(Deployment dep);
}