/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.api.service;

import org.jboss.bpm.api.runtime.Context;

//$Id: ContextService.java 3465 2008-12-19 22:44:25Z thomas.diesler@jboss.com $

/**
 * The ContextService is the entry point to create or get a Context.
 * 
 * @author thomas.diesler@jboss.com
 * @since 25-Sep-2008
 */
public interface ContextService
{
  /**
   * Create a new Context
   */
  Context createContext();

  /**
   * Get the current Context association
   * @param create If true, create a new Context if there is no context associated
   */
  Context getContext(boolean create);
}