/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.api.model;

//$Id: Signal.java 3449 2008-12-19 17:39:28Z thomas.diesler@jboss.com $

import java.io.Serializable;

import javax.management.ObjectName;

/**
 * A Signal is like an undirected flare shot up
 * into the air.
 *  
 * @author Thomas.Diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface Signal extends Serializable
{
  /**
   * Defines the types of supported Signals
   */
  enum SignalType
  {
    SYSTEM_START_EVENT_ENTER, SYSTEM_START_EVENT_EXIT, SYSTEM_START_TRIGGER,
    SYSTEM_EVENT_ENTER, SYSTEM_EVENT_EXIT, SYSTEM_EVENT_TRIGGER,
    SYSTEM_END_EVENT_ENTER, SYSTEM_END_EVENT_EXIT, SYSTEM_END_TRIGGER, 
    SYSTEM_GATEWAY_ENTER, SYSTEM_GATEWAY_EXIT, 
    SYSTEM_PROCESS_ENTER, SYSTEM_PROCESS_EXIT, 
    SYSTEM_TASK_ENTER, SYSTEM_TASK_EXIT, SYSTEM_TASK_TRIGGER,
    USER_SIGNAL
  }

  /**
   * Get the signal type of this signal
   */
  SignalType getSignalType();

  /**
   * Get the sending participant for this signal
   */
  ObjectName getFromRef();

  /**
   * Get the optional message associated with this signal
   */
  public String getMessage();
}