/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.api.model;

//$Id: ProcessInstance.java 3234 2008-12-05 17:49:30Z thomas.diesler@jboss.com $

import java.util.Date;
import java.util.Set;

import org.jboss.bpm.api.runtime.Attachments;
import org.jboss.bpm.api.runtime.Token;
import org.jboss.bpm.api.service.ProcessEngine;

/**
 * A Process is any Activity performed within a company or organization.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface ProcessInstance extends ProcessStructure
{
  /**
   * Defines the status a {@link ProcessInstance} can be in
   */
  public enum ProcessStatus
  {
    None, Ready, Active, Suspended, Cancelled, Aborted, Completed
  }

  /**
   * Get the associated ProcessEngine
   */
  ProcessEngine getProcessEngine();
  
  /**
   * Get the associated ProcessDefinition
   */
  ProcessDefinition getProcessDefinition();
  
  /**
   * Get the process state
   */
  ProcessStatus getProcessStatus();

  /**
   * Get the root Token associated with this Process 
   */
  Token getRootToken();
  
  /**
   * Get the set of Tokens associated with this Process 
   */
  Set<Token> getTokens();
  
  /**
   * Start the process
   */
  Token startProcess();

  /**
   * Start the process, with a given context data
   */
  Token startProcess(Attachments att);
  
  /**
   * Get the start date of this process
   */
  Date getStartDate();
  
  /**
   * Get the end date of this process
   * @return null if not ended 
   */
  Date getEndDate();
  
  /**
   * Suspend the process
   */
  void suspend();
  
  /**
   * Resume the process
   */
  void resume();
  
  /**
   * Cancel the process
   */
  void cancel();
}