/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.api.model;

import java.io.Serializable;


//$Id: Message.java 3449 2008-12-19 17:39:28Z thomas.diesler@jboss.com $

/**
 * A Message, which is used in the definition of attributes for a StartEvent,
 * EndEvent, IntermediateEvent, Task, and MessageFlow
 * 
 * @author thomas.diesler@jboss.com
 * @since 21-Jul-2008
 */
public interface Message extends PropertySupport, Serializable
{
  /**
   * Name is an attribute that is text description of the Message.
   */
  String getName();

  /**
   * This defines the source of the Message.
   */
  Participant getFromRef();
  
  /**
   * This defines the target of the Message.
   */
  Participant getToRef();
}
