/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.api.config.internal;

//$Id: MicrocontainerConfigurationProvider.java 3465 2008-12-19 22:44:25Z thomas.diesler@jboss.com $

import java.io.InputStream;
import java.net.URL;

import org.jboss.bpm.api.NotImplementedException;
import org.jboss.bpm.api.config.ConfigurationProvider;
import org.jboss.bpm.api.service.ProcessEngine;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;

/**
 * The ProcessEngineProvider provides a ProcessEngine through a given configuration method
 * 
 * @author thomas.diesler@jboss.com
 * @since 18-Jun-2008
 */
public class MicrocontainerConfigurationProvider implements ConfigurationProvider
{
  /** The process engine bean name - BPMProcessEngine */
  public static final String DEFAULT_BEAN_NAME = "BPMProcessEngine";
  /** The default bean config: bpm-spec-beans.xml */
  public static final String DEFAULT_BEANS_CONFIG = "bpm-spec-beans.xml";

  private Kernel kernel;
  private ProcessEngine engine;

  @Override
  public ProcessEngine getProcessEngine()
  {
    return getProcessEngine(DEFAULT_BEAN_NAME);
  }

  @Override
  @SuppressWarnings("deprecation")
  public ProcessEngine getProcessEngine(String engineName)
  {
    if (engine == null)
    {
      kernel = KernelLocator.getKernel();
      if (kernel == null)
      {
        configureWithDefault();
      }
      KernelRegistryEntry entry = kernel.getRegistry().getEntry(engineName);
      engine = (ProcessEngine)entry.getTarget();
    }
    return engine;
  }

  private void configureWithDefault()
  {
    URL urlConfig = Thread.currentThread().getContextClassLoader().getResource(DEFAULT_BEANS_CONFIG);
    if (urlConfig == null)
      throw new IllegalStateException("Cannot find resource: " + DEFAULT_BEANS_CONFIG);
    
    configure(urlConfig);
  }
  
  @Override
  public void configure(InputStream streamConfig)
  {
    throw new NotImplementedException("Cannot bootstrap JBossMC from InputStream");
  }

  @Override
  public void configure(String resourceConfig)
  {
    URL urlConfig = Thread.currentThread().getContextClassLoader().getResource(resourceConfig);
    if (urlConfig == null)
      throw new IllegalStateException("Cannot find resource: " + resourceConfig);
    
    configure(urlConfig);
  }

  @Override
  public void configure(URL urlConfig)
  {
    EmbeddedBeansDeployer deployer = new EmbeddedBeansDeployer();
    deployer.deploy(urlConfig);
    
    kernel = KernelLocator.getKernel();
    if (kernel == null)
      throw new IllegalStateException("Cannot obtain kernel from KernelLocator.");
  }
}