/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.monitor.model.json;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XYDataSetJSO {
    String id;
    boolean mipped = true;
    List<List<Long>> domain = new ArrayList<List<Long>>();
    List<List<Long>> range = new ArrayList<List<Long>>();
    double rangeBottom;
    double rangeTop;
    String[] label;
    String axis;

    public XYDataSetJSO() {
    }

    public XYDataSetJSO(String[] label, String id) {
        this.label = label;
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isMipped() {
        return this.mipped;
    }

    public void setMipped(boolean mipped) {
        this.mipped = mipped;
    }

    public List<List<Long>> getDomain() {
        return this.domain;
    }

    public List<List<Long>> getRange() {
        return this.range;
    }

    public double getRangeBottom() {
        return this.rangeBottom;
    }

    public void setRangeBottom(double rangeBottom) {
        this.rangeBottom = rangeBottom;
    }

    public double getRangeTop() {
        return this.rangeTop;
    }

    public void setRangeTop(double rangeTop) {
        this.rangeTop = rangeTop;
    }

    public String[] getLabel() {
        return this.label;
    }

    public void setLabel(String[] label) {
        this.label = label;
    }

    public String getAxis() {
        return this.axis;
    }

    public void setAxis(String axis) {
        this.axis = axis;
    }

    public String toJSO() {
        StringBuffer sb = new StringBuffer();
        if (this.domain.size() > 1) {
            sb.append("[");
        }
        for (int current = 0; current < this.domain.size(); ++current) {
            sb.append("{");
            sb.append("\"id\":\"").append(this.id).append("-").append(current).append("\",");
            sb.append("\"preferredRenderer\": \"line\",");
            sb.append("\"domain\": [");
            int idx = 1;
            List<Long> list = this.domain.get(current);
            for (Long d : list) {
                sb.append(d);
                if (idx < list.size()) {
                    sb.append(",");
                }
                ++idx;
            }
            sb.append("],");
            sb.append("\"range\" :[");
            idx = 1;
            list = this.range.get(current);
            for (Long d : list) {
                sb.append(d);
                if (idx < list.size()) {
                    sb.append(",");
                }
                ++idx;
            }
            sb.append("],");
            sb.append("\"label\":\"").append(this.label[current]).append("\",");
            sb.append("\"axis\":\"").append("Unit").append("\"");
            sb.append("}");
            if (current >= this.domain.size() - 1) continue;
            sb.append(",");
        }
        if (this.domain.size() > 1) {
            sb.append("]");
        }
        return sb.toString();
    }
}

