/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.monitor.model;

import java.util.List;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.transaction.UserTransaction;
import org.jboss.bpm.monitor.model.BPAFDataSource;
import org.jboss.bpm.monitor.model.bpaf.Event;
import org.jboss.bpm.monitor.model.bpaf.State;
import org.jboss.bpm.monitor.model.metric.Timespan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBPAFDataSource
implements BPAFDataSource {
    EntityManagerFactory emf;

    public DefaultBPAFDataSource(EntityManagerFactory emf) {
        this.emf = emf;
    }

    private <T> T executeCommand(SQLCommand<T> cmd) {
        EntityManager em = null;
        UserTransaction tx = null;
        boolean sucess = true;
        try {
            InitialContext ctx = new InitialContext();
            tx = (UserTransaction)ctx.lookup("UserTransaction");
            tx.begin();
            em = this.emf.createEntityManager();
            T t = cmd.execute(em);
            return t;
        }
        catch (Exception e) {
            sucess = false;
            throw new RuntimeException("Failed to execute query", e);
        }
        finally {
            if (em != null) {
                try {
                    if (sucess) {
                        tx.commit();
                    } else {
                        tx.setRollbackOnly();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                em.close();
            }
        }
    }

    @Override
    public List<String> getProcessDefinitions() {
        List<String> result = this.executeCommand(new SQLCommand<List<String>>(){

            @Override
            public List<String> execute(EntityManager em) {
                Query query = em.createNativeQuery("select distinct e.PROCESS_DEFINITION_ID from BPAF_EVENT as e");
                return query.getResultList();
            }
        });
        return result;
    }

    @Override
    public List<String> getProcessInstances(final String processDefinition) {
        List<String> result = this.executeCommand(new SQLCommand<List<String>>(){

            @Override
            public List<String> execute(EntityManager em) {
                Query query = em.createNativeQuery("select distinct e.PROCESS_INSTANCE_ID from BPAF_EVENT as e where e.PROCESS_DEFINITION_ID=:id");
                query.setParameter("id", (Object)processDefinition);
                return query.getResultList();
            }
        });
        return result;
    }

    @Override
    public List<String> getActivityDefinitions(final String processInstance) {
        List<String> result = this.executeCommand(new SQLCommand<List<String>>(){

            @Override
            public List<String> execute(EntityManager em) {
                Query query = em.createNativeQuery("select distinct e.ACTIVITY_DEFINITION_ID from BPAF_EVENT as e where e.PROCESS_INSTANCE_ID=:id and e.ACTIVITY_DEFINITION_ID!=null");
                query.setParameter("id", (Object)processInstance);
                return query.getResultList();
            }
        });
        return result;
    }

    @Override
    public List<Event> getInstanceEvents(final String processDefinition, final Timespan timespan, final State completionState) {
        List<Event> result = this.executeCommand(new SQLCommand<List<Event>>(){

            @Override
            public List<Event> execute(EntityManager em) {
                Query query = em.createNativeQuery("select e1.* from BPAF_EVENT e1, BPAF_EVENT e2 where e1.PROCESS_DEFINITION_ID=e2.PROCESS_DEFINITION_ID and e1.PROCESS_INSTANCE_ID=e2.PROCESS_INSTANCE_ID and ((e1.CURRENT_STATE=?1 and e2.CURRENT_STATE=?2) OR (e2.CURRENT_STATE=?1 and e1.CURRENT_STATE=?2)) and e1.ACTIVITY_DEFINITION_ID is null and e2.ACTIVITY_DEFINITION_ID is null and e1.PROCESS_DEFINITION_ID='" + processDefinition + "' " + "and e1.TIMESTAMP>=?3 " + "and e2.TIMESTAMP<=?4 " + "order by e1.EID;", Event.class);
                query.setParameter(1, (Object)State.Open_Running.toString());
                query.setParameter(2, (Object)completionState.toString());
                query.setParameter(3, (Object)timespan.getStart());
                query.setParameter(4, (Object)timespan.getEnd());
                return query.getResultList();
            }
        });
        return result;
    }

    @Override
    public List<Event> getActivityCompletedEvents(final String ... processInstances) {
        List<Event> result = this.executeCommand(new SQLCommand<List<Event>>(){

            @Override
            public List<Event> execute(EntityManager em) {
                StringBuffer sb = new StringBuffer("SELECT e1.* ");
                sb.append("FROM BPAF_EVENT e1, BPAF_EVENT e2 ");
                sb.append("WHERE e1.PROCESS_INSTANCE_ID=e2.PROCESS_INSTANCE_ID ");
                sb.append("AND ((e1.CURRENT_STATE=?1 and e2.CURRENT_STATE=?2) OR (e2.CURRENT_STATE=?1 and e1.CURRENT_STATE=?2)) ");
                sb.append("AND e1.ACTIVITY_DEFINITION_ID is not null ");
                sb.append("AND e2.ACTIVITY_DEFINITION_ID is not null ");
                sb.append("AND (");
                for (int i = 0; i < processInstances.length; ++i) {
                    if (i == 0) {
                        sb.append("e1.PROCESS_INSTANCE_ID=\"" + processInstances[i] + "\" ");
                        continue;
                    }
                    sb.append("OR e1.PROCESS_INSTANCE_ID=\"" + processInstances[i] + "\" ");
                }
                sb.append(") ");
                sb.append("GROUP BY e1.ACTIVITY_INSTANCE_ID ");
                sb.append("ORDER BY e1.TIMESTAMP, e1.PROCESS_INSTANCE_ID");
                Query query = em.createNativeQuery(sb.toString(), Event.class);
                query.setParameter(1, (Object)State.Open_Running.toString());
                query.setParameter(2, (Object)State.Closed_Completed.toString());
                return query.getResultList();
            }
        });
        return result;
    }

    @Override
    public List<Event> getPastActivities(final String processInstance) {
        List<Event> result = this.executeCommand(new SQLCommand<List<Event>>(){

            @Override
            public List<Event> execute(EntityManager em) {
                Query query = em.createQuery("select e from Event as e where e.processInstanceID=:id");
                query.setParameter("id", (Object)processInstance);
                return query.getResultList();
            }
        });
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface SQLCommand<T> {
        public T execute(EntityManager var1);
    }
}

