/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.impl.mc.server;

import org.jboss.bootstrap.api.mc.config.MCServerConfig;
import org.jboss.bootstrap.api.mc.server.MCServer;
import org.jboss.bootstrap.impl.mc.config.BasicMCServerConfig;
import org.jboss.bootstrap.impl.mc.config.MCConfigurationInitializer;
import org.jboss.bootstrap.impl.mc.config.MCConfigurationValidator;
import org.jboss.bootstrap.impl.mc.server.AbstractMCServerBase;
import org.jboss.bootstrap.impl.mc.server.MCServerInitializer;
import org.jboss.bootstrap.spi.mc.server.MCServerProvider;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MCServerImpl
extends AbstractMCServerBase<MCServer, MCServerConfig>
implements MCServerProvider {
    private static final Logger log = Logger.getLogger(MCServerImpl.class);
    private static final MCConfigurationInitializer CONFIG_INITIALIZER = new MCConfigurationInitializer();
    private static final MCConfigurationValidator VALIDATOR = new MCConfigurationValidator();
    private static final MCServerInitializer SERVER_INITIALIZER = new MCServerInitializer();

    public MCServerImpl() {
        this((MCServerConfig)null);
    }

    public MCServerImpl(MCServerConfig config) {
        this(config, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MCServerImpl(MCServerConfig config, boolean defaultInit) {
        super(MCServer.class, config);
        if (defaultInit) {
            MCServerImpl mCServerImpl = this;
            synchronized (mCServerImpl) {
                if (this.getConfigInitializer() == null) {
                    this.setConfigInitializer(CONFIG_INITIALIZER);
                    log.debug((Object)("Defaulted: " + (Object)((Object)CONFIG_INITIALIZER)));
                }
                if (this.getValidator() == null) {
                    this.setValidator(VALIDATOR);
                    log.debug((Object)("Defaulted: " + (Object)((Object)VALIDATOR)));
                }
                if (this.getServerInitializer() == null) {
                    this.setServerInitializer(SERVER_INITIALIZER);
                    log.debug((Object)("Defaulted: " + (Object)((Object)SERVER_INITIALIZER)));
                }
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)"defaultInit is not set, skipping defaulting of server initializer, config initializer, server validator");
        }
    }

    protected Class<? extends MCServerConfig> getDefaultServerConfigClass() {
        return BasicMCServerConfig.class;
    }
}

