/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.bootstrap.impl.mc.config;

import java.util.Map;

import org.jboss.bootstrap.api.mc.config.MCServerConfig;
import org.jboss.bootstrap.impl.base.config.AbstractBasicServerConfig;
import org.jboss.logging.Logger;

/**
 * BasicServerConfig
 * 
 * Simple Object-backed implementation of an MC Server Configuration
 *
 * @author <a href="mailto:andrew.rubinger@jboss.org">ALR</a>
 * @version $Revision: $
 */
public class BasicMCServerConfig extends AbstractBasicServerConfig<MCServerConfig> implements MCServerConfig
{

   //-------------------------------------------------------------------------------------||
   // Class Members ----------------------------------------------------------------------||
   //-------------------------------------------------------------------------------------||

   @SuppressWarnings("unused")
   private static final Logger log = Logger.getLogger(BasicMCServerConfig.class);

   //-------------------------------------------------------------------------------------||
   // Constructors -----------------------------------------------------------------------||
   //-------------------------------------------------------------------------------------||

   /**
    * Constructor
    */
   public BasicMCServerConfig()
   {
      super(MCServerConfig.class);
   }

   /**
    * Constructor
    * 
    * @param overrideProperties A Set of properties to override those found 
    *           in System Properties
    */
   public BasicMCServerConfig(Map<String, String> overrideProperties)
   {
      super(MCServerConfig.class, overrideProperties);
   }

}
