/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bootstrap.impl.as.xml;

import java.net.URL;

import org.jboss.bootstrap.spi.as.metadata.BootstrapMetaData;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;

/**
 * BootstrapParser.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1 $
 */
public class BootstrapParser
{
   /**
    * Parse bootstrap metadata from the given url
    * 
    * @param url the url
    * @return the bootstrap metadata
    */
   public static BootstrapMetaData parse(URL url)
   {
      if (url == null)
         throw new IllegalArgumentException("Null url");

      UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
      Unmarshaller unmarshaller = factory.newUnmarshaller();
      try
      {
         BootstrapMetaData result = (BootstrapMetaData) unmarshaller.unmarshal(url.toString(),
               new BootstrapSchemaBinding());
         if (result == null)
            throw new IllegalStateException("The bootsrap xml " + url + " is not well formed");
         return result;
      }
      catch (Exception e)
      {
         throw new RuntimeException("Error unmarshalling " + url, e);
      }
   }
}
