/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
  *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bootstrap.impl.as.server;

import org.jboss.bootstrap.api.as.config.JBossASServerConfig;
import org.jboss.bootstrap.api.as.server.JBossASServer;
import org.jboss.bootstrap.impl.as.config.BasicJBossASServerConfig;
import org.jboss.bootstrap.spi.as.server.MCJBossASServerProvider;

/**
 * JBossASServerImpl
 * 
 * Implementation of a JBossASServer
 *
 * @author <a href="mailto:andrew.rubinger@jboss.org">ALR</a>
 * @version $Revision: $
 */
public class JBossASServerImpl extends AbstractJBossASServerBase<JBossASServer, JBossASServerConfig>
      implements
         MCJBossASServerProvider
{
   //-------------------------------------------------------------------------------------||
   // Constructors -----------------------------------------------------------------------||
   //-------------------------------------------------------------------------------------||

   /**
    * Constructor
    * 
    * Creates a new instance with a default configuration 
    */
   public JBossASServerImpl()
   {
      // Delegate to other ctor
      this(null);
   }

   /**
    * Constructor
    * 
    * @param config Configuration to set upon this server, or null for a default config
    */
   public JBossASServerImpl(final JBossASServerConfig config)
   {
      // Make a new instance with the specified config
      super(JBossASServer.class, config);
   }

   //-------------------------------------------------------------------------------------||
   // Required Implementations -----------------------------------------------------------||
   //-------------------------------------------------------------------------------------||

   /*
    * (non-Javadoc)
    * @see org.jboss.bootstrap.impl.base.server.AbstractServer#getDefaultServerConfigClass()
    */
   @Override
   protected Class<? extends JBossASServerConfig> getDefaultServerConfigClass()
   {
      return BasicJBossASServerConfig.class;
   }

}
