/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.impl.as.server;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.bootstrap.impl.as.config.BasicJBossASServerConfig;
import org.jboss.bootstrap.impl.as.config.JBossASConfigurationInitializerImpl;
import org.jboss.bootstrap.impl.as.config.JBossASConfigurationValidator;
import org.jboss.bootstrap.impl.as.lifecycle.KernelStartEventLifecycleEventHandler;
import org.jboss.bootstrap.impl.as.lifecycle.KernelStopEventLifecycleEventHandler;
import org.jboss.bootstrap.impl.as.lifecycle.VfsInitializingLifecycleEventHandler;
import org.jboss.bootstrap.impl.as.server.JBossASServerInitializer;
import org.jboss.bootstrap.impl.as.server.Version;
import org.jboss.bootstrap.impl.mc.server.AbstractMCServerBase;
import org.jboss.bootstrap.spi.as.config.JBossASConfigurationInitializer;
import org.jboss.bootstrap.spi.as.config.JBossASServerConfig;
import org.jboss.bootstrap.spi.as.server.JBossASServer;
import org.jboss.bootstrap.spi.config.ConfigurationInitializer;
import org.jboss.bootstrap.spi.config.ConfigurationValidator;
import org.jboss.bootstrap.spi.config.InvalidConfigurationException;
import org.jboss.bootstrap.spi.lifecycle.LifecycleEventException;
import org.jboss.bootstrap.spi.lifecycle.LifecycleState;
import org.jboss.bootstrap.spi.mc.config.MCBasedServerConfig;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.logging.Logger;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagementObject(name="jboss.system:type=MCServer", isRuntime=true, properties=ManagementProperties.EXPLICIT, description="the MCServer bootstrap view", componentType=@ManagementComponent(type="MCBean", subtype="*"))
public class JBossASServerImpl
extends AbstractMCServerBase<JBossASServer, JBossASServerConfig>
implements JBossASServer {
    private static final Logger log = Logger.getLogger(JBossASServerImpl.class);
    private static final ConfigurationValidator<JBossASServerConfig> VALIDATOR = new JBossASConfigurationValidator();
    private static final JBossASServerInitializer SERVER_INITIALIZER = new JBossASServerInitializer();
    private static final JBossASConfigurationInitializer CONFIG_INITIALIZER = new JBossASConfigurationInitializerImpl();
    private final Version version = Version.getInstance();
    private volatile Date startDate;
    private final Map<String, Object> metadata = new ConcurrentHashMap<String, Object>();

    public JBossASServerImpl() throws IllegalArgumentException {
        this(null);
    }

    public JBossASServerImpl(JBossASServerConfig config) throws IllegalArgumentException {
        super(JBossASServer.class, (MCBasedServerConfig)config);
        this.setServerInitializer(SERVER_INITIALIZER);
        this.setConfigInitializer((ConfigurationInitializer)CONFIG_INITIALIZER);
        this.setValidator(VALIDATOR);
    }

    protected Class<? extends JBossASServerConfig> getDefaultServerConfigClass() {
        return BasicJBossASServerConfig.class;
    }

    @ManagementProperty(description="The server build date", readOnly=true)
    public String getBuildDate() {
        return this.version.getBuildDate();
    }

    @ManagementProperty(description="The server build ID", readOnly=true)
    public String getBuildID() {
        return this.version.getBuildID();
    }

    @ManagementProperty(description="The server build JVM", readOnly=true)
    public String getBuildJVM() {
        return this.version.getBuildJVM();
    }

    @ManagementProperty(description="The server build number", readOnly=true)
    public String getBuildNumber() {
        return this.version.getBuildNumber();
    }

    @ManagementProperty(description="The server build OS", readOnly=true)
    public String getBuildOS() {
        return this.version.getBuildOS();
    }

    @ManagementProperty(description="The server start time", readOnly=true)
    public Date getStartDate() {
        Date copyDate = (Date)this.startDate.clone();
        return copyDate;
    }

    @ManagementProperty(description="The server version string", readOnly=true)
    public String getVersion() {
        return this.version.toString();
    }

    @ManagementProperty(description="The server version name", readOnly=true)
    public String getVersionName() {
        return this.version.getName();
    }

    @ManagementProperty(description="The server version number string", readOnly=true)
    public String getVersionNumber() {
        return this.version.getVersionNumber();
    }

    public Map<String, Object> getMetaData() {
        return this.metadata;
    }

    @Deprecated
    public boolean isStarted() {
        LifecycleState state = this.getState();
        return state.equals((Object)LifecycleState.STARTED);
    }

    public synchronized void initialize() throws IllegalStateException, InvalidConfigurationException, LifecycleEventException {
        super.initialize();
        VfsInitializingLifecycleEventHandler initVfsHandler = new VfsInitializingLifecycleEventHandler();
        this.registerEventHandler(initVfsHandler, new LifecycleState[]{LifecycleState.STARTING});
        BasicBootstrap bootstrap = this.getBootstrap();
        KernelStartEventLifecycleEventHandler startHandler = new KernelStartEventLifecycleEventHandler(bootstrap);
        KernelStopEventLifecycleEventHandler stopHandler = new KernelStopEventLifecycleEventHandler(bootstrap);
        this.registerEventHandler(startHandler, new LifecycleState[]{LifecycleState.STARTED});
        this.registerEventHandler(stopHandler, new LifecycleState[]{LifecycleState.STOPPED});
        this.logServerInfo();
    }

    protected void logServerInfo() {
        StringBuffer sb = new StringBuffer();
        int newline = 10;
        int tab = 9;
        JBossASServerConfig config = (JBossASServerConfig)this.getConfiguration();
        sb.append("Server Configuration:");
        sb.append('\n').append('\n').append('\t');
        sb.append("Bootstrap URL: " + config.getBootstrapUrl());
        sb.append('\n').append('\t');
        sb.append("JBOSS_HOME URL: " + config.getJBossHome());
        sb.append('\n').append('\t');
        sb.append("Common Base URL: " + config.getCommonBaseLocation());
        sb.append('\n').append('\t');
        sb.append("Common Library URL: " + config.getCommonLibLocation());
        sb.append('\n').append('\t');
        sb.append("Server Name: " + config.getServerName());
        sb.append('\n').append('\t');
        sb.append("Server Base URL: " + config.getServerBaseLocation());
        sb.append('\n').append('\t');
        sb.append("Server Library URL: " + config.getServerLibLocation());
        sb.append('\n').append('\t');
        sb.append("Server Config URL: " + config.getServerConfLocation());
        sb.append('\n').append('\t');
        sb.append("Server Home URL: " + config.getServerHomeLocation());
        sb.append('\n').append('\t');
        sb.append("Server Data URL: " + config.getServerDataLocation());
        sb.append('\n').append('\t');
        sb.append("Server Log URL: " + config.getServerLogLocation());
        sb.append('\n').append('\t');
        sb.append("Server Temp URL: " + config.getServerTempLocation());
        sb.append('\n');
        log.info((Object)sb.toString());
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.setStartDate(new Date());
    }

    protected void setStartDate(Date startDate) {
        this.startDate = (Date)startDate.clone();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("JBoss Server[");
        sb.append(this.version.toString());
        sb.append("]");
        return sb.toString();
    }
}

