/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.blacktie.administration;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.MessageListener;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.blacktie.administration.core.AdministrationProxy;
import org.jboss.blacktie.jatmibroker.core.conf.ConfigurationException;
import org.jboss.blacktie.jatmibroker.core.conf.XMLParser;
import org.jboss.blacktie.jatmibroker.xatmi.Buffer;
import org.jboss.blacktie.jatmibroker.xatmi.ConnectionException;
import org.jboss.blacktie.jatmibroker.xatmi.Response;
import org.jboss.blacktie.jatmibroker.xatmi.TPSVCINFO;
import org.jboss.blacktie.jatmibroker.xatmi.X_OCTET;
import org.jboss.blacktie.jatmibroker.xatmi.mdb.MDBBlacktieService;
import org.jboss.ejb3.annotation.ResourceAdapter;
import org.jboss.mx.util.MBeanServerLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="queue/BTR_BTStompAdmin")})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
@ResourceAdapter(value="hornetq-ra.rar")
public class BlacktieStompAdministrationService
extends MDBBlacktieService
implements MessageListener {
    private static final Logger log = LogManager.getLogger(BlacktieStompAdministrationService.class);
    private MBeanServerConnection beanServerConnection;
    private Properties prop = new Properties();
    public static Hashtable<String, Long> QUEUE_CREATION_TIMES = new Hashtable();

    public BlacktieStompAdministrationService() throws IOException, ConfigurationException {
        XMLParser.loadProperties((String)"btconfig.xsd", (String)"btconfig.xml", (Properties)this.prop);
        this.beanServerConnection = MBeanServerLocator.locateJBoss();
    }

    boolean isDeployQueue(String serviceName) throws Exception {
        ObjectName objName = new ObjectName("org.hornetq:module=JMS,type=Server");
        String[] dests = (String[])this.beanServerConnection.getAttribute(objName, "QueueNames");
        log.trace((Object)serviceName);
        boolean conversational = false;
        if (!serviceName.startsWith(".")) {
            conversational = (Boolean)this.prop.get("blacktie." + serviceName + ".conversational");
        }
        String prefix = null;
        prefix = conversational ? "BTC_" : "BTR_";
        for (int i = 0; i < dests.length; ++i) {
            String qname = dests[i];
            log.debug((Object)("destination is " + qname));
            if (!qname.equals(prefix + serviceName)) continue;
            log.trace((Object)("find serviceName " + serviceName));
            return true;
        }
        log.trace((Object)("did not find serviceName " + serviceName));
        return false;
    }

    int consumerCount(String serviceName) throws Exception {
        log.trace((Object)("consCount" + serviceName));
        boolean conversational = false;
        if (!serviceName.startsWith(".")) {
            conversational = (Boolean)this.prop.get("blacktie." + serviceName + ".conversational");
        }
        String prefix = null;
        prefix = conversational ? "BTC_" : "BTR_";
        ObjectName objName = new ObjectName("org.hornetq:module=JMS,name=\"" + prefix + serviceName + "\",type=Queue");
        Integer count = (Integer)this.beanServerConnection.getAttribute(objName, "ConsumerCount");
        log.debug((Object)("consCount" + serviceName + " " + count));
        return count;
    }

    Element stringToElement(String s) throws Exception {
        StringReader sreader = new StringReader(s);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document doc = parser.parse(new InputSource(sreader));
        return doc.getDocumentElement();
    }

    String printNode(Node node) {
        try {
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(node);
            trans.transform(source, result);
            String xmlString = sw.toString();
            return xmlString;
        }
        catch (TransformerException e) {
            log.error((Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int deployQueue(String serviceName, String version) {
        log.trace((Object)("deployQueue: " + serviceName + " version: " + version));
        if (version == null || !version.equals(this.prop.getProperty("blacktie.domain.version"))) {
            log.warn((Object)("Blacktie Domain version " + this.prop.getProperty("blacktie.domain.version") + " not match server " + version));
            return 4;
        }
        int result = 0;
        try {
            boolean queue = false;
            queue = this.isDeployQueue(serviceName);
            log.trace((Object)("Queue was created: " + queue));
            boolean created = queue;
            if (!queue) {
                Hashtable<String, Long> hashtable = QUEUE_CREATION_TIMES;
                synchronized (hashtable) {
                    log.trace((Object)serviceName);
                    boolean conversational = false;
                    if (!serviceName.startsWith(".")) {
                        conversational = (Boolean)this.prop.get("blacktie." + serviceName + ".conversational");
                    }
                    String prefix = null;
                    prefix = conversational ? "BTC_" : "BTR_";
                    QUEUE_CREATION_TIMES.put(serviceName, System.currentTimeMillis());
                    log.trace((Object)serviceName);
                    ObjectName objName = new ObjectName("org.hornetq:module=JMS,type=Server");
                    created = (Boolean)this.beanServerConnection.invoke(objName, "createQueue", new Object[]{prefix + serviceName, "/queue/" + prefix + serviceName}, new String[]{"java.lang.String", "java.lang.String"});
                }
            }
            if (!queue || !serviceName.contains(".")) {
                result = 1;
                if (AdministrationProxy.isDomainPause.booleanValue() && serviceName.contains(".")) {
                    log.info((Object)"Domain is pause");
                    result = 3;
                }
            } else if (serviceName.contains(".") && created && this.consumerCount(serviceName) > 0) {
                log.warn((Object)("can not advertise ADMIN with same id: " + serviceName));
                result = 2;
            } else if (AdministrationProxy.isDomainPause.booleanValue()) {
                log.info((Object)"Domain is pause");
                result = 3;
            } else {
                result = 1;
            }
        }
        catch (Throwable t) {
            log.error((Object)("Could not deploy queue of " + serviceName), t);
        }
        return result;
    }

    int undeployQueue(String serviceName) {
        int result = 0;
        try {
            if (this.isDeployQueue(serviceName)) {
                log.trace((Object)serviceName);
                boolean conversational = false;
                if (!serviceName.startsWith(".")) {
                    conversational = (Boolean)this.prop.get("blacktie." + serviceName + ".conversational");
                }
                String prefix = null;
                prefix = conversational ? "BTC_" : "BTR_";
                ObjectName objName = new ObjectName("org.hornetq:module=JMS,type=Server");
                this.beanServerConnection.invoke(objName, "destroyQueue", new Object[]{prefix + serviceName}, new String[]{"java.lang.String"});
            }
            result = 1;
        }
        catch (Throwable t) {
            log.error((Object)("Could not undeploy queue of " + serviceName), t);
        }
        return result;
    }

    int decrementConsumer(String serviceName) {
        log.trace((Object)"decrement");
        int result = 0;
        try {
            int consumerCounts = this.consumerCount(serviceName);
            if (consumerCounts < 1) {
                result = this.undeployQueue(serviceName);
                log.debug((Object)(serviceName + " undeployed"));
            } else {
                result = 1;
                log.debug((Object)(serviceName + " still has " + consumerCounts + " consumers"));
            }
        }
        catch (Throwable t) {
            log.error((Object)("Could not get consumer counts of " + serviceName), t);
        }
        return result;
    }

    public Response tpservice(TPSVCINFO svcinfo) {
        log.debug((Object)"Message received");
        X_OCTET recv = (X_OCTET)svcinfo.getBuffer();
        String string = new String(recv.getByteArray());
        StringTokenizer st = new StringTokenizer(string, ",", false);
        String operation = st.nextToken();
        String serverName = st.nextToken();
        String serviceName = st.nextToken();
        byte[] success = new byte[1];
        String server = null;
        try {
            if (serviceName.indexOf(".") > -1) {
                server = serviceName.substring(1);
                server = server.replaceAll("[0-9]", "");
                List servers = (List)this.prop.get("blacktie.domain.servers");
                if (!servers.contains(server)) {
                    log.warn((Object)("Could not find the server to advertise for: " + server));
                    server = null;
                } else {
                    log.trace((Object)("Located server: " + server));
                }
            } else {
                server = (String)this.prop.get("blacktie." + serviceName + ".server");
            }
            if (server != null && server.equals(serverName)) {
                log.trace((Object)("Service " + serviceName + " exists for server: " + server));
                if (operation.equals("tpadvertise")) {
                    log.trace((Object)("Advertising: " + serviceName));
                    String version = st.nextToken();
                    success[0] = (byte)this.deployQueue(serviceName, version);
                } else if (operation.equals("decrementconsumer")) {
                    log.trace((Object)("Decrement consumer: " + serviceName));
                    success[0] = (byte)this.decrementConsumer(serviceName);
                } else {
                    log.error((Object)("Unknown operation " + operation));
                    success[0] = 0;
                }
            } else {
                log.error((Object)("Service " + serviceName + " cannot be located for server"));
                success[0] = 0;
            }
            X_OCTET buffer = (X_OCTET)svcinfo.getConnection().tpalloc("X_OCTET", null, 1);
            buffer.setByteArray(success);
            log.debug((Object)"Responding");
            return new Response(2, 0, (Buffer)buffer, 0);
        }
        catch (ConnectionException e) {
            return new Response(1, 0, null, 0);
        }
    }
}

