/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.metadata.ContentType;
import org.jboss.as.patching.runner.ContentItemFilter;

public class SkipMiscFilesContentItemFilter
implements ContentItemFilter {
    private final List<Pattern> includedMiscFiles;

    private SkipMiscFilesContentItemFilter(List<Pattern> includedMiscFiles) {
        this.includedMiscFiles = includedMiscFiles;
    }

    static SkipMiscFilesContentItemFilter create(List<String> includedMiscFiles) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        if (includedMiscFiles != null) {
            for (String s : includedMiscFiles) {
                patterns.add(Pattern.compile(s));
            }
        }
        return new SkipMiscFilesContentItemFilter(patterns);
    }

    public boolean accepts(ContentItem item) {
        if (item.getContentType() != ContentType.MISC) {
            return true;
        }
        for (Pattern pattern : this.includedMiscFiles) {
            if (!pattern.matcher(item.getRelativePath()).matches()) continue;
            return true;
        }
        return false;
    }
}

