/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jboss.as.patching.generator.OptionalPath;
import org.jboss.as.patching.generator.PatchBuilderWrapper;
import org.jboss.as.patching.generator.PatchConfig;
import org.jboss.as.patching.generator.PatchElementConfig;
import org.jboss.as.patching.generator.PatchElementConfigBuilder;
import org.jboss.as.patching.generator.PatchGenerator;
import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.metadata.ContentType;
import org.jboss.as.patching.metadata.MiscContentItem;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchElementBuilder;
import org.jboss.as.patching.runner.ContentItemFilter;

class PatchConfigBuilder
implements ContentItemFilter {
    private String patchId = UUID.randomUUID().toString();
    private String description = "no patch description available";
    private String appliesToName;
    private String appliesToVersion;
    private String resultingVersion;
    private Patch.PatchType patchType;
    private boolean generateByDiff = true;
    private Set<String> runtimeUseItems = new HashSet<String>();
    private Set<ContentItem> specifiedContent = new HashSet<ContentItem>();
    private Map<String, PatchElementConfigBuilder> elements = new LinkedHashMap<String, PatchElementConfigBuilder>();
    private List<OptionalPath> optionalPaths = Collections.emptyList();

    PatchConfigBuilder() {
    }

    PatchConfigBuilder setPatchId(String patchId) {
        this.patchId = patchId;
        return this;
    }

    PatchConfigBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    void setPatchType(Patch.PatchType patchType) {
        this.patchType = patchType;
    }

    PatchConfigBuilder setCumulativeType(String appliesToVersion, String resultingVersion) {
        this.patchType = Patch.PatchType.CUMULATIVE;
        this.appliesToVersion = appliesToVersion;
        this.resultingVersion = resultingVersion;
        return this;
    }

    PatchConfigBuilder setOneOffType(String appliesToVersion) {
        assert (appliesToVersion != null) : "appliesToVersion is null";
        this.patchType = Patch.PatchType.ONE_OFF;
        this.appliesToVersion = appliesToVersion;
        return this;
    }

    PatchConfigBuilder setGenerateByDiff(boolean generateByDiff) {
        this.generateByDiff = generateByDiff;
        return this;
    }

    public boolean isGeneratedByDiff() {
        return this.generateByDiff;
    }

    PatchConfigBuilder addRuntimeUseItem(String item) {
        this.runtimeUseItems.add(item);
        return this;
    }

    void setAppliesToName(String appliesToName) {
        this.appliesToName = appliesToName;
    }

    void setAppliesToVersion(String appliesToVersion) {
        this.appliesToVersion = appliesToVersion;
    }

    void setResultingVersion(String resultingVersion) {
        this.resultingVersion = resultingVersion;
    }

    Set<ContentItem> getSpecifiedContent() {
        return this.specifiedContent;
    }

    PatchElementConfigBuilder addElement(String name) {
        PatchElementConfigBuilder builder = new PatchElementConfigBuilder(name, this);
        if (this.elements.put(name, builder) != null) {
            throw PatchGenerator.processingError("duplicate layer %s", name);
        }
        return builder;
    }

    PatchConfigBuilder addOptionalPath(String path) {
        return this.addOptionalPath(path, null);
    }

    PatchConfigBuilder addOptionalPath(String path, String requires) {
        OptionalPath op = new OptionalPath(path, requires);
        switch (this.optionalPaths.size()) {
            case 0: {
                this.optionalPaths = Collections.singletonList(op);
                break;
            }
            case 1: {
                this.optionalPaths = new ArrayList<OptionalPath>(this.optionalPaths);
            }
            default: {
                this.optionalPaths.add(op);
            }
        }
        return this;
    }

    PatchConfig build() {
        return new PatchConfigImpl(new ArrayList<PatchElementConfig>(this.elements.values()));
    }

    public boolean accepts(ContentItem item) {
        if (this.generateByDiff) {
            return true;
        }
        if (item.getContentType() == ContentType.MISC) {
            for (ContentItem s : this.specifiedContent) {
                if (!this.accepts((MiscContentItem)item, (MiscContentItem)s)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean accepts(MiscContentItem one, MiscContentItem two) {
        return one.getName().equals(two.getName()) && one.getRelativePath().equals(two.getRelativePath());
    }

    class PatchConfigImpl
    implements PatchConfig {
        private Collection<PatchElementConfig> elements;

        PatchConfigImpl(Collection<PatchElementConfig> elements) {
            this.elements = elements;
        }

        @Override
        public String getPatchId() {
            return PatchConfigBuilder.this.patchId;
        }

        @Override
        public String getDescription() {
            return PatchConfigBuilder.this.description;
        }

        @Override
        public Patch.PatchType getPatchType() {
            return PatchConfigBuilder.this.patchType;
        }

        @Override
        public Set<String> getInRuntimeUseItems() {
            return PatchConfigBuilder.this.runtimeUseItems;
        }

        @Override
        public String getAppliesToProduct() {
            return PatchConfigBuilder.this.appliesToName;
        }

        @Override
        public String getAppliesToVersion() {
            return PatchConfigBuilder.this.appliesToVersion;
        }

        @Override
        public String getResultingVersion() {
            return PatchConfigBuilder.this.resultingVersion;
        }

        @Override
        public boolean isGenerateByDiff() {
            return PatchConfigBuilder.this.generateByDiff;
        }

        @Override
        public Set<ContentItem> getSpecifiedContent() {
            return PatchConfigBuilder.this.specifiedContent;
        }

        @Override
        public Collection<PatchElementConfig> getElements() {
            return this.elements;
        }

        @Override
        public Collection<OptionalPath> getOptionalPaths() {
            return PatchConfigBuilder.this.optionalPaths;
        }

        @Override
        public PatchBuilderWrapper toPatchBuilder() {
            PatchBuilderWrapper wrapper = new PatchBuilderWrapper(){

                @Override
                PatchElementBuilder modifyLayer(String name, boolean addOn) {
                    PatchElementConfigBuilder config = (PatchElementConfigBuilder)PatchConfigBuilder.this.elements.get(name);
                    if (config == null) {
                        return null;
                    }
                    if (config.getPatchType() == null) {
                        config.setPatchType(PatchConfigBuilder.this.patchType);
                    }
                    PatchElementBuilder builder = PatchConfigBuilder.this.patchType == Patch.PatchType.CUMULATIVE ? this.upgradeElement(config.getPatchId(), name, addOn) : this.oneOffPatchElement(config.getPatchId(), name, addOn);
                    if (config.getDescription() != null) {
                        builder.setDescription(config.getDescription());
                    }
                    builder.setContentItemFilter((ContentItemFilter)config);
                    return builder;
                }
            };
            wrapper.setDescription(PatchConfigBuilder.this.description);
            wrapper.setPatchId(PatchConfigBuilder.this.patchId);
            wrapper.setContentItemFilter(PatchConfigBuilder.this);
            return wrapper;
        }
    }

    public static enum AffectsType {
        UPDATED,
        ORIGINAL,
        BOTH,
        NONE;

    }
}

