/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.generator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jboss.as.patching.generator.Distribution;
import org.jboss.as.patching.generator.DistributionContentItem;
import org.jboss.as.patching.generator.DistributionModuleItem;
import org.jboss.as.patching.generator.OptionalPath;
import org.jboss.as.patching.generator.PatchGenerator;
import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.metadata.MiscContentItem;
import org.jboss.as.patching.metadata.ModificationBuilderTarget;
import org.jboss.as.patching.metadata.ModificationCondition;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchBuilder;
import org.jboss.as.patching.metadata.PatchElementBuilder;

abstract class PatchBuilderWrapper
extends PatchBuilder {
    private FSPathElement optionalPaths = new FSPathElement("root");

    protected PatchBuilderWrapper() {
    }

    void setOptionalPaths(Collection<OptionalPath> optionalPaths) {
        for (OptionalPath path : optionalPaths) {
            String[] split = path.getValue().split("/");
            FSPathElement e = this.optionalPaths.addChild(split);
            if (path.getRequires() == null) continue;
            FSPathElement.access$002(e, path.getRequires().split("/"));
        }
    }

    abstract PatchElementBuilder modifyLayer(String var1, boolean var2);

    protected Patch compare(Distribution base, Distribution updated, boolean includeVersion) {
        PatchBuilderWrapper.compare(this, base, updated, includeVersion);
        return this.build();
    }

    protected PatchElementBuilder addLayer(String layer) {
        throw PatchGenerator.processingError("invalid layer configuration for %s", layer);
    }

    protected PatchElementBuilder modifyLayer(String layer) {
        return this.modifyLayer(layer, false);
    }

    protected PatchElementBuilder removeLayer(String layer) {
        throw PatchGenerator.processingError("invalid layer configuration for %s", layer);
    }

    protected PatchElementBuilder addAddOn(String layer) {
        throw PatchGenerator.processingError("invalid add-on configuration for %s", layer);
    }

    protected PatchElementBuilder modifyAddOn(String layer) {
        return this.modifyLayer(layer, true);
    }

    protected PatchElementBuilder removeAddOn(String layer) {
        throw PatchGenerator.processingError("invalid add-on configuration for %s", layer);
    }

    static void compare(PatchBuilderWrapper builder, Distribution original, Distribution updated, boolean includeVersion) {
        Distribution.ProcessedLayer updatedLayer;
        PatchElementBuilder elementBuilder;
        Distribution.ProcessedLayer originalLayer;
        DistributionContentItem or = original.getRoot();
        DistributionContentItem nr = updated.getRoot();
        PatchBuilderWrapper.compareMiscFiles(builder, or, nr, builder.optionalPaths);
        LinkedHashSet<String> originalLayers = new LinkedHashSet<String>(original.getLayers());
        LinkedHashSet<String> updatedLayers = new LinkedHashSet<String>(updated.getLayers());
        for (String layer : originalLayers) {
            originalLayer = original.getLayer(layer);
            if (updatedLayers.remove(layer)) {
                elementBuilder = builder.modifyLayer(layer);
                updatedLayer = updated.getLayer(layer);
            } else {
                elementBuilder = builder.removeLayer(layer);
                updatedLayer = null;
            }
            PatchBuilderWrapper.compareLayer(layer, elementBuilder, originalLayer, updatedLayer, includeVersion);
        }
        for (String layer : updatedLayers) {
            originalLayer = null;
            updatedLayer = updated.getLayer(layer);
            elementBuilder = builder.addLayer(layer);
            PatchBuilderWrapper.compareLayer(layer, elementBuilder, originalLayer, updatedLayer, includeVersion);
        }
        LinkedHashSet<String> originalAddOns = new LinkedHashSet<String>(original.getAddOns());
        LinkedHashSet<String> updatedAddOns = new LinkedHashSet<String>(updated.getAddOns());
        for (String addOn : originalAddOns) {
            Distribution.ProcessedLayer updatedLayer2;
            PatchElementBuilder elementBuilder2;
            Distribution.ProcessedLayer originalLayer2 = original.getAddOn(addOn);
            if (updatedAddOns.remove(addOn)) {
                elementBuilder2 = builder.modifyAddOn(addOn);
                updatedLayer2 = updated.getAddOn(addOn);
            } else {
                elementBuilder2 = builder.removeAddOn(addOn);
                updatedLayer2 = null;
            }
            PatchBuilderWrapper.compareLayer(addOn, elementBuilder2, originalLayer2, updatedLayer2, includeVersion);
        }
        for (String addOn : updatedAddOns) {
            elementBuilder = builder.addAddOn(addOn);
            PatchBuilderWrapper.compareLayer(addOn, elementBuilder, null, updated.getAddOn(addOn), includeVersion);
        }
    }

    static void compareLayer(String layer, PatchElementBuilder elementBuilder, Distribution.ProcessedLayer originalLayer, Distribution.ProcessedLayer updatedLayer, boolean includeVersion) {
        PatchBuilderWrapper.compareModuleItems(layer, elementBuilder, originalLayer.getModules(), updatedLayer.getModules(), false, includeVersion);
        PatchBuilderWrapper.compareModuleItems(layer, elementBuilder, originalLayer.getBundles(), updatedLayer.getBundles(), true, false);
    }

    static void compareModuleItems(String layer, PatchElementBuilder elementBuilder, Collection<DistributionModuleItem> original, Collection<DistributionModuleItem> updated, boolean bundle, boolean includeVersion) {
        HashMap<String, DistributionModuleItem> modules = new HashMap<String, DistributionModuleItem>();
        for (DistributionModuleItem item : updated) {
            modules.put(item.getFullModuleName(), item);
        }
        for (DistributionModuleItem o : original) {
            DistributionModuleItem n = (DistributionModuleItem)modules.remove(o.getFullModuleName());
            if (n == null) {
                if (elementBuilder == null) {
                    throw PatchGenerator.processingError("missing patch-config for layer/add-on %s", layer);
                }
                if (bundle) {
                    elementBuilder.removeBundle(o.getName(), o.getSlot(), o.getMetadataHash());
                    continue;
                }
                elementBuilder.removeModule(o.getName(), o.getSlot(), o.getMetadataHash());
                continue;
            }
            if (!Arrays.equals(n.getComparisonHash(), o.getComparisonHash())) {
                if (elementBuilder == null) {
                    throw PatchGenerator.processingError("missing patch-config for layer/add-on %s", layer);
                }
                if (bundle) {
                    elementBuilder.modifyBundle(n.getName(), n.getSlot(), o.getMetadataHash(), n.getMetadataHash());
                    continue;
                }
                elementBuilder.modifyModule(n.getName(), n.getSlot(), o.getMetadataHash(), n.getMetadataHash());
                continue;
            }
            if (!includeVersion || !n.getName().equals("org.jboss.as.version") || Arrays.equals(o.getMetadataHash(), n.getMetadataHash())) continue;
            if (elementBuilder == null) {
                throw PatchGenerator.processingError("missing patch-config for layer/add-on %s", layer);
            }
            elementBuilder.modifyModule(n.getName(), n.getSlot(), o.getMetadataHash(), n.getMetadataHash());
        }
        if (!modules.isEmpty()) {
            if (elementBuilder == null) {
                throw PatchGenerator.processingError("missing patch-config for layer/add-on %s", layer);
            }
            for (DistributionModuleItem item : modules.values()) {
                if (bundle) {
                    elementBuilder.addBundle(item.getName(), item.getSlot(), item.getMetadataHash());
                    continue;
                }
                elementBuilder.addModule(item.getName(), item.getSlot(), item.getMetadataHash());
            }
        }
    }

    static void compareMiscFiles(ModificationBuilderTarget<?> builder, DistributionContentItem o, DistributionContentItem n, FSPathElement optionalPaths) {
        if (o == null && n == null) {
            return;
        }
        if (o != null && n == null) {
            builder.removeFile(o.getName(), o.getParent().getPathAsList(), o.getMetadataHash(), !o.isLeaf(), PatchBuilderWrapper.getCondition(optionalPaths, o));
        } else if (o == null && n != null) {
            boolean directory;
            boolean bl = directory = !n.isLeaf();
            if (directory) {
                for (DistributionContentItem child : n.getChildren()) {
                    PatchBuilderWrapper.compareMiscFiles(builder, null, child, optionalPaths);
                }
            } else {
                builder.addFile(n.getName(), n.getParent().getPathAsList(), n.getMetadataHash(), directory, PatchBuilderWrapper.getCondition(optionalPaths, n));
            }
        } else {
            if (!n.equals(o)) {
                throw PatchGenerator.processingError("TODO", new Object[0]);
            }
            if (n.isLeaf() != o.isLeaf()) {
                throw PatchGenerator.processingError("TODO", new Object[0]);
            }
            if (n.isLeaf() && !Arrays.equals(o.getComparisonHash(), n.getComparisonHash())) {
                builder.modifyFile(n.getName(), n.getParent().getPathAsList(), o.getMetadataHash(), n.getMetadataHash(), !n.isLeaf(), PatchBuilderWrapper.getCondition(optionalPaths, o));
            } else {
                Collection<DistributionContentItem> nc = n.getChildren();
                HashMap<String, DistributionContentItem> children = new HashMap<String, DistributionContentItem>();
                for (DistributionContentItem child : nc) {
                    children.put(child.getName(), child);
                }
                for (DistributionContentItem child : o.getChildren()) {
                    DistributionContentItem item = (DistributionContentItem)children.remove(child.getName());
                    PatchBuilderWrapper.compareMiscFiles(builder, child, item, optionalPaths);
                }
                for (DistributionContentItem child : children.values()) {
                    PatchBuilderWrapper.compareMiscFiles(builder, null, child, optionalPaths);
                }
            }
        }
    }

    static ModificationCondition getCondition(FSPathElement optionalPaths, DistributionContentItem item) {
        if (optionalPaths.children.isEmpty()) {
            return null;
        }
        FSPathElement e = new FSPathElement(optionalPaths);
        List<String> path = PatchBuilderWrapper.matchOptionalPath(e, item);
        if (path == null) {
            return null;
        }
        MiscContentItem misc = e.requires != null ? new MiscContentItem(e.requires[0], Arrays.asList(Arrays.copyOf(e.requires, e.requires.length - 1)), null, false) : new MiscContentItem(e.name, path, null, true);
        return ModificationCondition.Factory.exists((ContentItem)misc);
    }

    static List<String> matchOptionalPath(FSPathElement root, DistributionContentItem item) {
        if (item.getParent() == null || item.getParent().name == null) {
            FSPathElement dir = root.getMatchingElement(item.getName());
            if (dir != null) {
                root.linkTo(dir);
                return Collections.emptyList();
            }
            return null;
        }
        List<String> path = PatchBuilderWrapper.matchOptionalPath(root, item.getParent());
        if (path == null) {
            return null;
        }
        if (root.children.isEmpty()) {
            return path;
        }
        FSPathElement dir = root.getMatchingElement(item.getName());
        if (dir != null) {
            switch (path.size()) {
                case 0: {
                    path = Collections.singletonList(root.name);
                    break;
                }
                case 1: {
                    path = new ArrayList<String>(path);
                }
                default: {
                    path.add(root.name);
                }
            }
            root.linkTo(dir);
            return path;
        }
        return null;
    }

    private static final class FSPathElement {
        private String name;
        private boolean containsWildcard;
        private Map<String, FSPathElement> children = Collections.emptyMap();
        private String[] requires;

        FSPathElement(String name) {
            this(null, name);
        }

        FSPathElement(FSPathElement parent, String name) {
            assert (name != null) : "name is null";
            this.containsWildcard = name.charAt(name.length() - 1) == '*';
            String string = this.name = this.containsWildcard ? name.substring(0, name.length() - 1) : name;
            if (parent != null) {
                parent.addChild(this);
            }
        }

        FSPathElement(FSPathElement linkTo) {
            this.containsWildcard = linkTo.containsWildcard;
            this.name = linkTo.name;
            this.children = linkTo.children;
        }

        FSPathElement getMatchingElement(String targetName) {
            for (FSPathElement child : this.children.values()) {
                if (!child.matches(targetName)) continue;
                return child;
            }
            return null;
        }

        boolean matches(String targetName) {
            if (this.containsWildcard) {
                return targetName.startsWith(this.name);
            }
            return this.name.equals(targetName);
        }

        FSPathElement addChild(String ... names) {
            FSPathElement parent = this;
            FSPathElement child = null;
            for (String name : names) {
                child = parent.children.get(name);
                if (child == null) {
                    child = new FSPathElement(parent, name);
                }
                parent = child;
            }
            return child;
        }

        boolean addChild(FSPathElement child) {
            switch (this.children.size()) {
                case 0: {
                    this.children = Collections.singletonMap(child.name, child);
                    break;
                }
                case 1: {
                    this.children = new HashMap<String, FSPathElement>(this.children);
                }
                default: {
                    this.children.put(child.name, child);
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            this.toString(buf, 0);
            return buf.toString();
        }

        private void toString(StringBuilder buf, int depth) {
            for (int i = 0; i < depth; ++i) {
                buf.append("  ");
            }
            buf.append(this.name).append("\n");
            for (FSPathElement child : this.children.values()) {
                child.toString(buf, depth + 1);
            }
        }

        void linkTo(FSPathElement dir) {
            this.containsWildcard = dir.containsWildcard;
            this.name = dir.name;
            this.children = dir.children;
            this.requires = dir.requires;
        }

        static /* synthetic */ String[] access$002(FSPathElement x0, String[] x1) {
            x0.requires = x1;
            return x1;
        }
    }
}

