/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.generator;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.jboss.as.patching.generator.DistributionContentItem;
import org.jboss.as.patching.generator.ModuleDiffUtils;

class JarDiffUtils {
    private static final boolean USE_METADATA_HASH = Boolean.getBoolean("patch.gen.use.metadata.hash");
    private static final Set<String> ignoredManifestAttributes = new HashSet<String>();

    JarDiffUtils() {
    }

    public static byte[] calculateHash(File root, DistributionContentItem item) throws NoSuchAlgorithmException, IOException {
        if (USE_METADATA_HASH) {
            return item.getMetadataHash();
        }
        File moduleXml = new File(root, "module.xml");
        if (moduleXml.exists()) {
            return ModuleDiffUtils.processModule(root, item.getParent().getPath('.'), item.getMetadataHash());
        }
        if (root.getName().equals(".jar")) {
            return JarDiffUtils.internalJarComparison(root);
        }
        return item.getMetadataHash();
    }

    public static byte[] internalJarComparison(File file) throws NoSuchAlgorithmException, IOException {
        MessageDigest jarDigest = MessageDigest.getInstance("SHA1");
        JarDiffUtils.internalJarComparison(file, jarDigest, true);
        return jarDigest.digest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void internalJarComparison(File file, MessageDigest jarDigest, boolean debug) throws NoSuchAlgorithmException, IOException {
        TreeSet<Entry> entries = new TreeSet<Entry>();
        MessageDigest digest = MessageDigest.getInstance("SHA1");
        try (JarInputStream in = new JarInputStream(new BufferedInputStream(new FileInputStream(file)));){
            JarEntry entry;
            while ((entry = in.getNextJarEntry()) != null) {
                int l;
                String name;
                if (entry.isDirectory() || (name = entry.getName()).startsWith("META-INF/") && (name.endsWith(".SF") || name.endsWith(".DSA")) || name.equals("META-INF/INDEX.LIST") || name.startsWith("META-INF/maven/") && (name.endsWith("/pom.properties") || name.endsWith("/pom.xml") || name.endsWith("/effective-pom.xml")) || name.endsWith(".class") && (name.endsWith("_$bundle.class") || name.endsWith("_$logger.class") || name.contains("_$bundle_") || name.contains("_$logger_"))) continue;
                digest.reset();
                Object buf = new byte[4096];
                while ((l = in.read((byte[])buf)) > 0) {
                    digest.update((byte[])buf, 0, l);
                }
                byte[] d = digest.digest();
                entries.add(new Entry(name, d));
            }
        }
        Manifest manifest = in.getManifest();
        if (manifest != null) {
            digest.reset();
            Attributes attributes = manifest.getMainAttributes();
            for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
                String name = entry.getKey().toString();
                if (ignoredManifestAttributes.contains(name)) continue;
                String value = (String)entry.getValue();
                digest.update(name.getBytes());
                digest.update(value.getBytes());
            }
            entries.add(new Entry("META-INF/MANIFEST.MF", digest.digest()));
        }
        for (Entry entry : entries) {
            byte[] hash = entry.getHash();
            if (hash == null) continue;
            jarDigest.update(hash);
        }
    }

    static {
        ignoredManifestAttributes.add("Archiver-Version");
        ignoredManifestAttributes.add("Bnd-LastModified");
        ignoredManifestAttributes.add("Built-By");
        ignoredManifestAttributes.add("Build-Jdk");
        ignoredManifestAttributes.add("Build-Timestamp");
        ignoredManifestAttributes.add("Created-By");
        ignoredManifestAttributes.add("Implementation-Version");
        ignoredManifestAttributes.add("Java-Vendor");
        ignoredManifestAttributes.add("Java-Version");
        ignoredManifestAttributes.add("JBossAS-Release-Version");
        ignoredManifestAttributes.add("Os-Arch");
        ignoredManifestAttributes.add("Os-Name");
        ignoredManifestAttributes.add("Os-Version");
        ignoredManifestAttributes.add("Scm-Revision");
        ignoredManifestAttributes.add("Specification-Version");
    }

    static class Entry
    implements Comparable<Entry> {
        final String name;
        final byte[] hash;

        Entry(String name, byte[] hash) {
            this.name = name;
            this.hash = hash;
        }

        String getName() {
            return this.name;
        }

        byte[] getHash() {
            return this.hash;
        }

        @Override
        public int compareTo(Entry o) {
            return this.name.compareTo(o.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return this.name.equals(entry.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

