/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.security.jaspi;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Random;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.authenticator.Constants;
import org.apache.catalina.connector.Request;
import org.apache.catalina.deploy.LoginConfig;
import org.jboss.as.web.WebLogger;
import org.jboss.as.web.security.JBossGenericPrincipal;
import org.jboss.as.web.security.JBossWebRealm;
import org.jboss.as.web.security.jaspi.SecurityActions;
import org.jboss.as.web.security.jaspi.WebJASPICallbackHandler;
import org.jboss.security.SecurityContext;
import org.jboss.security.ServerAuthenticationManager;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.callback.JBossCallbackHandler;
import org.jboss.security.auth.message.GenericMessageInfo;
import org.jboss.security.plugins.auth.JASPIServerAuthenticationManager;

public class WebJASPIAuthenticator
extends AuthenticatorBase {
    protected final String messageLayer = "HttpServlet";
    protected String serverAuthenticationManagerClass;
    protected boolean secureResponse;

    protected boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        boolean result = false;
        String authMethod = config.getAuthMethod();
        Principal principal = request.getUserPrincipal();
        String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
        if (principal != null) {
            WebLogger.WEB_SECURITY_LOGGER.tracef("Already authenticated '%s'", principal.getName());
            if (ssoId != null) {
                this.associate(ssoId, request.getSessionInternal(true));
            }
            return true;
        }
        if (("BASIC".equalsIgnoreCase(authMethod) || "FORM".equalsIgnoreCase(authMethod)) && ssoId != null) {
            WebLogger.WEB_SECURITY_LOGGER.tracef("SSO Id %s set; attempting reauthentication", ssoId);
            if (this.reauthenticateFromSSO(ssoId, request)) {
                return true;
            }
        }
        GenericMessageInfo messageInfo = new GenericMessageInfo();
        messageInfo.setRequestMessage((Object)request);
        messageInfo.setResponseMessage((Object)request.getResponse());
        messageInfo.getMap().put("CACHE", String.valueOf(this.cache));
        messageInfo.getMap().put("javax.security.auth.message.MessagePolicy.isMandatory", "true");
        WebJASPICallbackHandler cbh = new WebJASPICallbackHandler();
        ServerAuthenticationManager sam = this.getServerAuthenticationManager();
        String appContext = request.getLocalName() + " " + request.getContextPath();
        Subject clientSubject = new Subject();
        if (sam != null) {
            result = sam.isValid((MessageInfo)messageInfo, clientSubject, "HttpServlet", appContext, (CallbackHandler)cbh);
        }
        if (result) {
            PasswordValidationCallback pvc = cbh.getPasswordValidationCallback();
            CallerPrincipalCallback cpc = cbh.getCallerPrincipalCallback();
            Principal clientPrincipal = cpc.getPrincipal();
            if (clientPrincipal == null) {
                clientPrincipal = new SimplePrincipal(cpc.getName());
            }
            if (!(clientPrincipal instanceof JBossGenericPrincipal)) {
                clientPrincipal = this.buildJBossPrincipal(clientSubject, clientPrincipal);
            }
            this.register(request, response, clientPrincipal, authMethod, pvc.getUsername(), new String(pvc.getPassword()));
            if (this.secureResponse) {
                sam.secureResponse((MessageInfo)messageInfo, new Subject(), "HttpServlet", appContext, (CallbackHandler)cbh);
            }
        }
        return result;
    }

    public String getServerAuthenticationManagerClass() {
        return this.serverAuthenticationManagerClass;
    }

    public void setServerAuthenticationManagerClass(String serverAuthenticationManagerClass) {
        this.serverAuthenticationManagerClass = serverAuthenticationManagerClass;
    }

    public boolean getSecureResponse() {
        return this.secureResponse;
    }

    public void setSecureResponse(boolean secureResponse) {
        this.secureResponse = secureResponse;
    }

    protected ServerAuthenticationManager getServerAuthenticationManager() {
        ServerAuthenticationManager sam = null;
        if (this.serverAuthenticationManagerClass == null) {
            SecurityContext context = SecurityActions.getSecurityContext();
            if (context != null) {
                WebLogger.WEB_SECURITY_LOGGER.debugf("Instantiating JASPI authentication manager with security domain %s", context.getSecurityDomain());
                sam = new JASPIServerAuthenticationManager(context.getSecurityDomain(), (CallbackHandler)new JBossCallbackHandler());
            } else {
                WebLogger.WEB_SECURITY_LOGGER.debugf("Security context is null, instantiating JASPI authentication manager with default domain", new Object[0]);
                sam = new JASPIServerAuthenticationManager();
            }
        } else {
            try {
                Class<?> clazz = SecurityActions.loadClass(this.serverAuthenticationManagerClass);
                sam = (ServerAuthenticationManager)clazz.newInstance();
            }
            catch (Exception e) {
                WebLogger.WEB_SECURITY_LOGGER.noServerAuthenticationManager(e);
            }
        }
        return sam;
    }

    protected void register(Request request, HttpServletResponse response, Principal principal, String authType, String username, String password) {
        if (WebLogger.WEB_SECURITY_LOGGER.isTraceEnabled()) {
            String name = principal == null ? "none" : principal.getName();
            WebLogger.WEB_SECURITY_LOGGER.tracef("Authenticated '%s' with type '" + authType + "'", name, authType);
        }
        request.setAuthType(authType);
        request.setUserPrincipal(principal);
        Session session = request.getSessionInternal(false);
        if (this.cache && session != null) {
            session.setAuthType(authType);
            session.setPrincipal(principal);
            if (username != null) {
                session.setNote("org.apache.catalina.session.USERNAME", (Object)username);
            } else {
                session.removeNote("org.apache.catalina.session.USERNAME");
            }
            if (password != null) {
                session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
            } else {
                session.removeNote("org.apache.catalina.session.PASSWORD");
            }
        }
        if (this.sso == null) {
            return;
        }
        String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
        if (ssoId == null) {
            ssoId = this.generateSessionId(new Random());
            Cookie cookie = new Cookie(Constants.SINGLE_SIGN_ON_COOKIE, ssoId);
            cookie.setMaxAge(-1);
            cookie.setPath("/");
            cookie.setSecure(request.isSecure());
            String ssoDomain = this.sso.getCookieDomain();
            if (ssoDomain != null) {
                cookie.setDomain(ssoDomain);
            }
            response.addCookie(cookie);
            this.sso.register(ssoId, principal, authType, username, password);
            request.setNote("org.apache.catalina.request.SSOID", (Object)ssoId);
        } else {
            this.sso.update(ssoId, principal, authType, username, password);
        }
        if (session == null) {
            session = request.getSessionInternal(true);
        }
        this.sso.associate(ssoId, session);
    }

    protected Principal buildJBossPrincipal(Subject subject, Principal principal) {
        ArrayList<String> roles = new ArrayList<String>();
        for (Principal p : subject.getPrincipals()) {
            if (!(p instanceof Group) || !p.getName().equals("Roles")) continue;
            Enumeration members = ((Group)p).members();
            while (members.hasMoreElements()) {
                roles.add(((Principal)members.nextElement()).getName());
            }
        }
        JBossWebRealm realm = (JBossWebRealm)this.getContainer().getRealm();
        if (roles.isEmpty()) {
            roles.addAll((Collection)realm.getPrincipalVersusRolesMap().get(principal.getName()));
        }
        return new JBossGenericPrincipal((Realm)realm, principal.getName(), null, roles, principal, null, null, null, subject);
    }
}

