/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.security;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.jboss.as.security.service.JaccService;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionMetaData;

public class WarJaccService
extends JaccService<WarMetaData> {
    private static final int PREFIX = 1;
    private static final int EXTENSION = 2;
    private static final int DEFAULT = 3;
    private static final int EXACT = 4;
    private Context context;

    public void setContext(Context context) {
        this.context = context;
    }

    public WarJaccService(String contextId, WarMetaData metaData, Boolean standalone) {
        super(contextId, (Object)metaData, standalone);
    }

    public void createPermissions(WarMetaData metaData, PolicyConfiguration pc) throws PolicyContextException {
        String servletName;
        int i;
        if (this.context == null) {
            throw WebMessages.MESSAGES.noCatalinaContextForJacc();
        }
        HashMap<String, PatternInfo> patternMap = WarJaccService.qualifyURLPatterns(this.context);
        log.debugf("Qualified url patterns: " + patternMap, new Object[0]);
        SecurityConstraint[] constraints = this.context.findConstraints();
        for (int i2 = 0; i2 < constraints.length; ++i2) {
            PatternInfo info;
            String url;
            int n;
            String[] urlPatterns;
            String[] httpMethods;
            SecurityCollection wrc;
            int j;
            SecurityConstraint sc = constraints[i2];
            SecurityCollection[] resources = sc.findCollections();
            String transport = sc.getUserConstraint();
            if (sc.getAuthConstraint() && sc.findAuthRoles().length == 0 && !sc.getAllRoles() || !sc.getAuthConstraint()) {
                for (j = 0; j < resources.length; ++j) {
                    wrc = resources[j];
                    httpMethods = wrc.findMethods();
                    urlPatterns = wrc.findPatterns();
                    for (n = 0; n < urlPatterns.length; ++n) {
                        url = urlPatterns[n];
                        info = patternMap.get(url);
                        if (sc.getAuthConstraint() && sc.findAuthRoles().length == 0 && !sc.getAllRoles()) {
                            info.addExcludedMethods(Arrays.asList(httpMethods));
                        }
                        if (sc.getAuthConstraint()) continue;
                        info.isMissingAuthConstraint = true;
                    }
                }
                continue;
            }
            for (j = 0; j < resources.length; ++j) {
                wrc = resources[j];
                httpMethods = wrc.findMethods();
                urlPatterns = wrc.findPatterns();
                for (n = 0; n < urlPatterns.length; ++n) {
                    url = urlPatterns[n];
                    info = patternMap.get(url);
                    HashSet<String> mappedRoles = new HashSet<String>();
                    String[] authRoles = sc.findAuthRoles();
                    for (int k = 0; k < authRoles.length; ++k) {
                        String role = authRoles[k];
                        mappedRoles.add(role);
                    }
                    if (authRoles.length == 0 && sc.getAllRoles()) {
                        if (metaData.getMergedJBossWebMetaData().isJaccAllStoreRole()) {
                            mappedRoles.add("*");
                        } else {
                            String[] roles = this.context.findSecurityRoles();
                            for (int l = 0; l < roles.length; ++l) {
                                String role = roles[l];
                                mappedRoles.add(role);
                            }
                        }
                    }
                    info.addRoles(mappedRoles, Arrays.asList(httpMethods));
                    info.addTransport(transport, Arrays.asList(httpMethods));
                }
            }
        }
        for (PatternInfo info : patternMap.values()) {
            String qurl = info.getQualifiedPattern();
            if (info.isOverriden) {
                log.debugf("Dropping overriden pattern: " + info, new Object[0]);
                continue;
            }
            String[] httpMethods = info.getExcludedMethods();
            if (httpMethods != null) {
                WebResourcePermission wrp = new WebResourcePermission(qurl, httpMethods);
                WebUserDataPermission wudp = new WebUserDataPermission(qurl, httpMethods, null);
                pc.addToExcludedPolicy((Permission)wrp);
                pc.addToExcludedPolicy((Permission)wudp);
                String excludedString = "!" + WarJaccService.getCommaSeparatedString(httpMethods);
                WebResourcePermission wrp1 = new WebResourcePermission(info.pattern, excludedString);
                WebUserDataPermission wudp1 = new WebUserDataPermission(info.pattern, excludedString);
                pc.addToUncheckedPolicy((Permission)wrp1);
                pc.addToUncheckedPolicy((Permission)wudp1);
            }
            Iterator<Map.Entry<String, Set<String>>> roles = info.getRoleMethods();
            while (roles.hasNext()) {
                WebResourcePermission wrp;
                Map.Entry<String, Set<String>> roleMethods = roles.next();
                String role = roleMethods.getKey();
                if ("*".equals(role)) {
                    wrp = new WebResourcePermission(qurl, (String)null);
                } else {
                    Set<String> methods = roleMethods.getValue();
                    httpMethods = new String[methods.size()];
                    methods.toArray(httpMethods);
                    wrp = new WebResourcePermission(qurl, httpMethods);
                }
                pc.addToRole(role, (Permission)wrp);
                if (httpMethods == null) continue;
                WebResourcePermission wrpUnchecked = new WebResourcePermission(info.pattern, "!" + WarJaccService.getCommaSeparatedString(httpMethods));
                pc.addToUncheckedPolicy((Permission)wrpUnchecked);
            }
            String[] missingHttpMethods = info.getMissingMethods();
            if (missingHttpMethods.length > 0) {
                WebResourcePermission wrp = new WebResourcePermission(qurl, missingHttpMethods);
                pc.addToUncheckedPolicy((Permission)wrp);
            } else {
                pc.addToUncheckedPolicy((Permission)new WebResourcePermission(qurl, (String)null));
            }
            if (info.isMissingAuthConstraint) {
                pc.addToUncheckedPolicy((Permission)new WebResourcePermission(qurl, (String)null));
            }
            Iterator<Map.Entry<String, Set<String>>> transportContraints = info.getTransportMethods();
            while (transportContraints.hasNext()) {
                Map.Entry<String, Set<String>> transportMethods = transportContraints.next();
                String transport = transportMethods.getKey();
                Set<String> methods = transportMethods.getValue();
                httpMethods = new String[methods.size()];
                methods.toArray(httpMethods);
                WebUserDataPermission wudp = new WebUserDataPermission(qurl, httpMethods, transport);
                pc.addToUncheckedPolicy((Permission)wudp);
                if ("NONE".equals(transport)) {
                    WebUserDataPermission wudp1 = new WebUserDataPermission(info.pattern, null);
                    pc.addToUncheckedPolicy((Permission)wudp1);
                    continue;
                }
                if (httpMethods == null) continue;
                WebUserDataPermission wudpNonNull = new WebUserDataPermission(info.pattern, "!" + WarJaccService.getCommaSeparatedString(httpMethods));
                pc.addToUncheckedPolicy((Permission)wudpNonNull);
            }
        }
        String[] unreferencedRoles = this.context.findSecurityRoles();
        ArrayList<String> unRefRoles = new ArrayList<String>();
        for (int i3 = 0; i3 < unreferencedRoles.length; ++i3) {
            unRefRoles.add(unreferencedRoles[i3]);
        }
        Container[] servlets = this.context.findChildren();
        for (i = 0; i < servlets.length; ++i) {
            Wrapper servlet = (Wrapper)servlets[i];
            servletName = servlet.getName();
            String[] roleRefs = servlet.findSecurityReferences();
            for (int j = 0; j < roleRefs.length; ++j) {
                String roleRef = roleRefs[j];
                String roleName = servlet.findSecurityReference(roleRef);
                WebRoleRefPermission wrrp = new WebRoleRefPermission(servletName, roleRef);
                pc.addToRole(roleName, (Permission)wrrp);
                wrrp = new WebRoleRefPermission(servletName, roleName);
                pc.addToRole(roleRef, (Permission)wrrp);
                unRefRoles.remove(roleName);
            }
            for (String unrefRole : unRefRoles) {
                WebRoleRefPermission unrefP = new WebRoleRefPermission(servletName, unrefRole);
                pc.addToRole(unrefRole, (Permission)unrefP);
            }
        }
        for (i = 0; i < unreferencedRoles.length; ++i) {
            String unreferencedRole = unreferencedRoles[i];
            WebRoleRefPermission wrrep = new WebRoleRefPermission("", unreferencedRole);
            pc.addToRole(unreferencedRole, (Permission)wrrep);
        }
        for (i = 0; i < servlets.length; ++i) {
            Wrapper servlet = (Wrapper)servlets[i];
            servletName = servlet.getName();
            for (int j = 0; j < unreferencedRoles.length; ++j) {
                String role = unreferencedRoles[j];
                WebRoleRefPermission wrrp = new WebRoleRefPermission(servletName, role);
                pc.addToRole(role, (Permission)wrrp);
            }
        }
    }

    static String getCommaSeparatedString(String[] str) {
        int len = str.length;
        Arrays.sort(str);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(str[i]);
        }
        return buf.toString();
    }

    static int getPatternType(String urlPattern) {
        int type = 4;
        if (urlPattern.startsWith("*.")) {
            type = 2;
        } else if (urlPattern.startsWith("/") && urlPattern.endsWith("/*")) {
            type = 1;
        } else if (urlPattern.equals("/")) {
            type = 3;
        }
        return type;
    }

    static HashMap<String, PatternInfo> qualifyURLPatterns(Context metaData) {
        PatternInfo info3;
        int i;
        ArrayList<PatternInfo> prefixList = new ArrayList<PatternInfo>();
        ArrayList<PatternInfo> extensionList = new ArrayList<PatternInfo>();
        ArrayList<PatternInfo> exactList = new ArrayList<PatternInfo>();
        HashMap<String, PatternInfo> patternMap = new HashMap<String, PatternInfo>();
        PatternInfo defaultInfo = null;
        SecurityConstraint[] constraints = metaData.findConstraints();
        for (i = 0; i < constraints.length; ++i) {
            SecurityConstraint sc = constraints[i];
            SecurityCollection[] resources = sc.findCollections();
            for (int j = 0; j < resources.length; ++j) {
                SecurityCollection wrc = resources[j];
                String[] urlPatterns = wrc.findPatterns();
                block8: for (int n = 0; n < urlPatterns.length; ++n) {
                    String url = urlPatterns[n];
                    int type = WarJaccService.getPatternType(url);
                    PatternInfo info2 = patternMap.get(url);
                    if (info2 != null) continue;
                    info2 = new PatternInfo(url, type);
                    patternMap.put(url, info2);
                    switch (type) {
                        case 1: {
                            prefixList.add(info2);
                            continue block8;
                        }
                        case 2: {
                            extensionList.add(info2);
                            continue block8;
                        }
                        case 4: {
                            exactList.add(info2);
                            continue block8;
                        }
                        case 3: {
                            defaultInfo = info2;
                        }
                    }
                }
            }
        }
        for (i = 0; i < prefixList.size(); ++i) {
            int j;
            info3 = (PatternInfo)prefixList.get(i);
            for (j = 0; j < prefixList.size(); ++j) {
                PatternInfo other;
                if (i == j || !info3.matches(other = (PatternInfo)prefixList.get(j))) continue;
                info3.addQualifier(other);
            }
            for (j = 0; j < exactList.size(); ++j) {
                PatternInfo other = (PatternInfo)exactList.get(j);
                if (!info3.matches(other)) continue;
                info3.addQualifier(other);
            }
        }
        for (i = 0; i < extensionList.size(); ++i) {
            PatternInfo other;
            int j;
            info3 = (PatternInfo)extensionList.get(i);
            for (j = 0; j < prefixList.size(); ++j) {
                other = (PatternInfo)prefixList.get(j);
                info3.addQualifier(other);
            }
            for (j = 0; j < exactList.size(); ++j) {
                other = (PatternInfo)exactList.get(j);
                if (!info3.isExtensionFor(other)) continue;
                info3.addQualifier(other);
            }
        }
        if (defaultInfo == null) {
            defaultInfo = new PatternInfo("/", 3);
            patternMap.put("/", defaultInfo);
        }
        for (PatternInfo info3 : patternMap.values()) {
            if (info3 == defaultInfo) continue;
            defaultInfo.addQualifier(info3);
        }
        return patternMap;
    }

    static class PatternInfo {
        static final HashMap<String, Set<String>> ALL_TRANSPORTS = new HashMap();
        String pattern;
        String qpattern;
        ArrayList<PatternInfo> qualifiers = new ArrayList();
        int type;
        HashSet<String> excludedMethods;
        HashMap<String, Set<String>> roles;
        HashMap<String, Set<String>> transports;
        HashSet<String> allMethods = new HashSet();
        boolean isOverriden;
        boolean isMissingAuthConstraint;

        PatternInfo(String pattern, int type) {
            this.pattern = pattern;
            this.type = type;
        }

        void addExcludedMethods(List<String> httpMethods) {
            Collection<String> methods = httpMethods;
            if (methods.size() == 0) {
                methods = WebResourceCollectionMetaData.ALL_HTTP_METHODS;
            }
            if (this.excludedMethods == null) {
                this.excludedMethods = new HashSet();
            }
            this.excludedMethods.addAll(methods);
            this.allMethods.addAll(methods);
        }

        public String[] getExcludedMethods() {
            String[] httpMethods = null;
            if (this.excludedMethods != null) {
                httpMethods = new String[this.excludedMethods.size()];
                this.excludedMethods.toArray(httpMethods);
            }
            return httpMethods;
        }

        public void addRoles(HashSet<String> mappedRoles, List<String> httpMethods) {
            Collection<String> methods = httpMethods;
            if (methods.size() == 0) {
                methods = WebResourceCollectionMetaData.ALL_HTTP_METHODS;
            }
            this.allMethods.addAll(methods);
            if (this.roles == null) {
                this.roles = new HashMap();
            }
            for (String role : mappedRoles) {
                Set<String> roleMethods = this.roles.get(role);
                if (roleMethods == null) {
                    roleMethods = new HashSet<String>();
                    this.roles.put(role, roleMethods);
                }
                roleMethods.addAll(methods);
            }
        }

        public Iterator<Map.Entry<String, Set<String>>> getRoleMethods() {
            HashMap<String, Set<String>> tmp = this.roles;
            if (tmp == null) {
                tmp = new HashMap(0);
            }
            Iterator<Map.Entry<String, Set<String>>> iter = tmp.entrySet().iterator();
            return iter;
        }

        void addTransport(String transport, List<String> httpMethods) {
            Set<String> transportMethods;
            Collection<String> methods = httpMethods;
            if (methods.size() == 0) {
                methods = WebResourceCollectionMetaData.ALL_HTTP_METHODS;
            }
            if (this.transports == null) {
                this.transports = new HashMap();
            }
            if ((transportMethods = this.transports.get(transport)) == null) {
                transportMethods = new HashSet<String>();
                this.transports.put(transport, transportMethods);
            }
            transportMethods.addAll(methods);
        }

        public Iterator<Map.Entry<String, Set<String>>> getTransportMethods() {
            HashMap<String, Set<String>> tmp = this.transports;
            if (tmp == null) {
                tmp = ALL_TRANSPORTS;
            }
            Iterator<Map.Entry<String, Set<String>>> iter = tmp.entrySet().iterator();
            return iter;
        }

        public String[] getMissingMethods() {
            String[] httpMethods = new String[]{};
            httpMethods = this.allMethods.size() == 0 ? WebResourceCollectionMetaData.ALL_HTTP_METHOD_NAMES : WebResourceCollectionMetaData.getMissingHttpMethods(this.allMethods);
            return httpMethods;
        }

        void addQualifier(PatternInfo info) {
            if (!this.qualifiers.contains(info)) {
                if (info.type == 1 && info.matches(this)) {
                    this.isOverriden = true;
                }
                this.qualifiers.add(info);
            }
        }

        public String getQualifiedPattern() {
            if (this.qpattern == null) {
                StringBuffer tmp = new StringBuffer(this.pattern);
                for (int n = 0; n < this.qualifiers.size(); ++n) {
                    tmp.append(':');
                    PatternInfo info = this.qualifiers.get(n);
                    tmp.append(info.pattern);
                }
                this.qpattern = tmp.toString();
            }
            return this.qpattern;
        }

        public int hashCode() {
            return this.pattern.hashCode();
        }

        public boolean equals(Object obj) {
            PatternInfo pi = (PatternInfo)obj;
            return this.pattern.equals(pi.pattern);
        }

        public boolean matches(PatternInfo other) {
            int matchLength = this.pattern.length() - 2;
            boolean matches = this.pattern.regionMatches(0, other.pattern, 0, matchLength);
            return matches;
        }

        public boolean isExtensionFor(PatternInfo other) {
            int offset = other.pattern.lastIndexOf(46);
            int length = this.pattern.length() - 1;
            boolean isExtensionFor = false;
            if (offset > 0) {
                isExtensionFor = this.pattern.regionMatches(1, other.pattern, offset, length);
            }
            return isExtensionFor;
        }

        public String toString() {
            StringBuffer tmp = new StringBuffer("PatternInfo[");
            tmp.append("pattern=");
            tmp.append(this.pattern);
            tmp.append(",type=");
            tmp.append(this.type);
            tmp.append(",isOverriden=");
            tmp.append(this.isOverriden);
            tmp.append(",qualifiers=");
            tmp.append(this.qualifiers);
            tmp.append("]");
            return tmp.toString();
        }

        static {
            ALL_TRANSPORTS.put("NONE", WebResourceCollectionMetaData.ALL_HTTP_METHODS);
        }
    }
}

