/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.sso;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.authenticator.Constants;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.jboss.as.clustering.web.sso.FullyQualifiedSessionId;
import org.jboss.as.clustering.web.sso.SSOClusterManager;
import org.jboss.as.clustering.web.sso.SSOCredentials;
import org.jboss.as.clustering.web.sso.SSOLocalManager;
import org.jboss.as.web.sso.SingleSignOnEntry;
import org.jboss.logging.Logger;

public class ClusteredSingleSignOn
extends SingleSignOn
implements LifecycleListener,
SSOLocalManager {
    public static final int DEFAULT_PROCESS_EXPIRES_INTERVAL = 60;
    public static final int DEFAULT_MAX_EMPTY_LIFE = 1800;
    private static final Logger log = Logger.getLogger(ClusteredSingleSignOn.class);
    private final SSOClusterManager ssoClusterManager;
    private Set<Manager> activeManagers = new CopyOnWriteArraySet<Manager>();
    private volatile int maxEmptyLife = 1800000;
    private volatile int processExpiresInterval = 60000;
    private volatile long lastProcessExpires = System.currentTimeMillis();
    private Map<String, Long> emptySSOs = new ConcurrentHashMap<String, Long>();
    private final Object MUTEX = new Object();

    public ClusteredSingleSignOn(SSOClusterManager ssoClusterManager) {
        this.ssoClusterManager = ssoClusterManager;
        this.ssoClusterManager.setSSOLocalManager((SSOLocalManager)this);
    }

    public int getMaxEmptyLife() {
        return this.maxEmptyLife / 1000;
    }

    public void setMaxEmptyLife(int maxEmptyLife) {
        this.maxEmptyLife = maxEmptyLife * 1000;
    }

    public int getProcessExpiresInterval() {
        return this.processExpiresInterval / 1000;
    }

    public void setProcessExpiresInterval(int processExpiresInterval) {
        this.processExpiresInterval = processExpiresInterval * 1000;
    }

    public long getLastProcessExpires() {
        return this.lastProcessExpires;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("authenticator.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("authenticator.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEvent(SessionEvent event) {
        if (!"destroySession".equals(event.getType())) {
            return;
        }
        Session session = event.getSession();
        log.tracef("Process session destroyed on %s", (Object)session);
        String ssoId = null;
        Map map = this.reverse;
        synchronized (map) {
            ssoId = (String)this.reverse.get(session);
        }
        if (ssoId == null) {
            log.tracef("ignoring as SSO is already closed for session %s", (Object)session);
            return;
        }
        boolean stopped = false;
        boolean timedOut = this.isSessionTimedOut(session);
        if (timedOut || (stopped = this.isManagerStopped(session))) {
            log.tracef("remove session %s from SSO %s, isSessionTimedOut=%s, isManagerStopped=%s", new Object[]{session, ssoId, timedOut, stopped});
            this.removeSession(ssoId, session);
            this.processExpires();
        } else {
            log.tracef("user logged out of SSO %s", (Object)ssoId);
            this.logout(ssoId);
        }
    }

    private boolean isSessionTimedOut(Session session) {
        return session.getMaxInactiveInterval() > 0 && System.currentTimeMillis() - session.getLastAccessedTime() >= (long)(session.getMaxInactiveInterval() * 1000);
    }

    private boolean isManagerStopped(Session session) {
        return !this.activeManagers.contains(session.getManager());
    }

    public void lifecycleEvent(LifecycleEvent event) {
        Lifecycle source;
        boolean removed;
        String type = event.getType();
        if (("before_stop".equals(type) || "stop".equals(type) || "after_stop".equals(type)) && (removed = this.activeManagers.remove(source = event.getLifecycle()))) {
            source.removeLifecycleListener((LifecycleListener)this);
            log.tracef("ClusteredSSO: removed stopped manager %s", (Object)source);
        }
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        request.removeNote("org.apache.catalina.request.SSOID");
        log.tracef("Process request for '%s'", (Object)request.getRequestURI());
        if (request.getUserPrincipal() != null) {
            log.tracef("Principal '%s' has already been authenticated", (Object)request.getUserPrincipal().getName());
            this.getNext().invoke(request, response);
            return;
        }
        Cookie cookie = null;
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!Constants.SINGLE_SIGN_ON_COOKIE.equals(cookies[i].getName())) continue;
            cookie = cookies[i];
            break;
        }
        if (cookie == null) {
            log.trace((Object)"SSO cookie is not present");
            this.getNext().invoke(request, response);
            return;
        }
        String ssoId = cookie.getValue();
        log.tracef("Checking for cached principal for %s", (Object)ssoId);
        SingleSignOnEntry entry = this.getSingleSignOnEntry(cookie.getValue());
        if (entry != null && this.isValid(ssoId, entry)) {
            Principal ssoPrinc = entry.getPrincipal();
            log.tracef("Found cached principal '%s' with auth type '%s'", (Object)(ssoPrinc == null ? "NULL" : ssoPrinc.getName()), (Object)entry.getAuthType());
            request.setNote("org.apache.catalina.request.SSOID", (Object)cookie.getValue());
            if (!this.getRequireReauthentication() && ssoPrinc != null) {
                request.setAuthType(entry.getAuthType());
                request.setUserPrincipal(ssoPrinc);
            }
        } else {
            log.tracef("No cached principal found, erasing SSO cookie", new Object[0]);
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
        this.getNext().invoke(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associate(String ssoId, Session session) {
        log.tracef("Associate sso id %s with session %s", (Object)ssoId, (Object)session);
        SingleSignOnEntry sso = this.getSingleSignOnEntry(ssoId);
        boolean added = false;
        if (sso != null) {
            added = sso.addSession2(this, session);
        }
        Map map = this.reverse;
        synchronized (map) {
            this.reverse.put(session, ssoId);
        }
        if (added) {
            Manager manager = session.getManager();
            if (this.activeManagers.add(manager)) {
                ((Lifecycle)manager).addLifecycleListener((LifecycleListener)this);
            }
            if (this.ssoClusterManager != null) {
                this.ssoClusterManager.addSession(ssoId, this.getFullyQualifiedSessionId(session));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(String ssoId, Session session) {
        Map map = this.reverse;
        synchronized (map) {
            this.reverse.remove(session);
        }
        SingleSignOnEntry sso = this.getSingleSignOnEntry(ssoId);
        if (sso == null) {
            return;
        }
        boolean removed = sso.removeSession2(session);
        if (this.ssoClusterManager != null) {
            if (removed) {
                this.ssoClusterManager.removeSession(ssoId, this.getFullyQualifiedSessionId(session));
                log.tracef("deregister will notify cluster of removed session %s sso id %s", (Object)session, (Object)ssoId);
            } else {
                log.tracef("deregister didn't find session %s sso id %s cluster notification not sent", (Object)session, (Object)ssoId);
            }
        }
        if (sso.getSessionCount() == 0) {
            log.tracef("deregister detected zero sessions for sso id %s", (Object)ssoId);
            Map map2 = this.cache;
            synchronized (map2) {
                sso = (SingleSignOnEntry)((Object)this.cache.remove(ssoId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(String ssoId) {
        log.tracef("Deregistering sso id '%s'", (Object)ssoId);
        this.emptySSOs.remove(ssoId);
        SingleSignOnEntry sso = null;
        Map map = this.cache;
        synchronized (map) {
            sso = (SingleSignOnEntry)((Object)this.cache.remove(ssoId));
        }
        if (sso == null) {
            return;
        }
        for (Session session : sso.findSessions()) {
            log.tracef(" Invalidating session %s", (Object)session);
            Map map2 = this.reverse;
            synchronized (map2) {
                this.reverse.remove(session);
            }
            session.expire();
        }
    }

    protected void logout(String ssoId) {
        this.deregister(ssoId);
        if (this.ssoClusterManager != null) {
            this.ssoClusterManager.logout(ssoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SingleSignOnEntry getSingleSignOnEntry(String ssoId) {
        SSOCredentials credentials;
        SingleSignOnEntry sso = this.localLookup(ssoId);
        if (sso == null && this.ssoClusterManager != null && (credentials = this.ssoClusterManager.lookup(ssoId)) != null) {
            sso = new SingleSignOnEntry(null, credentials.getAuthType(), credentials.getUsername(), credentials.getPassword());
            Map map = this.cache;
            synchronized (map) {
                this.cache.put(ssoId, sso);
            }
        }
        return sso;
    }

    public boolean reauthenticate(String ssoId, Realm realm, Request request) {
        Principal reauthPrincipal;
        String username;
        if (ssoId == null || realm == null) {
            return false;
        }
        boolean reauthenticated = false;
        SingleSignOnEntry entry = this.getSingleSignOnEntry(ssoId);
        if (entry != null && entry.getCanReauthenticate() && (username = entry.getUsername()) != null && (reauthPrincipal = realm.authenticate(username, entry.getPassword())) != null) {
            reauthenticated = true;
            request.setAuthType(entry.getAuthType());
            request.setUserPrincipal(reauthPrincipal);
            entry.setPrincipal(reauthPrincipal);
        }
        return reauthenticated;
    }

    public void register(String ssoId, Principal principal, String authType, String username, String password) {
        this.registerLocal(ssoId, principal, authType, username, password);
        this.ssoClusterManager.register(ssoId, authType, username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSession(String ssoId, Session session) {
        SingleSignOnEntry entry = this.getSingleSignOnEntry(ssoId);
        log.tracef("Removing session %s from sso id %s, %s", (Object)session, (Object)ssoId, (Object)(entry != null ? "found SSO entry" : "SSO entry not found"));
        if (entry == null) {
            return;
        }
        boolean removed = entry.removeSession2(session);
        log.tracef("Removing Session %s, session found = %s", (Object)session, (Object)removed);
        if (removed) {
            this.ssoClusterManager.removeSession(ssoId, this.getFullyQualifiedSessionId(session));
        }
        Map map = this.reverse;
        synchronized (map) {
            this.reverse.remove(session);
        }
    }

    public void update(String ssoId, Principal principal, String authType, String username, String password) {
        boolean needToBroadcast = this.updateLocal(ssoId, principal, authType, username, password);
        if (needToBroadcast) {
            this.ssoClusterManager.updateCredentials(ssoId, authType, username, password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SingleSignOnEntry localLookup(String ssoId) {
        Map map = this.cache;
        synchronized (map) {
            return (SingleSignOnEntry)((Object)this.cache.get(ssoId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerLocal(String ssoId, Principal principal, String authType, String username, String password) {
        log.tracef("Registering sso id '%s' for user '%s' with auth type '%s'", (Object)ssoId, (Object)principal.getName(), (Object)authType);
        Map map = this.cache;
        synchronized (map) {
            this.cache.put(ssoId, new SingleSignOnEntry(principal, authType, username, password));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateLocal(String ssoId, Principal principal, String authType, String username, String password) {
        boolean shouldBroadcast = false;
        SingleSignOnEntry sso = this.getSingleSignOnEntry(ssoId);
        if (sso != null) {
            if (!sso.getCanReauthenticate()) {
                log.tracef("Update sso id %s to auth type %s", (Object)ssoId, (Object)authType);
                SingleSignOnEntry singleSignOnEntry = sso;
                synchronized (singleSignOnEntry) {
                    shouldBroadcast = sso.updateCredentials2(principal, authType, username, password);
                }
            }
            if (sso.getPrincipal() == null && principal != null) {
                log.tracef("Update sso id %s with principal %s", (Object)ssoId, (Object)principal.getName());
                SingleSignOnEntry singleSignOnEntry = sso;
                synchronized (singleSignOnEntry) {
                    sso.setPrincipal(principal);
                }
            }
        }
        return shouldBroadcast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remoteUpdate(String ssoId, SSOCredentials credentials) {
        SingleSignOnEntry sso = this.localLookup(ssoId);
        if (sso != null && !sso.getCanReauthenticate()) {
            log.tracef("Update sso id %s to auth type %s", (Object)ssoId, (Object)credentials.getAuthType());
            SingleSignOnEntry singleSignOnEntry = sso;
            synchronized (singleSignOnEntry) {
                Principal p = sso.getPrincipal();
                sso.updateCredentials(p, credentials.getAuthType(), credentials.getUsername(), credentials.getPassword());
            }
        }
    }

    public void notifySSOEmpty(String ssoId) {
        Long obj = this.emptySSOs.put(ssoId, new Long(System.currentTimeMillis()));
        if (obj == null && log.isTraceEnabled()) {
            log.tracef("Notified that SSO %s is empty", (Object)ssoId);
        }
    }

    public void notifySSONotEmpty(String ssoId) {
        Long obj = this.emptySSOs.remove(ssoId);
        if (obj != null && log.isTraceEnabled()) {
            log.tracef("Notified that SSO %s is no longer empty", (Object)ssoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExpires() {
        long now = 0L;
        Object object = this.MUTEX;
        synchronized (object) {
            now = System.currentTimeMillis();
            if (now - this.lastProcessExpires <= (long)this.processExpiresInterval) {
                return;
            }
            this.lastProcessExpires = now;
        }
        this.clearExpiredSSOs(now);
    }

    private synchronized void clearExpiredSSOs(long now) {
        for (Map.Entry<String, Long> entry : this.emptySSOs.entrySet()) {
            if (now - entry.getValue() <= (long)this.maxEmptyLife) continue;
            String ssoId = entry.getKey();
            log.tracef("Invalidating expired SSO %s", (Object)ssoId);
            this.logout(ssoId);
        }
    }

    private boolean isValid(String ssoId, SingleSignOnEntry entry) {
        Long expired;
        boolean valid = true;
        if (entry.getSessionCount() == 0 && (expired = this.emptySSOs.get(ssoId)) != null && System.currentTimeMillis() - expired > (long)this.maxEmptyLife) {
            valid = false;
            log.tracef("Invalidating expired SSO %s", (Object)ssoId);
            this.logout(ssoId);
        }
        return valid;
    }

    private FullyQualifiedSessionId getFullyQualifiedSessionId(Session session) {
        String id = session.getIdInternal();
        Container context = session.getManager().getContainer();
        String contextName = context.getName();
        Container host = context.getParent();
        String hostName = host.getName();
        return new FullyQualifiedSessionId(id, contextName, hostName);
    }

    static {
        info = ClusteredSingleSignOn.class.getName();
    }
}

