/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.web.Namespace;
import org.jboss.as.web.WebConnectorMetrics;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class WebSubsystemDescriptions {
    static final String RESOURCE_NAME = WebSubsystemDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    WebSubsystemDescriptions() {
    }

    static ModelNode getSubsystemDescription(Locale locale) {
        ResourceBundle bundle = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("web"));
        node.get("head-comment-allowed").set(true);
        node.get("tail-comment-allowed").set(true);
        node.get("namespace").set(Namespace.WEB_1_0.getUriString());
        node.get(new String[]{"attributes", "default-virtual-server", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "default-virtual-server", "description"}).set(bundle.getString("web.default-virtual-server"));
        node.get(new String[]{"attributes", "default-virtual-server", "required"}).set(false);
        node.get(new String[]{"attributes", "default-virtual-server", "default"}).set("localhost");
        node.get(new String[]{"attributes", "native", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"attributes", "native", "description"}).set(bundle.getString("web.native"));
        node.get(new String[]{"attributes", "native", "required"}).set(false);
        node.get(new String[]{"attributes", "native", "default"}).set(true);
        WebSubsystemDescriptions.getConfigurationCommonDescription(node.get(new String[]{"attributes", "configuration"}), "attributes", bundle);
        WebSubsystemDescriptions.getConnectorCommonDescription(node.get(new String[]{"children", "connector"}), "attributes", bundle);
        WebSubsystemDescriptions.getVirtualServerCommonDescription(node.get(new String[]{"children", "virtual-server"}), "attributes", bundle);
        return node;
    }

    static ModelNode getSubsystemAddDescription(Locale locale) {
        ResourceBundle bundle = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("web.add"));
        node.get(new String[]{"request-properties", "default-virtual-server", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "default-virtual-server", "description"}).set(bundle.getString("web.default-virtual-server"));
        node.get(new String[]{"request-properties", "default-virtual-server", "required"}).set(false);
        node.get(new String[]{"request-properties", "default-virtual-server", "default"}).set("localhost");
        node.get(new String[]{"request-properties", "native", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"request-properties", "native", "description"}).set(bundle.getString("web.native"));
        node.get(new String[]{"request-properties", "native", "required"}).set(false);
        node.get(new String[]{"request-properties", "native", "default"}).set(true);
        WebSubsystemDescriptions.getConfigurationCommonDescription(node.get(new String[]{"request-properties", "configuration"}), "request-properties", bundle);
        return node;
    }

    static ModelNode getConnectorDescription(Locale locale) {
        ResourceBundle bundle = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("head-comment-allowed").set(true);
        node.get("tail-comment-allowed").set(true);
        node.get("type").set(ModelType.OBJECT);
        node.get("description").set(bundle.getString("web.connector"));
        node.get(new String[]{"attributes", "name", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "name", "description"}).set(bundle.getString("web.connector.name"));
        node.get(new String[]{"attributes", "name", "required"}).set(true);
        node.get(new String[]{"attributes", "name", "nillable"}).set(false);
        return WebSubsystemDescriptions.getConnectorCommonDescription(node, "attributes", bundle);
    }

    static ModelNode getConfigurationCommonDescription(ModelNode node, String type, ResourceBundle bundle) {
        node.get("type").set(ModelType.OBJECT);
        node.get("description").set(bundle.getString("web.configuration"));
        node.get("required").set(false);
        WebSubsystemDescriptions.getStaticResourcesCommonDescription(node.get(new String[]{type, "static-resources"}), type, bundle);
        WebSubsystemDescriptions.getJSPCommonDescription(node.get(new String[]{type, "static-resources"}), type, bundle);
        node.get(new String[]{type, "mime-mapping", "type"}).set(ModelType.LIST);
        node.get(new String[]{type, "mime-mapping", "description"}).set(bundle.getString("web.configuration.mime-mapping"));
        node.get(new String[]{type, "mime-mapping", "required"}).set(false);
        node.get(new String[]{type, "mime-mapping", "max-occurs"}).set(Integer.MAX_VALUE);
        node.get(new String[]{type, "mime-mapping", "name", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "mime-mapping", "name", "description"}).set(bundle.getString("web.configuration.mime-mapping.name"));
        node.get(new String[]{type, "mime-mapping", "name", "required"}).set(true);
        node.get(new String[]{type, "mime-mapping", "name", "nillable"}).set(false);
        node.get(new String[]{type, "mime-mapping", "value", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "mime-mapping", "value", "description"}).set(bundle.getString("web.configuration.mime-mapping.value"));
        node.get(new String[]{type, "mime-mapping", "value", "required"}).set(true);
        node.get(new String[]{type, "mime-mapping", "value", "nillable"}).set(false);
        node.get(new String[]{type, "welcome-file", "type"}).set(ModelType.LIST);
        node.get(new String[]{type, "welcome-file", "description"}).set(bundle.getString("web.configuration.welcome-file"));
        node.get(new String[]{type, "welcome-file", "required"}).set(false);
        node.get(new String[]{type, "welcome-file", "nillable"}).set(true);
        node.get(new String[]{type, "welcome-file", "max-occurs"}).set(Integer.MAX_VALUE);
        return node;
    }

    static ModelNode getStaticResourcesCommonDescription(ModelNode node, String type, ResourceBundle bundle) {
        node.get("type").set(ModelType.OBJECT);
        node.get("description").set(bundle.getString("web.configuration.static"));
        node.get("required").set(false);
        node.get(new String[]{type, "listings", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "listings", "description"}).set(bundle.getString("web.configuration.static.listings"));
        node.get(new String[]{type, "listings", "required"}).set(false);
        node.get(new String[]{type, "listings", "default"}).set(false);
        node.get(new String[]{type, "sendfile", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "sendfile", "description"}).set(bundle.getString("web.configuration.static.sendfile"));
        node.get(new String[]{type, "sendfile", "required"}).set(false);
        node.get(new String[]{type, "sendfile", "default"}).set(49152);
        node.get(new String[]{type, "file-encoding", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "file-encoding", "description"}).set(bundle.getString("web.configuration.static.file-encoding"));
        node.get(new String[]{type, "file-encoding", "required"}).set(false);
        node.get(new String[]{type, "read-only", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "read-only", "description"}).set(bundle.getString("web.configuration.static.read-only"));
        node.get(new String[]{type, "read-only", "required"}).set(false);
        node.get(new String[]{type, "read-only", "default"}).set(true);
        node.get(new String[]{type, "webdav", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "webdav", "description"}).set(bundle.getString("web.configuration.static.webdav"));
        node.get(new String[]{type, "webdav", "required"}).set(false);
        node.get(new String[]{type, "webdav", "default"}).set(false);
        node.get(new String[]{type, "secret", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "secret", "description"}).set(bundle.getString("web.configuration.static.secret"));
        node.get(new String[]{type, "secret", "required"}).set(false);
        node.get(new String[]{type, "max-depth", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "max-depth", "description"}).set(bundle.getString("web.configuration.static.max-depth"));
        node.get(new String[]{type, "max-depth", "required"}).set(false);
        node.get(new String[]{type, "max-depth", "default"}).set(3);
        node.get(new String[]{type, "disabled", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "disabled", "description"}).set(bundle.getString("web.configuration.static.disabled"));
        node.get(new String[]{type, "disabled", "required"}).set(false);
        node.get(new String[]{type, "disabled", "default"}).set(false);
        return node;
    }

    static ModelNode getJSPCommonDescription(ModelNode node, String type, ResourceBundle bundle) {
        node.get("type").set(ModelType.OBJECT);
        node.get("description").set(bundle.getString("web.configuration.jsp"));
        node.get("required").set(false);
        node.get(new String[]{type, "development", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "development", "description"}).set(bundle.getString("web.configuration.jsp.development"));
        node.get(new String[]{type, "development", "required"}).set(false);
        node.get(new String[]{type, "development", "default"}).set(false);
        node.get(new String[]{type, "disabled", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "disabled", "description"}).set(bundle.getString("web.configuration.jsp.disabled"));
        node.get(new String[]{type, "disabled", "required"}).set(false);
        node.get(new String[]{type, "disabled", "default"}).set(false);
        node.get(new String[]{type, "keep-generated", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "keep-generated", "description"}).set(bundle.getString("web.configuration.jsp.keep-generated"));
        node.get(new String[]{type, "keep-generated", "required"}).set(false);
        node.get(new String[]{type, "keep-generated", "default"}).set(true);
        node.get(new String[]{type, "trim-spaces", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "trim-spaces", "description"}).set(bundle.getString("web.configuration.jsp.trim-spaces"));
        node.get(new String[]{type, "trim-spaces", "required"}).set(false);
        node.get(new String[]{type, "trim-spaces", "default"}).set(true);
        node.get(new String[]{type, "tag-pooling", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "tag-pooling", "description"}).set(bundle.getString("web.configuration.jsp.tag-pooling"));
        node.get(new String[]{type, "tag-pooling", "required"}).set(false);
        node.get(new String[]{type, "tag-pooling", "default"}).set(true);
        node.get(new String[]{type, "mapped-file", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "mapped-file", "description"}).set(bundle.getString("web.configuration.jsp.mapped-file"));
        node.get(new String[]{type, "mapped-file", "required"}).set(false);
        node.get(new String[]{type, "mapped-file", "default"}).set(true);
        node.get(new String[]{type, "check-interval", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "check-interval", "description"}).set(bundle.getString("web.configuration.jsp.check-interval"));
        node.get(new String[]{type, "check-interval", "required"}).set(false);
        node.get(new String[]{type, "check-interval", "default"}).set(0);
        node.get(new String[]{type, "modification-test-interval", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "modification-test-interval", "description"}).set(bundle.getString("web.configuration.jsp.modification-test-interval"));
        node.get(new String[]{type, "modification-test-interval", "required"}).set(false);
        node.get(new String[]{type, "modification-test-interval", "default"}).set(4);
        node.get(new String[]{type, "recompile-on-fail", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "recompile-on-fail", "description"}).set(bundle.getString("web.configuration.jsp.recompile-on-fail"));
        node.get(new String[]{type, "recompile-on-fail", "required"}).set(false);
        node.get(new String[]{type, "recompile-on-fail", "default"}).set(false);
        node.get(new String[]{type, "smap", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "smap", "description"}).set(bundle.getString("web.configuration.jsp.smap"));
        node.get(new String[]{type, "smap", "required"}).set(false);
        node.get(new String[]{type, "smap", "default"}).set(false);
        node.get(new String[]{type, "dump-smap", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "dump-smap", "description"}).set(bundle.getString("web.configuration.jsp.dump-smap"));
        node.get(new String[]{type, "dump-smap", "required"}).set(false);
        node.get(new String[]{type, "dump-smap", "default"}).set(false);
        node.get(new String[]{type, "generate-strings-as-char-arrays", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "generate-strings-as-char-arrays", "description"}).set(bundle.getString("web.configuration.jsp.generate-strings-as-char-arrays"));
        node.get(new String[]{type, "generate-strings-as-char-arrays", "required"}).set(false);
        node.get(new String[]{type, "generate-strings-as-char-arrays", "default"}).set(false);
        node.get(new String[]{type, "error-on-use-bean-invalid-class-attribute", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "error-on-use-bean-invalid-class-attribute", "description"}).set(bundle.getString("web.configuration.jsp.error-on-use-bean-invalid-class-attribute"));
        node.get(new String[]{type, "error-on-use-bean-invalid-class-attribute", "required"}).set(false);
        node.get(new String[]{type, "error-on-use-bean-invalid-class-attribute", "default"}).set(false);
        node.get(new String[]{type, "scratch-dir", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "scratch-dir", "description"}).set(bundle.getString("web.configuration.jsp.scratch-dir"));
        node.get(new String[]{type, "scratch-dir", "required"}).set(false);
        node.get(new String[]{type, "source-vm", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "source-vm", "description"}).set(bundle.getString("web.configuration.jsp.source-vm"));
        node.get(new String[]{type, "source-vm", "required"}).set(false);
        node.get(new String[]{type, "source-vm", "default"}).set("1.5");
        node.get(new String[]{type, "target-vm", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "target-vm", "description"}).set(bundle.getString("web.configuration.jsp.target-vm"));
        node.get(new String[]{type, "target-vm", "required"}).set(false);
        node.get(new String[]{type, "target-vm", "default"}).set("1.5");
        node.get(new String[]{type, "java-encoding", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "java-encoding", "description"}).set(bundle.getString("web.configuration.jsp.java-encoding"));
        node.get(new String[]{type, "java-encoding", "required"}).set(false);
        node.get(new String[]{type, "java-encoding", "default"}).set("UTF-8");
        node.get(new String[]{type, "x-powered-by", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "x-powered-by", "description"}).set(bundle.getString("web.configuration.jsp.x-powered-by"));
        node.get(new String[]{type, "x-powered-by", "required"}).set(false);
        node.get(new String[]{type, "x-powered-by", "default"}).set(true);
        node.get(new String[]{type, "display-source-fragment", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "display-source-fragment", "description"}).set(bundle.getString("web.configuration.jsp.display-source-fragment"));
        node.get(new String[]{type, "display-source-fragment", "required"}).set(false);
        node.get(new String[]{type, "display-source-fragment", "default"}).set(true);
        return node;
    }

    static ModelNode getConnectorCommonDescription(ModelNode node, String type, ResourceBundle bundle) {
        node.get(new String[]{type, "protocol", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "protocol", "description"}).set(bundle.getString("web.connector.protocol"));
        node.get(new String[]{type, "protocol", "required"}).set(true);
        node.get(new String[]{type, "socket-binding", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "socket-binding", "description"}).set(bundle.getString("web.connector.socket-binding"));
        node.get(new String[]{type, "socket-binding", "required"}).set(true);
        node.get(new String[]{type, "socket-binding", "nillable"}).set(false);
        node.get(new String[]{type, "scheme", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "scheme", "description"}).set(bundle.getString("web.connector.scheme"));
        node.get(new String[]{type, "scheme", "required"}).set(false);
        node.get(new String[]{type, "scheme", "default"}).set("http");
        node.get(new String[]{type, "executor", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "executor", "description"}).set(bundle.getString("web.connector.executor"));
        node.get(new String[]{type, "executor", "required"}).set(false);
        node.get(new String[]{type, "enabled", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "enabled", "description"}).set(bundle.getString("web.connector.enabled"));
        node.get(new String[]{type, "enabled", "required"}).set(false);
        node.get(new String[]{type, "enabled", "default"}).set(true);
        node.get(new String[]{type, "enable-lookups", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "enable-lookups", "description"}).set(bundle.getString("web.connector.enable-lookups"));
        node.get(new String[]{type, "enable-lookups", "required"}).set(false);
        node.get(new String[]{type, "enable-lookups", "default"}).set(false);
        node.get(new String[]{type, "proxy-name", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "proxy-name", "description"}).set(bundle.getString("web.connector.proxy-name"));
        node.get(new String[]{type, "proxy-name", "required"}).set(false);
        node.get(new String[]{type, "proxy-port", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "proxy-port", "description"}).set(bundle.getString("web.connector.proxy-port"));
        node.get(new String[]{type, "proxy-port", "required"}).set(false);
        node.get(new String[]{type, "max-post-size", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "max-post-size", "description"}).set(bundle.getString("web.connector.max-post-size"));
        node.get(new String[]{type, "max-post-size", "required"}).set(false);
        node.get(new String[]{type, "max-post-size", "default"}).set(0x200000);
        node.get(new String[]{type, "max-save-post-size", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "max-save-post-size", "description"}).set(bundle.getString("web.connector.max-save-post-size"));
        node.get(new String[]{type, "max-save-post-size", "required"}).set(false);
        node.get(new String[]{type, "max-save-post-size", "default"}).set(4096);
        node.get(new String[]{type, "secure", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "secure", "description"}).set(bundle.getString("web.connector.secure"));
        node.get(new String[]{type, "secure", "required"}).set(false);
        node.get(new String[]{type, "secure", "default"}).set(false);
        node.get(new String[]{type, "redirect-port", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "redirect-port", "description"}).set(bundle.getString("web.connector.redirect-port"));
        node.get(new String[]{type, "redirect-port", "required"}).set(false);
        node.get(new String[]{type, "redirect-port", "default"}).set(8443);
        node.get(new String[]{type, "max-connections", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "max-connections", "description"}).set(bundle.getString("web.connector.max-connections"));
        node.get(new String[]{type, "max-connections", "required"}).set(false);
        node.get(new String[]{type, "virtual-server", "type"}).set(ModelType.LIST);
        node.get(new String[]{type, "virtual-server", "description"}).set(bundle.getString("web.connector.virtual-server"));
        node.get(new String[]{type, "virtual-server", "required"}).set(false);
        WebSubsystemDescriptions.getSSLCommonDescription(node.get(new String[]{type, "ssl"}), type, bundle);
        if ("attributes".equals(type)) {
            for (String metric : WebConnectorMetrics.ATTRIBUTES) {
                node.get(new String[]{"attributes", metric, "type"}).set(ModelType.INT);
            }
        }
        return node;
    }

    static ModelNode getSSLCommonDescription(ModelNode node, String type, ResourceBundle bundle) {
        node.get("type").set(ModelType.OBJECT);
        node.get("description").set(bundle.getString("web.connector.ssl"));
        node.get("required").set(false);
        node.get(new String[]{type, "name", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "name", "description"}).set(bundle.getString("web.connector.ssl.name"));
        node.get(new String[]{type, "name", "required"}).set(false);
        node.get(new String[]{type, "key-alias", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "key-alias", "description"}).set(bundle.getString("web.connector.ssl.key-alias"));
        node.get(new String[]{type, "key-alias", "required"}).set(false);
        node.get(new String[]{type, "password", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "password", "description"}).set(bundle.getString("web.connector.ssl.password"));
        node.get(new String[]{type, "password", "required"}).set(false);
        node.get(new String[]{type, "certificate-key-file", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "certificate-key-file", "description"}).set(bundle.getString("web.connector.ssl.certificate-key-file"));
        node.get(new String[]{type, "certificate-key-file", "required"}).set(false);
        node.get(new String[]{type, "cipher-suite", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "cipher-suite", "description"}).set(bundle.getString("web.connector.ssl.cipher-suite"));
        node.get(new String[]{type, "cipher-suite", "required"}).set(false);
        node.get(new String[]{type, "protocol", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "protocol", "description"}).set(bundle.getString("web.connector.ssl.protocol"));
        node.get(new String[]{type, "protocol", "required"}).set(false);
        node.get(new String[]{type, "verify-client", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "verify-client", "description"}).set(bundle.getString("web.connector.ssl.verify-client"));
        node.get(new String[]{type, "verify-client", "required"}).set(false);
        node.get(new String[]{type, "verify-depth", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "verify-depth", "description"}).set(bundle.getString("web.connector.ssl.verify-depth"));
        node.get(new String[]{type, "verify-depth", "required"}).set(false);
        node.get(new String[]{type, "certificate-file", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "certificate-file", "description"}).set(bundle.getString("web.connector.ssl.certificate-file"));
        node.get(new String[]{type, "certificate-file", "required"}).set(false);
        node.get(new String[]{type, "ca-certificate-file", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "ca-certificate-file", "description"}).set(bundle.getString("web.connector.ssl.ca-certificate-file"));
        node.get(new String[]{type, "ca-certificate-file", "required"}).set(false);
        node.get(new String[]{type, "ca-revocation-url", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "ca-revocation-url", "description"}).set(bundle.getString("web.connector.ssl.ca-revocation-url"));
        node.get(new String[]{type, "ca-revocation-url", "required"}).set(false);
        node.get(new String[]{type, "session-cache-size", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "session-cache-size", "description"}).set(bundle.getString("web.connector.ssl.session-cache-size"));
        node.get(new String[]{type, "session-cache-size", "required"}).set(false);
        node.get(new String[]{type, "session-timeout", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "session-timeout", "description"}).set(bundle.getString("web.connector.ssl.session-timeout"));
        node.get(new String[]{type, "session-timeout", "required"}).set(false);
        return node;
    }

    static ModelNode getConnectorAdd(Locale locale) {
        ResourceBundle bundle = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("web.connector.add"));
        WebSubsystemDescriptions.getConnectorCommonDescription(node, "request-properties", bundle);
        return node;
    }

    static ModelNode getConnectorRemove(Locale locale) {
        ResourceBundle bundle = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("remove");
        node.get("description").set(bundle.getString("web.connector.remove"));
        return node;
    }

    static ModelNode getVirtualServerDescription(Locale locale) {
        ResourceBundle bundle = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("head-comment-allowed").set(true);
        node.get("tail-comment-allowed").set(true);
        node.get("type").set(ModelType.OBJECT);
        node.get("description").set(bundle.getString("web.virtual-server"));
        node.get(new String[]{"attributes", "name", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "name", "description"}).set(bundle.getString("web.virtual-server.name"));
        node.get(new String[]{"attributes", "name", "required"}).set(true);
        node.get(new String[]{"attributes", "name", "nillable"}).set(false);
        return WebSubsystemDescriptions.getVirtualServerCommonDescription(node, "attributes", bundle);
    }

    static ModelNode getVirtualServerCommonDescription(ModelNode node, String type, ResourceBundle bundle) {
        node.get(new String[]{type, "alias", "type"}).set(ModelType.LIST);
        node.get(new String[]{type, "alias", "description"}).set(bundle.getString("web.virtual-server.alias"));
        node.get(new String[]{type, "alias", "required"}).set(false);
        node.get(new String[]{type, "alias", "nillable"}).set(true);
        node.get(new String[]{type, "default-web-module", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "default-web-module", "description"}).set(bundle.getString("web.virtual-server.default-web-module"));
        node.get(new String[]{type, "default-web-module", "required"}).set(false);
        node.get(new String[]{type, "default-web-module", "default"}).set("ROOT.war");
        WebSubsystemDescriptions.getAccessLogCommonDescription(node.get(new String[]{type, "access-log"}), type, bundle);
        WebSubsystemDescriptions.getRewriteCommonDescription(node.get(new String[]{type, "rewrite"}), type, bundle);
        return node;
    }

    static ModelNode getAccessLogCommonDescription(ModelNode node, String type, ResourceBundle bundle) {
        node.get("type").set(ModelType.OBJECT);
        node.get("description").set(bundle.getString("web.virtual-server.access-log"));
        node.get("required").set(false);
        node.get(new String[]{type, "pattern", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "pattern", "description"}).set(bundle.getString("web.virtual-server.access-log.pattern"));
        node.get(new String[]{type, "pattern", "required"}).set(false);
        node.get(new String[]{type, "pattern", "default"}).set("common");
        node.get(new String[]{type, "resolve-hosts", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "resolve-hosts", "description"}).set(bundle.getString("web.virtual-server.access-log.resolve-hosts"));
        node.get(new String[]{type, "resolve-hosts", "required"}).set(false);
        node.get(new String[]{type, "resolve-hosts", "default"}).set(false);
        node.get(new String[]{type, "extended", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "extended", "description"}).set(bundle.getString("web.virtual-server.access-log.extended"));
        node.get(new String[]{type, "extended", "required"}).set(false);
        node.get(new String[]{type, "extended", "default"}).set(false);
        node.get(new String[]{type, "prefix", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "prefix", "description"}).set(bundle.getString("web.virtual-server.access-log.prefix"));
        node.get(new String[]{type, "prefix", "required"}).set(false);
        node.get(new String[]{type, "rotate", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "rotate", "description"}).set(bundle.getString("web.virtual-server.access-log.rotate"));
        node.get(new String[]{type, "rotate", "required"}).set(false);
        node.get(new String[]{type, "rotate", "default"}).set(true);
        node.get(new String[]{type, "directory", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{type, "directory", "description"}).set(bundle.getString("web.virtual-server.access-log.directory"));
        node.get(new String[]{type, "directory", "required"}).set(false);
        node.get(new String[]{type, "directory", "path", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "directory", "path", "description"}).set(bundle.getString("web.virtual-server.access-log.directory.path"));
        node.get(new String[]{type, "directory", "path", "required"}).set(false);
        node.get(new String[]{type, "directory", "relative-to", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "directory", "relative-to", "description"}).set(bundle.getString("web.virtual-server.access-log.directory.relative-to"));
        node.get(new String[]{type, "directory", "relative-to", "required"}).set(false);
        return node;
    }

    static ModelNode getRewriteCommonDescription(ModelNode node, String type, ResourceBundle bundle) {
        node.get("type").set(ModelType.LIST);
        node.get("description").set(bundle.getString("web.virtual-server.rewrite"));
        node.get("required").set(false);
        node.get(new String[]{type, "pattern", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "pattern", "description"}).set(bundle.getString("web.virtual-server.rewrite.pattern"));
        node.get(new String[]{type, "pattern", "required"}).set(false);
        node.get(new String[]{type, "substitution", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "substitution", "description"}).set(bundle.getString("web.virtual-server.rewrite.substitution"));
        node.get(new String[]{type, "substitution", "required"}).set(false);
        node.get(new String[]{type, "flags", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "flags", "description"}).set(bundle.getString("web.virtual-server.rewrite.flags"));
        node.get(new String[]{type, "flags", "required"}).set(false);
        node.get(new String[]{type, "condition", "type"}).set(ModelType.LIST);
        node.get(new String[]{type, "condition", "description"}).set(bundle.getString("web.virtual-server.rewrite.condition"));
        node.get(new String[]{type, "condition", "required"}).set(false);
        node.get(new String[]{type, "condition", "test", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "condition", "test", "description"}).set(bundle.getString("web.virtual-server.rewrite.condition.test"));
        node.get(new String[]{type, "condition", "test", "required"}).set(false);
        node.get(new String[]{type, "condition", "pattern", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "condition", "pattern", "description"}).set(bundle.getString("web.virtual-server.rewrite.condition.pattern"));
        node.get(new String[]{type, "condition", "pattern", "required"}).set(false);
        node.get(new String[]{type, "condition", "flags", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "condition", "flags", "description"}).set(bundle.getString("web.virtual-server.rewrite.condition.flags"));
        node.get(new String[]{type, "condition", "flags", "required"}).set(false);
        return node;
    }

    static ModelNode getVirtualServerAdd(Locale locale) {
        ResourceBundle bundle = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("web.virtual-server.add"));
        WebSubsystemDescriptions.getVirtualServerCommonDescription(node, "request-properties", bundle);
        return node;
    }

    static ModelNode getVirtualServerRemove(Locale locale) {
        ResourceBundle bundle = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("remove");
        node.get("description").set(bundle.getString("web.virtual-server.remove"));
        return node;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

