/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.HashMap;
import java.util.Map;
import org.jboss.dmr.ModelNode;

public class DefaultJspConfig {
    private static final Map<String, ModelNode> defaults = new HashMap<String, ModelNode>();

    static ModelNode getDefaultStaticResource() {
        ModelNode result = new ModelNode();
        for (Map.Entry<String, ModelNode> entry : defaults.entrySet()) {
            result.get(entry.getKey()).set(entry.getValue());
        }
        return result;
    }

    static boolean hasNotDefault(ModelNode model, String key) {
        return model.hasDefined(key) && !model.get(key).equals(defaults.get(key));
    }

    static ModelNode getDefaultIfUndefined(String key, ModelNode toCheck) {
        ModelNode ours;
        ModelNode result = toCheck;
        if (!toCheck.isDefined() && (ours = defaults.get(key)) != null) {
            result = ours;
        }
        return result;
    }

    static {
        defaults.put("development", new ModelNode().set(false));
        defaults.put("disabled", new ModelNode().set(false));
        defaults.put("keep-generated", new ModelNode().set(true));
        defaults.put("trim-spaces", new ModelNode().set(false));
        defaults.put("tag-pooling", new ModelNode().set(true));
        defaults.put("mapped-file", new ModelNode().set(true));
        defaults.put("check-interval", new ModelNode().set(0));
        defaults.put("modification-test-interval", new ModelNode().set(4));
        defaults.put("recompile-on-fail", new ModelNode().set(false));
        defaults.put("smap", new ModelNode().set(true));
        defaults.put("dump-smap", new ModelNode().set(false));
        defaults.put("generate-strings-as-char-arrays", new ModelNode().set(false));
        defaults.put("error-on-use-bean-invalid-class-attribute", new ModelNode().set(false));
        defaults.put("source-vm", new ModelNode().set("1.5"));
        defaults.put("target-vm", new ModelNode().set("1.5"));
        defaults.put("java-encoding", new ModelNode().set("UTF8"));
        defaults.put("display-source-fragment", new ModelNode().set(true));
    }
}

