/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import org.apache.catalina.Host;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.catalina.valves.ExtendedAccessLogValve;
import org.jboss.as.web.VirtualHost;
import org.jboss.as.web.WebServer;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.web.rewrite.RewriteValve;

public class WebVirtualHostService
implements Service<VirtualHost> {
    private final String name;
    private final String[] aliases;
    private String defaultWebModule;
    private boolean hasWelcomeRoot;
    private ModelNode accessLog;
    private ModelNode rewrite;
    private final InjectedValue<String> tempPathInjector = new InjectedValue();
    private final InjectedValue<String> accessLogPathInjector = new InjectedValue();
    private final InjectedValue<WebServer> webServer = new InjectedValue();
    private VirtualHost host;

    public WebVirtualHostService(String name, String[] aliases, boolean hasWelcomeRoot) {
        this.name = name;
        this.aliases = aliases;
        this.hasWelcomeRoot = hasWelcomeRoot;
    }

    public synchronized void start(StartContext context) throws StartException {
        StandardHost host = new StandardHost();
        host.setAppBase((String)this.tempPathInjector.getValue());
        host.setName(this.name);
        for (String alias : this.aliases) {
            host.addAlias(alias);
        }
        if (this.accessLog != null) {
            host.addValve(WebVirtualHostService.createAccessLogValve((String)this.accessLogPathInjector.getValue(), this.accessLog));
        }
        if (this.rewrite != null) {
            host.addValve(WebVirtualHostService.createRewriteValve(this.rewrite));
        }
        if (this.defaultWebModule != null) {
            host.setDefaultWebapp(this.defaultWebModule);
        }
        try {
            WebServer server = (WebServer)this.webServer.getValue();
            server.addHost((Host)host);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
        this.host = new VirtualHost((Host)host, this.hasWelcomeRoot);
    }

    public synchronized void stop(StopContext context) {
        VirtualHost host = this.host;
        this.host = null;
        WebServer server = (WebServer)this.webServer.getValue();
        server.removeHost(host.getHost());
    }

    public synchronized VirtualHost getValue() throws IllegalStateException {
        VirtualHost host = this.host;
        if (host == null) {
            throw new IllegalStateException();
        }
        return host;
    }

    void setAccessLog(ModelNode accessLog) {
        this.accessLog = accessLog;
    }

    void setRewrite(ModelNode rewrite) {
        this.rewrite = rewrite;
    }

    protected String getDefaultWebModule() {
        return this.defaultWebModule;
    }

    protected void setDefaultWebModule(String defaultWebModule) {
        this.defaultWebModule = defaultWebModule;
    }

    public InjectedValue<String> getAccessLogPathInjector() {
        return this.accessLogPathInjector;
    }

    public InjectedValue<String> getTempPathInjector() {
        return this.tempPathInjector;
    }

    public InjectedValue<WebServer> getWebServer() {
        return this.webServer;
    }

    static Valve createAccessLogValve(String logDirectory, ModelNode element) {
        boolean extended = false;
        if (element.hasDefined("extended")) {
            extended = element.get("extended").asBoolean();
        }
        Object log = extended ? new ExtendedAccessLogValve() : new AccessLogValve();
        log.setDirectory(logDirectory);
        if (element.hasDefined("resolve-hosts")) {
            log.setResolveHosts(element.get("resolve-hosts").asBoolean());
        }
        if (element.hasDefined("rotate")) {
            log.setRotatable(element.get("rotate").asBoolean());
        }
        if (element.hasDefined("pattern")) {
            log.setPattern(element.get("pattern").asString());
        } else {
            log.setPattern("common");
        }
        if (element.hasDefined("prefix")) {
            log.setPrefix(element.get("prefix").asString());
        }
        return log;
    }

    static Valve createRewriteValve(ModelNode element) throws StartException {
        RewriteValve rewriteValve = new RewriteValve();
        StringBuffer configuration = new StringBuffer();
        for (ModelNode rewrite : element.asList()) {
            if (!rewrite.has("condition")) continue;
            for (ModelNode condition : rewrite.get("condition").asList()) {
                configuration.append("RewriteCond ").append(condition.get("test").asString()).append(" ").append(condition.get("pattern").asString()).append(" [").append(condition.get("flags").asString()).append("]\r\n");
            }
            configuration.append("RewriteRule ").append(rewrite.get("pattern").asString()).append(" ").append(rewrite.get("substitution").asString()).append(" [").append(rewrite.get("flags").asString()).append("]\r\n");
        }
        try {
            rewriteValve.setConfiguration(configuration.toString());
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
        return rewriteValve;
    }
}

