/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment.component;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.as.web.deployment.WebAttachments;
import org.jboss.as.web.deployment.component.ComponentInstantiator;
import org.jboss.as.web.deployment.component.ManagedBeanComponentInstantiator;
import org.jboss.as.web.deployment.component.WebComponentDescription;
import org.jboss.as.web.deployment.component.WebComponentInstantiator;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.metadata.web.spec.WebFragmentMetaData;
import org.jboss.metadata.web.spec.WebMetaData;

public class WebComponentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        String applicationName;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        HashMap<String, AbstractComponentDescription> componentByClass = new HashMap<String, AbstractComponentDescription>();
        HashMap<String, ComponentInstantiator> webComponents = new HashMap<String, ComponentInstantiator>();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        String string = applicationName = deploymentUnit.getParent() == null ? deploymentUnit.getName() : deploymentUnit.getParent().getName();
        if (moduleDescription == null) {
            return;
        }
        for (AbstractComponentDescription component : moduleDescription.getComponentDescriptions()) {
            componentByClass.put(component.getComponentClassName(), component);
        }
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        Set<String> classes = this.getAllComponentClasses(warMetaData);
        for (String clazz : classes) {
            AbstractComponentDescription description = (AbstractComponentDescription)componentByClass.get(clazz);
            if (description != null) {
                if (description.getViewClassNames().size() != 1) {
                    throw new RuntimeException(clazz + " has the wrong component type, is cannot be used as a web component");
                }
                ManagedBeanComponentInstantiator instantiator = new ManagedBeanComponentInstantiator(deploymentUnit, description);
                webComponents.put(clazz, instantiator);
                continue;
            }
            description = new WebComponentDescription(clazz, clazz, moduleDescription.getModuleName(), moduleDescription.getAppName());
            moduleDescription.addComponent(description);
            webComponents.put(clazz, new WebComponentInstantiator(deploymentUnit, description));
        }
        deploymentUnit.putAttachment(WebAttachments.WEB_COMPONENT_INSTANTIATORS, webComponents);
    }

    public void undeploy(DeploymentUnit context) {
    }

    private Set<String> getAllComponentClasses(WarMetaData metaData) {
        HashSet<String> classes = new HashSet<String>();
        if (metaData.getAnnotationsMetaData() != null) {
            for (Map.Entry<String, WebMetaData> entry : metaData.getAnnotationsMetaData().entrySet()) {
                this.getAllComponentClasses(entry.getValue(), classes);
            }
        }
        if (metaData.getSharedWebMetaData() != null) {
            this.getAllComponentClasses(metaData.getSharedWebMetaData(), classes);
        }
        if (metaData.getWebFragmentsMetaData() != null) {
            for (Map.Entry<String, WebMetaData> entry : metaData.getWebFragmentsMetaData().entrySet()) {
                this.getAllComponentClasses((WebFragmentMetaData)entry.getValue(), classes);
            }
        }
        if (metaData.getWebMetaData() != null) {
            this.getAllComponentClasses(metaData.getWebMetaData(), classes);
        }
        return classes;
    }

    private void getAllComponentClasses(WebMetaData metaData, Set<String> classes) {
        if (metaData.getServlets() != null) {
            for (ServletMetaData servlet : metaData.getServlets()) {
                if (servlet.getServletClass() == null) continue;
                classes.add(servlet.getServletClass());
            }
        }
        if (metaData.getFilters() != null) {
            for (FilterMetaData filter : metaData.getFilters()) {
                classes.add(filter.getFilterClass());
            }
        }
        if (metaData.getListeners() != null) {
            for (ListenerMetaData listener : metaData.getListeners()) {
                classes.add(listener.getListenerClass());
            }
        }
    }

    private void getAllComponentClasses(WebFragmentMetaData metaData, Set<String> classes) {
        if (metaData.getServlets() != null) {
            for (ServletMetaData servlet : metaData.getServlets()) {
                if (servlet.getServletClass() == null) continue;
                classes.add(servlet.getServletClass());
            }
        }
        if (metaData.getFilters() != null) {
            for (FilterMetaData filter : metaData.getFilters()) {
                classes.add(filter.getFilterClass());
            }
        }
        if (metaData.getListeners() != null) {
            for (ListenerMetaData listener : metaData.getListeners()) {
                classes.add(listener.getListenerClass());
            }
        }
    }
}

