/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Realm;
import org.apache.catalina.core.StandardContext;
import org.apache.tomcat.InstanceManager;
import org.jboss.as.ee.naming.NamespaceSelectorService;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.web.NamingListener;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.as.web.deployment.JBossContextConfig;
import org.jboss.as.web.deployment.SecurityActions;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.as.web.deployment.WebAttachments;
import org.jboss.as.web.deployment.WebContextInjector;
import org.jboss.as.web.deployment.WebCtxLoader;
import org.jboss.as.web.deployment.WebDeploymentService;
import org.jboss.as.web.deployment.WebInjectionContainer;
import org.jboss.as.web.deployment.component.ComponentInstantiator;
import org.jboss.as.web.security.JBossWebRealm;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.SecurityUtil;
import org.jboss.vfs.VirtualFile;

public class WarDeploymentProcessor
implements DeploymentUnitProcessor {
    private final String defaultHost;

    public WarDeploymentProcessor(String defaultHost) {
        if (defaultHost == null) {
            throw new IllegalArgumentException("null default host");
        }
        this.defaultHost = defaultHost;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        String hostName;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        WarMetaData metaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (metaData == null) {
            return;
        }
        Collection<Object> hostNames = metaData.getMergedJBossWebMetaData().getVirtualHosts();
        if (hostNames == null || hostNames.isEmpty()) {
            hostNames = Collections.singleton(this.defaultHost);
        }
        if ((hostName = (String)hostNames.iterator().next()) == null) {
            throw new IllegalStateException("null host name");
        }
        this.processDeployment(hostName, metaData, deploymentUnit, phaseContext.getServiceTarget());
    }

    public void undeploy(DeploymentUnit context) {
    }

    protected void processDeployment(String hostName, WarMetaData warMetaData, DeploymentUnit deploymentUnit, ServiceTarget serviceTarget) throws DeploymentUnitProcessingException {
        VirtualFile deploymentRoot = ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            throw new DeploymentUnitProcessingException("failed to resolve module for deployment " + deploymentRoot);
        }
        ModuleClassLoader classLoader = module.getClassLoader();
        JBossWebMetaData metaData = warMetaData.getMergedJBossWebMetaData();
        StandardContext webContext = new StandardContext();
        JBossContextConfig config = new JBossContextConfig(deploymentUnit);
        webContext.addInstanceListener(NamingListener.class.getName());
        try {
            webContext.setDocBase(deploymentRoot.getPhysicalFile().getAbsolutePath());
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
        webContext.addLifecycleListener((LifecycleListener)config);
        String deploymentName = deploymentUnit.getName();
        String pathName = null;
        if (metaData.getContextRoot() == null) {
            pathName = deploymentRoot.getName();
            pathName = pathName.equals("ROOT.war") ? "" : "/" + pathName.substring(0, pathName.length() - 4);
        } else {
            pathName = metaData.getContextRoot();
            if ("/".equals(pathName)) {
                pathName = "";
            }
        }
        webContext.setPath(pathName);
        webContext.setIgnoreAnnotations(true);
        webContext.setCrossContext(!metaData.isDisableCrossContext());
        WebInjectionContainer injectionContainer = new WebInjectionContainer((ClassLoader)module.getClassLoader());
        Map components = (Map)deploymentUnit.getAttachment(WebAttachments.WEB_COMPONENT_INSTANTIATORS);
        if (components != null) {
            for (Map.Entry entry : components.entrySet()) {
                injectionContainer.addInstantiator((String)entry.getKey(), (ComponentInstantiator)entry.getValue());
            }
        }
        webContext.setInstanceManager((InstanceManager)injectionContainer);
        WebCtxLoader loader = new WebCtxLoader((ClassLoader)classLoader);
        webContext.setLoader((Loader)loader);
        switch (metaData.getSessionCookies()) {
            case 1: {
                webContext.setCookies(true);
                break;
            }
            case 2: {
                webContext.setCookies(false);
            }
        }
        String metaDataSecurityDomain = metaData.getSecurityDomain();
        if (metaDataSecurityDomain != null) {
            metaDataSecurityDomain = metaDataSecurityDomain.trim();
        }
        JBossWebRealm realm = new JBossWebRealm();
        String securityDomain = metaDataSecurityDomain == null ? "other" : SecurityUtil.unprefixSecurityDomain((String)metaDataSecurityDomain);
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        SecurityActions.setContextClassLoader((ClassLoader)classLoader);
        try {
            AuthenticationManager authM = this.getAuthenticationManager(securityDomain);
            realm.setAuthenticationManager(authM);
            AuthorizationManager authzM = this.getAuthorizationManager(securityDomain);
            realm.setAuthorizationManager(authzM);
            webContext.setRealm((Realm)realm);
        }
        catch (NamingException e1) {
            throw new RuntimeException(e1);
        }
        finally {
            SecurityActions.setContextClassLoader(tcl);
        }
        try {
            ServiceName namespaceSelectorServiceName = deploymentUnit.getServiceName().append(NamespaceSelectorService.NAME);
            WebDeploymentService webDeploymentService = new WebDeploymentService(webContext);
            serviceTarget.addService(WebSubsystemServices.JBOSS_WEB.append(new String[]{deploymentName}), (Service)webDeploymentService).addDependency(WebSubsystemServices.JBOSS_WEB_HOST.append(new String[]{hostName}), Host.class, (Injector)new WebContextInjector((Context)webContext)).addDependencies(injectionContainer.getServiceNames()).addDependency(namespaceSelectorServiceName, NamespaceContextSelector.class, webDeploymentService.getNamespaceSelector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
        catch (ServiceRegistryException e) {
            throw new DeploymentUnitProcessingException("Failed to add JBoss web deployment service", (Throwable)e);
        }
    }

    private AuthenticationManager getAuthenticationManager(String secDomain) throws NamingException {
        InitialContext ic = new InitialContext();
        return (AuthenticationManager)ic.lookup("java:/jaas/" + secDomain + "/authenticationMgr");
    }

    private AuthorizationManager getAuthorizationManager(String secDomain) throws NamingException {
        InitialContext ic = new InitialContext();
        return (AuthorizationManager)ic.lookup("java:/jaas/" + secDomain + "/authorizationMgr");
    }
}

