/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import org.apache.catalina.connector.Connector;
import org.jboss.as.server.services.net.SocketBinding;
import org.jboss.as.web.WebServer;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class WebConnectorService
implements Service<Connector> {
    private String protocol = "HTTP/1.1";
    private String scheme = "http";
    private Boolean enableLookups = null;
    private String proxyName = null;
    private Integer proxyPort = null;
    private Integer redirectPort = null;
    private Boolean secure = null;
    private Integer maxPostSize = null;
    private Integer maxSavePostSize = null;
    private Connector connector;
    private final InjectedValue<Executor> executor = new InjectedValue();
    private final InjectedValue<SocketBinding> binding = new InjectedValue();
    private final InjectedValue<WebServer> server = new InjectedValue();

    public WebConnectorService(String protocol, String scheme) {
        if (protocol != null) {
            this.protocol = protocol;
        }
        if (scheme != null) {
            this.scheme = scheme;
        }
    }

    public synchronized void start(StartContext context) throws StartException {
        SocketBinding binding = (SocketBinding)this.binding.getValue();
        InetSocketAddress address = binding.getSocketAddress();
        try {
            Connector connector = new Connector();
            connector.setPort(address.getPort());
            connector.setProtocol(this.protocol);
            connector.setScheme(this.scheme);
            if (this.enableLookups != null) {
                connector.setEnableLookups(this.enableLookups.booleanValue());
            }
            if (this.maxPostSize != null) {
                connector.setMaxPostSize(this.maxPostSize.intValue());
            }
            if (this.maxSavePostSize != null) {
                connector.setMaxSavePostSize(this.maxSavePostSize.intValue());
            }
            if (this.proxyName != null) {
                connector.setProxyName(this.proxyName);
            }
            if (this.proxyPort != null) {
                connector.setProxyPort(this.proxyPort.intValue());
            }
            if (this.redirectPort != null) {
                connector.setRedirectPort(this.redirectPort.intValue());
            }
            if (this.secure != null) {
                connector.setSecure(this.secure.booleanValue());
            }
            this.getWebServer().addConnector(connector);
            this.connector = connector;
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        Connector connector = this.connector;
        this.getWebServer().removeConnector(connector);
        this.connector = null;
    }

    public synchronized Connector getValue() throws IllegalStateException {
        Connector connector = this.connector;
        if (connector == null) {
            throw new IllegalStateException();
        }
        return connector;
    }

    protected boolean isEnableLookups() {
        return this.enableLookups;
    }

    protected void setEnableLookups(boolean enableLookups) {
        this.enableLookups = enableLookups;
    }

    protected String getProxyName() {
        return this.proxyName;
    }

    protected void setProxyName(String proxyName) {
        this.proxyName = proxyName;
    }

    protected int getProxyPort() {
        return this.proxyPort;
    }

    protected void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    protected int getRedirectPort() {
        return this.redirectPort;
    }

    protected void setRedirectPort(int redirectPort) {
        this.redirectPort = redirectPort;
    }

    protected boolean isSecure() {
        return this.secure;
    }

    protected void setSecure(boolean secure) {
        this.secure = secure;
    }

    protected int getMaxPostSize() {
        return this.maxPostSize;
    }

    protected void setMaxPostSize(int maxPostSize) {
        this.maxPostSize = maxPostSize;
    }

    protected int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    protected void setMaxSavePostSize(int maxSavePostSize) {
        this.maxSavePostSize = maxSavePostSize;
    }

    InjectedValue<Executor> getExecutor() {
        return this.executor;
    }

    InjectedValue<SocketBinding> getBinding() {
        return this.binding;
    }

    InjectedValue<WebServer> getServer() {
        return this.server;
    }

    private WebServer getWebServer() {
        return (WebServer)this.server.getValue();
    }
}

