/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.catalina.connector.Connector;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

class WebConnectorMetrics
implements ModelQueryOperationHandler {
    static WebConnectorMetrics INSTANCE = new WebConnectorMetrics();
    static final String[] NO_LOCATION = new String[0];
    static final String[] ATTRIBUTES = new String[]{"bytesSent", "bytesReceived", "processingTime", "errorCount", "maxTime", "requestCount"};
    static final String BASE_NAME = "jboss.web:type=GlobalRequestProcessor,name=";

    WebConnectorMetrics() {
    }

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                    String name = address.getLastElement().getValue();
                    String attributeName = operation.require("name").asString();
                    ServiceController controller = context.getServiceRegistry().getService(WebSubsystemServices.JBOSS_WEB_CONNECTOR.append(new String[]{name}));
                    if (controller != null) {
                        try {
                            Connector connector = (Connector)controller.getValue();
                            int port = connector.getPort();
                            ModelNode result = new ModelNode();
                            result.set("" + WebConnectorMetrics.getAttribute("http-" + port, attributeName));
                            resultHandler.handleResultFragment(new String[0], result);
                            resultHandler.handleResultComplete();
                        }
                        catch (Exception e) {
                            throw new OperationFailedException(new ModelNode().set("failed to get metrics" + e.getMessage()));
                        }
                    }
                }
            });
        } else {
            resultHandler.handleResultFragment(NO_LOCATION, new ModelNode().set("no metrics available"));
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult();
    }

    static final ObjectName createObjectName(String name) throws MalformedObjectNameException {
        return new ObjectName(BASE_NAME + name);
    }

    static final Object getAttribute(String name, String attributeName) throws MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        ObjectName connectorName = WebConnectorMetrics.createObjectName(name);
        Object value = WebConnectorMetrics.getMBeanServer().getAttribute(connectorName, attributeName);
        return value;
    }

    static MBeanServer getMBeanServer() {
        return Registry.getRegistry(null, null).getMBeanServer();
    }
}

