/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.attachment.VirtualFileAttachment;
import org.jboss.as.deployment.module.ModuleConfig;
import org.jboss.as.deployment.module.ModuleDependencies;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.as.web.deployment.helpers.DeploymentStructure;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.SuffixMatchFilter;

public class WarModuleConfigProcessor
implements DeploymentUnitProcessor {
    public static final String WEB_INF_LIB = "WEB-INF/lib";
    public static final String WEB_INF_CLASSES = "WEB-INF/classes";
    public static final VirtualFileFilter DEFAULT_WEB_INF_LIB_FILTER = new SuffixMatchFilter(".jar", VisitorAttributes.DEFAULT);
    public static final long PRIORITY = DeploymentPhases.MODULARIZE.plus(100L);
    private static final ModuleConfig.Dependency[] NO_DEPS = new ModuleConfig.Dependency[0];

    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        if (context.getAttachment(ModuleConfig.ATTACHMENT_KEY) != null) {
            return;
        }
        VirtualFile deploymentRoot = VirtualFileAttachment.getVirtualFileAttachment((DeploymentUnitContext)context);
        ModuleIdentifier moduleIdentifier = ModuleIdentifier.create((String)("deployment." + deploymentRoot.getName()));
        ModuleConfig.ResourceRoot[] resourceRoots = this.createResourceRoots((DeploymentStructure)context.getAttachment(DeploymentStructure.ATTACHMENT_KEY));
        ModuleDependencies dependenciesAttachment = ModuleDependencies.getAttachedDependencies((DeploymentUnitContext)context);
        ModuleConfig.Dependency[] dependencies = dependenciesAttachment != null ? dependenciesAttachment.getDependencies() : NO_DEPS;
        ModuleConfig moduleConfig = new ModuleConfig(moduleIdentifier, dependencies, resourceRoots);
        context.putAttachment(ModuleConfig.ATTACHMENT_KEY, (Object)moduleConfig);
    }

    private ModuleConfig.ResourceRoot[] createResourceRoots(DeploymentStructure structure) {
        if (structure == null) {
            return new ModuleConfig.ResourceRoot[0];
        }
        DeploymentStructure.ClassPathEntry[] entries = structure.getEntries();
        if (entries == null || entries.length == 0) {
            return new ModuleConfig.ResourceRoot[0];
        }
        int length = entries.length;
        ModuleConfig.ResourceRoot[] roots = new ModuleConfig.ResourceRoot[length];
        for (int i = 0; i < length; ++i) {
            DeploymentStructure.ClassPathEntry entry = entries[i];
            roots[i] = new ModuleConfig.ResourceRoot(entry.getName(), entry.getRoot(), entry.getMountHandle());
        }
        return roots;
    }
}

