/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.attachment.VirtualFileAttachment;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.as.metadata.parser.jsp.TldMetaDataParser;
import org.jboss.as.metadata.parser.util.NoopXmlResolver;
import org.jboss.as.web.deployment.TldsMetaData;
import org.jboss.as.web.deployment.helpers.DeploymentStructure;
import org.jboss.metadata.web.spec.TldMetaData;
import org.jboss.vfs.VirtualFile;

public class TldParsingDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final long PRIORITY = DeploymentPhases.PARSE_DESCRIPTORS.plus(330L);
    private static final String TLD = ".tld";
    private static final String META_INF = "META-INF";
    private static final String WEB_INF = "WEB-INF";
    private static final String CLASSES = "classes";
    private static final String LIB = "lib";
    private static final String IMPLICIT_TLD = "implicit.tld";

    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        VirtualFile deploymentRoot = VirtualFileAttachment.getVirtualFileAttachment((DeploymentUnitContext)context);
        TldsMetaData tldsMetaData = (TldsMetaData)context.getAttachment(TldsMetaData.ATTACHMENT_KEY);
        if (tldsMetaData == null) {
            tldsMetaData = new TldsMetaData();
            context.putAttachment(TldsMetaData.ATTACHMENT_KEY, (Object)tldsMetaData);
        }
        HashMap<String, TldMetaData> tlds = new HashMap<String, TldMetaData>();
        tldsMetaData.setTlds(tlds);
        DeploymentStructure structure = (DeploymentStructure)context.getAttachment(DeploymentStructure.ATTACHMENT_KEY);
        assert (structure != null);
        assert (structure.getEntries() != null);
        for (DeploymentStructure.ClassPathEntry resourceRoot : structure.getEntries()) {
            VirtualFile webFragment;
            if (!resourceRoot.getRoot().getLowerCaseName().endsWith(".jar") || !(webFragment = resourceRoot.getRoot().getChild(META_INF)).exists() || !webFragment.isDirectory()) continue;
            this.processTlds(deploymentRoot, webFragment.getChildren(), tlds);
        }
        VirtualFile webInf = deploymentRoot.getChild(WEB_INF);
        if (webInf.exists() && webInf.isDirectory()) {
            for (VirtualFile file : webInf.getChildren()) {
                if (file.isFile() && file.getName().endsWith(TLD)) {
                    tlds.put("/" + file.getPathNameRelativeTo(deploymentRoot), this.parseTLD(file));
                    continue;
                }
                if (!file.isDirectory() || CLASSES.equals(file.getName()) || LIB.equals(file.getName())) continue;
                this.processTlds(deploymentRoot, file.getChildren(), tlds);
            }
        }
    }

    private void processTlds(VirtualFile root, List<VirtualFile> files, Map<String, TldMetaData> tlds) throws DeploymentUnitProcessingException {
        for (VirtualFile file : files) {
            if (file.isFile() && file.getName().endsWith(TLD)) {
                tlds.put("/" + file.getPathNameRelativeTo(root), this.parseTLD(file));
                continue;
            }
            if (!file.isDirectory()) continue;
            this.processTlds(root, file.getChildren(), tlds);
        }
    }

    private TldMetaData parseTLD(VirtualFile tld) throws DeploymentUnitProcessingException {
        if (IMPLICIT_TLD.equals(tld.getName())) {
            return new TldMetaData();
        }
        InputStream is = null;
        try {
            is = tld.openStream();
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setXMLResolver(NoopXmlResolver.create());
            XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(is);
            TldMetaData tldMetaData = TldMetaDataParser.parse(xmlReader);
            return tldMetaData;
        }
        catch (Exception e) {
            throw new DeploymentUnitProcessingException("Failed to parse " + tld, (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

