/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.web.AbstractWebSubsystemUpdate;
import org.jboss.as.web.WebSubsystemElement;
import org.jboss.as.web.WebVirtualHostAdd;
import org.jboss.as.web.WebVirtualHostElement;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public class WebVirtualHostRemove
extends AbstractWebSubsystemUpdate<Void> {
    private static final long serialVersionUID = 8956517548114021696L;
    private final String name;

    public WebVirtualHostRemove(String name) {
        this.name = name;
    }

    protected void applyUpdate(WebSubsystemElement element) throws UpdateFailedException {
        if (!element.removeHost(this.name)) {
            throw new UpdateFailedException("no such hosts " + this.name);
        }
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        ServiceController service = updateContext.getServiceContainer().getService(WebSubsystemElement.JBOSS_WEB_HOST.append(new String[]{this.name}));
        if (service == null) {
            resultHandler.handleSuccess(null, param);
        } else {
            service.addListener((ServiceListener)new UpdateResultHandler.ServiceRemoveListener(resultHandler, param));
        }
    }

    public AbstractSubsystemUpdate<WebSubsystemElement, ?> getCompensatingUpdate(WebSubsystemElement original) {
        WebVirtualHostElement host = original.getHost(this.name);
        if (host == null) {
            return null;
        }
        WebVirtualHostAdd action = new WebVirtualHostAdd(this.name);
        action.setAliases(host.getAliases());
        return action;
    }
}

