/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.web.Attribute;
import org.jboss.as.web.Element;
import org.jboss.as.web.WebHostAccessLogElement;
import org.jboss.as.web.WebHostRewriteElement;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class WebVirtualHostElement
extends AbstractModelElement<WebVirtualHostElement> {
    private static final long serialVersionUID = 5587346142770662451L;
    private final String name;
    private Set<String> aliases;
    private WebHostAccessLogElement accessLog;
    private WebHostRewriteElement rewrite;

    public WebVirtualHostElement(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(Set<String> aliases) {
        this.aliases = aliases;
    }

    public WebHostAccessLogElement getAccessLog() {
        return this.accessLog;
    }

    public void setAccessLog(WebHostAccessLogElement accessLog) {
        this.accessLog = accessLog;
    }

    public WebHostRewriteElement getRewrite() {
        return this.rewrite;
    }

    public void setRewrite(WebHostRewriteElement rewrite) {
        this.rewrite = rewrite;
    }

    protected Class<WebVirtualHostElement> getElementClass() {
        return WebVirtualHostElement.class;
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeAttribute(Attribute.NAME.getLocalName(), this.name);
        if (!this.aliases.isEmpty()) {
            for (String alias : this.aliases) {
                streamWriter.writeEmptyElement(Element.ALIAS.getLocalName());
                streamWriter.writeAttribute(Attribute.NAME.getLocalName(), alias);
            }
        }
        if (this.accessLog != null) {
            streamWriter.writeStartElement(Element.ACCESS_LOG.getLocalName());
            this.accessLog.writeContent(streamWriter);
        }
        if (this.rewrite != null) {
            streamWriter.writeStartElement(Element.REWRITE.getLocalName());
            this.rewrite.writeContent(streamWriter);
        }
        streamWriter.writeEndElement();
    }
}

