/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.ExtensionContext;
import org.jboss.as.model.AbstractSubsystemAdd;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.ParseResult;
import org.jboss.as.model.ParseUtils;
import org.jboss.as.web.Attribute;
import org.jboss.as.web.Element;
import org.jboss.as.web.Namespace;
import org.jboss.as.web.WebConnectorAdd;
import org.jboss.as.web.WebContainerConfigElement;
import org.jboss.as.web.WebHostAccessLogElement;
import org.jboss.as.web.WebHostRewriteElement;
import org.jboss.as.web.WebJspConfigurationElement;
import org.jboss.as.web.WebStaticResourcesElement;
import org.jboss.as.web.WebSubsystemAdd;
import org.jboss.as.web.WebSubsystemElement;
import org.jboss.as.web.WebVirtualHostAdd;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class WebSubsystemParser
implements XMLStreamConstants,
XMLElementReader<ParseResult<ExtensionContext.SubsystemConfiguration<WebSubsystemElement>>> {
    private static final WebSubsystemParser INSTANCE = new WebSubsystemParser();

    public static WebSubsystemParser getInstance() {
        return INSTANCE;
    }

    private WebSubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, ParseResult<ExtensionContext.SubsystemConfiguration<WebSubsystemElement>> result) throws XMLStreamException {
        ArrayList updates = new ArrayList();
        WebSubsystemAdd subsystem = new WebSubsystemAdd();
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case WEB_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case CONTAINER_CONFIG: {
                            WebContainerConfigElement config = WebSubsystemParser.parseContainerConfig(reader);
                            subsystem.setConfig(config);
                            continue block8;
                        }
                        case CONNECTOR: {
                            WebSubsystemParser.parseConnector(reader, updates);
                            continue block8;
                        }
                        case VIRTUAL_SERVER: {
                            WebSubsystemParser.parseHost(reader, updates);
                            continue block8;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        result.setResult((Object)new ExtensionContext.SubsystemConfiguration((AbstractSubsystemAdd)subsystem, updates));
    }

    static WebContainerConfigElement parseContainerConfig(XMLExtendedStreamReader reader) throws XMLStreamException {
        WebContainerConfigElement config = new WebContainerConfigElement();
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        HashSet<String> welcomeFiles = new HashSet<String>();
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STATIC_RESOURCES: {
                    WebStaticResourcesElement resourceServing = WebSubsystemParser.parseStaticResourceConfiguration(reader);
                    config.setStaticResources(resourceServing);
                    continue block6;
                }
                case JSP_CONFIGURATION: {
                    WebJspConfigurationElement jspConfiguration = WebSubsystemParser.parseJSPConfiguration(reader);
                    config.setJspConfiguration(jspConfiguration);
                    continue block6;
                }
                case MIME_MAPPING: {
                    Map<String, String> mappings = WebSubsystemParser.parseProperties(reader, Element.MIME_MAPPING, false);
                    if (mappings == null || mappings.isEmpty()) continue block6;
                    config.setMimeMappings(mappings);
                    continue block6;
                }
                case WELCOME_FILE: {
                    String welcomeFile = reader.getElementText().trim();
                    welcomeFiles.add(welcomeFile);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        config.setWelcomeFiles(welcomeFiles);
        return config;
    }

    static WebJspConfigurationElement parseJSPConfiguration(XMLExtendedStreamReader reader) throws XMLStreamException {
        WebJspConfigurationElement config = new WebJspConfigurationElement();
        int count = reader.getAttributeCount();
        block21: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DEVELOPMENT: {
                    config.setDevelopment(Boolean.valueOf(value));
                    continue block21;
                }
                case DISABLED: {
                    config.setDisabled(Boolean.valueOf(value));
                    continue block21;
                }
                case KEEP_GENERATED: {
                    config.setKeepGenerated(Boolean.valueOf(value));
                    continue block21;
                }
                case TRIM_SPACES: {
                    config.setTrimSpaces(Boolean.valueOf(value));
                    continue block21;
                }
                case TAG_POOLING: {
                    config.setTagPooling(Boolean.valueOf(value));
                    continue block21;
                }
                case MAPPED_FILE: {
                    config.setMappedFile(Boolean.valueOf(value));
                    continue block21;
                }
                case CHECK_INTERVAL: {
                    config.setCheckInterval(Integer.valueOf(value));
                    continue block21;
                }
                case MODIFIFICATION_TEST_INTERVAL: {
                    config.setModificationTestInterval(Integer.valueOf(value));
                    continue block21;
                }
                case RECOMPILE_ON_FAIL: {
                    config.setRecompileOnFail(Boolean.valueOf(value));
                }
                case SMAP: {
                    config.setSmap(Boolean.valueOf(value));
                    continue block21;
                }
                case DUMP_SMAP: {
                    config.setDumpSmap(Boolean.valueOf(value));
                    continue block21;
                }
                case GENERATE_STRINGS_AS_CHAR_ARRAYS: {
                    config.setGenerateStringsAsCharArrays(Boolean.valueOf(value));
                    continue block21;
                }
                case ERROR_ON_USE_BEAN_INVALID_CLASS_ATTRIBUT: {
                    config.setErrorOnInvalidClassAttribute(Boolean.valueOf(value));
                    continue block21;
                }
                case SCRATCH_DIR: {
                    config.setScratchDir(value);
                    continue block21;
                }
                case SOURCE_VM: {
                    config.setScratchDir(value);
                    continue block21;
                }
                case TARGET_VM: {
                    config.setTargetVM(value);
                    continue block21;
                }
                case JAVA_ENCODING: {
                    config.setJavaEncoding(value);
                    continue block21;
                }
                case X_POWERED_BY: {
                    config.setXPoweredBy(Boolean.valueOf(value));
                    continue block21;
                }
                case DISPLAY_SOOURCE_FRAGMENT: {
                    config.setDisplaySourceFragment(Boolean.valueOf(value));
                    continue block21;
                }
                default: {
                    ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return config;
    }

    static WebStaticResourcesElement parseStaticResourceConfiguration(XMLExtendedStreamReader reader) throws XMLStreamException {
        WebStaticResourcesElement config = new WebStaticResourcesElement();
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case LISTINGS: {
                    config.setListings(Boolean.valueOf(value));
                    continue block10;
                }
                case SENDFILE: {
                    config.setSendfileSize(Integer.valueOf(value));
                    continue block10;
                }
                case FILE_ENCONDING: {
                    config.setFileEncoding(value);
                }
                case READ_ONLY: {
                    config.setReadOnly(Boolean.valueOf(value));
                    continue block10;
                }
                case WEBDAV: {
                    config.setWebDav(Boolean.valueOf(value));
                    continue block10;
                }
                case SECRET: {
                    config.setSecret(value);
                    continue block10;
                }
                case MAX_DEPTH: {
                    config.setMaxDepth(Integer.valueOf(value));
                    continue block10;
                }
                case DISABLED: {
                    config.setDisabled(Boolean.valueOf(value));
                    continue block10;
                }
                default: {
                    ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return config;
    }

    static void parseConnector(XMLExtendedStreamReader reader, List<AbstractSubsystemUpdate<WebSubsystemElement, ?>> list) throws XMLStreamException {
        String name = null;
        String protocol = null;
        String bindingRef = null;
        String scheme = null;
        String executorRef = null;
        String enabled = null;
        String enableLookups = null;
        String proxyName = null;
        String proxyPort = null;
        String maxPostSize = null;
        String maxSavePostSize = null;
        String secure = null;
        String redirectPort = null;
        int count = reader.getAttributeCount();
        block15: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block15;
                }
                case SOCKET_BINDING: {
                    bindingRef = value;
                    continue block15;
                }
                case SCHEME: {
                    scheme = value;
                    continue block15;
                }
                case PROTOCOL: {
                    protocol = value;
                    continue block15;
                }
                case EXECUTOR: {
                    executorRef = value;
                    continue block15;
                }
                case ENABLED: {
                    enabled = value;
                    continue block15;
                }
                case ENABLE_LOOKUPS: {
                    enableLookups = value;
                    continue block15;
                }
                case PROXY_NAME: {
                    proxyName = value;
                    continue block15;
                }
                case PROXY_PORT: {
                    proxyPort = value;
                    continue block15;
                }
                case MAX_POST_SIZE: {
                    maxPostSize = value;
                    continue block15;
                }
                case MAX_SAVE_POST_SIZE: {
                    maxSavePostSize = value;
                    continue block15;
                }
                case SECURE: {
                    secure = value;
                    continue block15;
                }
                case REDIRECT_PORT: {
                    redirectPort = value;
                    continue block15;
                }
                default: {
                    ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        if (protocol == null) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PROTOCOL));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        WebConnectorAdd action = new WebConnectorAdd(name);
        action.setBindingRef(bindingRef);
        action.setProtocol(protocol);
        action.setScheme(scheme);
        action.setExecutorRef(executorRef);
        action.setProxyName(proxyName);
        if (enabled != null) {
            action.setEnabled(Boolean.valueOf(enabled));
        }
        if (proxyPort != null) {
            action.setProxyPort(Integer.valueOf(proxyPort));
        }
        if (enableLookups != null) {
            action.setEnableLookups(Boolean.valueOf(enableLookups));
        }
        if (redirectPort != null) {
            action.setRedirectPort(Integer.valueOf(redirectPort));
        }
        if (secure != null) {
            action.setSecure(Boolean.valueOf(secure));
        }
        if (maxPostSize != null) {
            action.setMaxPostSize(Integer.valueOf(maxPostSize));
        }
        if (maxSavePostSize != null) {
            action.setMaxSavePostSize(Integer.valueOf(maxSavePostSize));
        }
        list.add(action);
    }

    static void parseHost(XMLExtendedStreamReader reader, List<AbstractSubsystemUpdate<WebSubsystemElement, ?>> list) throws XMLStreamException {
        String name = null;
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block11;
                }
                default: {
                    ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        HashSet<String> aliases = new HashSet<String>();
        WebHostAccessLogElement accessLog = null;
        WebHostRewriteElement rewrite = null;
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case WEB_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case ALIAS: {
                            aliases.add(WebSubsystemParser.readSingleAttributeNoContent(reader));
                            continue block12;
                        }
                        case ACCESS_LOG: {
                            accessLog = WebSubsystemParser.parseHostAccessLog(reader);
                            continue block12;
                        }
                        case REWRITE: {
                            rewrite = WebSubsystemParser.parseHostRewrite(reader);
                            continue block12;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        WebVirtualHostAdd action = new WebVirtualHostAdd(name);
        action.setAliases(aliases);
        action.setAccessLog(accessLog);
        action.setRewrite(rewrite);
        list.add(action);
    }

    static WebHostAccessLogElement parseHostAccessLog(XMLExtendedStreamReader reader) throws XMLStreamException {
        String pattern = null;
        String prefix = null;
        Boolean rotate = null;
        Boolean extended = null;
        Boolean resolveHosts = null;
        WebHostAccessLogElement.LogDirectory directory = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DIRECTORY: {
                    directory = WebSubsystemParser.parseLogDir(reader);
                    if (!directory.isEmpty()) continue block8;
                    directory = null;
                    continue block8;
                }
                case PATTERN: {
                    pattern = value;
                    continue block8;
                }
                case PREFIX: {
                    prefix = value;
                    continue block8;
                }
                case RESOLVE_HOSTS: {
                    resolveHosts = Boolean.valueOf(value);
                    continue block8;
                }
                case EXTENDED: {
                    extended = Boolean.valueOf(value);
                    continue block8;
                }
                case ROTATE: {
                    rotate = Boolean.valueOf(value);
                    continue block8;
                }
                default: {
                    ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        WebHostAccessLogElement accessLog = new WebHostAccessLogElement();
        accessLog.setPattern(pattern);
        accessLog.setExtended(extended);
        accessLog.setPrefix(prefix);
        accessLog.setRotate(rotate);
        accessLog.setResolveHosts(resolveHosts);
        return accessLog;
    }

    static WebHostAccessLogElement.LogDirectory parseLogDir(XMLExtendedStreamReader reader) throws XMLStreamException {
        WebHostAccessLogElement.LogDirectory directory = new WebHostAccessLogElement.LogDirectory();
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case RELATIVE_TO: {
                    directory.setRelativeTo(value.trim());
                    continue block4;
                }
                case PATH: {
                    directory.setPath(value.trim());
                    continue block4;
                }
                default: {
                    ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return directory;
    }

    static WebHostRewriteElement parseHostRewrite(XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return new WebHostRewriteElement();
    }

    static String readSingleAttributeNoContent(XMLExtendedStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        if (count > 1) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)1);
        }
        String value = reader.getAttributeValue(0);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return value.trim();
    }

    static Map<String, String> parseProperties(XMLExtendedStreamReader reader, Element propertyType, boolean allowNullValue) throws XMLStreamException {
        HashMap<String, String> properties = new HashMap<String, String>();
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case WEB_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (element == propertyType) {
                        String name = null;
                        String value = null;
                        int count = reader.getAttributeCount();
                        block8: for (int i = 0; i < count; ++i) {
                            String attrValue = reader.getAttributeValue(i);
                            if (reader.getAttributeNamespace(i) != null) {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                            switch (attribute) {
                                case NAME: {
                                    name = attrValue;
                                    if (!properties.containsKey(name)) continue block8;
                                    throw new XMLStreamException("Property " + name + " already exists", reader.getLocation());
                                }
                                case VALUE: {
                                    value = attrValue;
                                    continue block8;
                                }
                                default: {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                            }
                        }
                        if (name == null) {
                            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
                        }
                        if (value == null && !allowNullValue) {
                            throw new XMLStreamException("Value for property " + name + " is null", reader.getLocation());
                        }
                        properties.put(name, value);
                        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                        continue block7;
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (properties.size() == 0) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton(propertyType));
        }
        return properties;
    }
}

