/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.Collection;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.web.Attribute;
import org.jboss.as.web.Element;
import org.jboss.as.web.WebJspConfigurationElement;
import org.jboss.as.web.WebStaticResourcesElement;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class WebContainerConfigElement
extends AbstractModelElement<WebContainerConfigElement> {
    private static final long serialVersionUID = 1L;
    private WebStaticResourcesElement staticResources;
    private WebJspConfigurationElement jspConfiguration;
    private Map<String, String> mimeMappings;
    private Collection<String> welcomeFiles = new TreeSet<String>();

    protected WebContainerConfigElement() {
    }

    public WebStaticResourcesElement getStaticResources() {
        return this.staticResources;
    }

    public void setStaticResources(WebStaticResourcesElement resourceServing) {
        this.staticResources = resourceServing;
    }

    public WebJspConfigurationElement getJspConfiguration() {
        return this.jspConfiguration;
    }

    public void setJspConfiguration(WebJspConfigurationElement jspConfiguration) {
        this.jspConfiguration = jspConfiguration;
    }

    public Map<String, String> getMimeMappings() {
        return this.mimeMappings;
    }

    public void setMimeMappings(Map<String, String> mimeMappings) {
        this.mimeMappings = mimeMappings;
    }

    public Collection<String> getWelcomeFiles() {
        return this.welcomeFiles;
    }

    public void setWelcomeFiles(Collection<String> welcomeFiles) {
        this.welcomeFiles = welcomeFiles;
    }

    protected Class<WebContainerConfigElement> getElementClass() {
        return WebContainerConfigElement.class;
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        if (this.staticResources != null) {
            streamWriter.writeStartElement(Element.STATIC_RESOURCES.getLocalName());
            this.staticResources.writeContent(streamWriter);
        }
        if (this.jspConfiguration != null) {
            streamWriter.writeStartElement(Element.JSP_CONFIGURATION.getLocalName());
            this.jspConfiguration.writeContent(streamWriter);
        }
        if (this.mimeMappings != null && !this.mimeMappings.isEmpty()) {
            for (Map.Entry entry : this.mimeMappings.entrySet()) {
                streamWriter.writeEmptyElement(Element.MIME_MAPPING.getLocalName());
                streamWriter.writeAttribute(Attribute.NAME.getLocalName(), (String)entry.getKey());
                streamWriter.writeAttribute(Attribute.VALUE.getLocalName(), (String)entry.getValue());
            }
        }
        if (this.welcomeFiles != null && !this.welcomeFiles.isEmpty()) {
            for (String string : this.welcomeFiles) {
                streamWriter.writeStartElement(Element.WELCOME_FILE.getLocalName());
                streamWriter.writeCharacters(string);
                streamWriter.writeEndElement();
            }
        }
        streamWriter.writeEndElement();
    }
}

