/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.metadata.parser.jsp;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    ATTRIBUTE("attribute"),
    BODY_CONTENT("body-content"),
    BODYCONTENT("bodycontent"),
    DECLARE("declare"),
    DEFERRED_METHOD("deferred-method"),
    DEFERRED_VALUE("deferred-value"),
    DYNAMIC_ATTRIBUTES("dynamic-attributes"),
    EXAMPLE("example"),
    EXTENSION_ELEMENT("extension-element"),
    FRAGMENT("fragment"),
    FUNCTION("function"),
    FUNCTION_CLASS("function-class"),
    FUNCTION_EXTENSION("function-extension"),
    FUNCTION_SIGNATURE("function-signature"),
    INFO("info"),
    INIT_PARAM("init-param"),
    JSP_VERSION("jsp-version"),
    JSPVERSION("jspversion"),
    LARGE_ICON("large-icon"),
    LISTENER("listener"),
    LISTENER_CLASS("listener-class"),
    METHOD_SIGNATURE("method-signature"),
    NAME("name"),
    NAME_FROM_ATTRIBUTE("name-from-attribute"),
    NAME_GIVEN("name-given"),
    NAMESPACE("namespace"),
    PATH("path"),
    REQUIRED("required"),
    RTEXPRVALUE("rtexprvalue"),
    SCOPE("scope"),
    SHORT_NAME("short-name"),
    SHORTNAME("shortname"),
    SMALL_ICON("small-icon"),
    TAG_FILE("tag-file"),
    TAG("tag"),
    TAG_CLASS("tag-class"),
    TAG_EXTENSION("tag-extension"),
    TAGCLASS("tagclass"),
    TAGLIB_EXTENSION("taglib-extension"),
    TEI_CLASS("tei-class"),
    TEICLASS("teiclass"),
    TLIB_VERSION("tlib-version"),
    TLIBVERSION("tlibversion"),
    TYPE("type"),
    URI("uri"),
    VALIDATOR("validator"),
    VALIDATOR_CLASS("validator-class"),
    VARIABLE("variable"),
    VARIABLE_CLASS("variable-class");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

