/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.metadata.parser.ee;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.metadata.parser.ee.Attribute;
import org.jboss.as.metadata.parser.ee.DescriptionGroupMetaDataParser;
import org.jboss.as.metadata.parser.ee.Element;
import org.jboss.as.metadata.parser.ee.PortComponentRefParser;
import org.jboss.as.metadata.parser.ee.ResourceInjectionMetaDataParser;
import org.jboss.as.metadata.parser.ee.ServiceReferenceHandlerChainMetaDataParser;
import org.jboss.as.metadata.parser.ee.ServiceReferenceHandlerMetaDataParser;
import org.jboss.as.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.PortComponentRef;
import org.jboss.metadata.javaee.spec.ResourceInjectionMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerChainsMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlersMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;

public class ServiceReferenceMetaDataParser
extends MetaDataElementParser {
    public static ServiceReferenceMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        ServiceReferenceMetaData serviceReference = new ServiceReferenceMetaData();
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    serviceReference.setId(value);
                    continue block14;
                }
                default: {
                    throw ServiceReferenceMetaDataParser.unexpectedAttribute(reader, i);
                }
            }
        }
        DescriptionGroupMetaData descriptionGroup = new DescriptionGroupMetaData();
        block15: while (reader.hasNext() && reader.nextTag() != 2) {
            if (DescriptionGroupMetaDataParser.parse(reader, descriptionGroup)) {
                if (serviceReference.getDescriptionGroup() != null) continue;
                serviceReference.setDescriptionGroup(descriptionGroup);
                continue;
            }
            if (ResourceInjectionMetaDataParser.parse(reader, (ResourceInjectionMetaData)serviceReference)) continue;
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SERVICE_REF_NAME: {
                    serviceReference.setServiceRefName(reader.getElementText());
                    continue block15;
                }
                case SERVICE_INTERFACE: {
                    serviceReference.setServiceInterface(reader.getElementText());
                    continue block15;
                }
                case SERVICE_REF_TYPE: {
                    serviceReference.setServiceRefType(reader.getElementText());
                    continue block15;
                }
                case WSDL_FILE: {
                    serviceReference.setWsdlFile(reader.getElementText());
                    continue block15;
                }
                case JAXRPC_MAPPING_FILE: {
                    serviceReference.setJaxrpcMappingFile(reader.getElementText());
                    continue block15;
                }
                case SERVICE_QNAME: {
                    serviceReference.setServiceQname(ServiceReferenceMetaDataParser.parseQName(reader.getElementText()));
                    continue block15;
                }
                case PORT_COMPONENT_REF: {
                    ArrayList<PortComponentRef> portComponentRefs = serviceReference.getPortComponentRef();
                    if (portComponentRefs == null) {
                        portComponentRefs = new ArrayList<PortComponentRef>();
                        serviceReference.setPortComponentRef(portComponentRefs);
                    }
                    portComponentRefs.add(PortComponentRefParser.parse(reader));
                    continue block15;
                }
                case HANDLER: {
                    ServiceReferenceHandlersMetaData handlers = serviceReference.getHandlers();
                    if (handlers == null) {
                        handlers = new ServiceReferenceHandlersMetaData();
                        serviceReference.setHandlers(handlers);
                    }
                    handlers.add((MappableMetaData)ServiceReferenceHandlerMetaDataParser.parse(reader));
                    continue block15;
                }
                case HANDLER_CHAIN: {
                    ServiceReferenceHandlerChainsMetaData handlerChains = serviceReference.getHandlerChains();
                    if (handlerChains == null) {
                        handlerChains = new ServiceReferenceHandlerChainsMetaData();
                        handlerChains.setHandlers(new ArrayList());
                        serviceReference.setHandlerChains(handlerChains);
                    }
                    handlerChains.getHandlers().add(ServiceReferenceHandlerChainMetaDataParser.parse(reader));
                    continue block15;
                }
            }
            throw ServiceReferenceMetaDataParser.unexpectedElement(reader);
        }
        return serviceReference;
    }
}

