/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.jboss.as.controller.AbstractControllerService;
import org.jboss.as.controller.CompositeOperationHandler;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonProviders;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.validation.OperationValidator;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.ReadTransformedResourceOperation;
import org.jboss.as.server.DeployerChainAddHandler;
import org.jboss.as.server.controller.descriptions.ServerDescriptionProviders;
import org.jboss.as.server.operations.RootResourceHack;
import org.jboss.as.subsystem.test.AbstractSubsystemTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.ControllerInitializer;
import org.jboss.as.subsystem.test.StringConfigurationPersister;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;

class TestModelControllerService
extends AbstractControllerService {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final StringConfigurationPersister persister;
    private final AdditionalInitialization additionalInit;
    private final ControllerInitializer controllerInitializer;
    private final ExtensionRegistry extensionRegistry;
    private final Extension mainExtension;
    private final boolean validateOps;
    private volatile ManagementResourceRegistration rootRegistration;
    private volatile Exception error;
    private volatile boolean bootSuccess;

    TestModelControllerService(Extension mainExtension, ControllerInitializer controllerInitializer, AdditionalInitialization additionalPreStep, ExtensionRegistry extensionRegistry, ControlledProcessState processState, StringConfigurationPersister persister, boolean validateOps) {
        super(additionalPreStep.getProcessType(), new RunningModeControl(additionalPreStep.getRunningMode()), (ConfigurationPersister)persister, processState, AbstractSubsystemTest.DESC_PROVIDER, null, ExpressionResolver.DEFAULT);
        this.persister = persister;
        this.additionalInit = additionalPreStep;
        this.extensionRegistry = extensionRegistry;
        this.mainExtension = mainExtension;
        this.controllerInitializer = controllerInitializer;
        this.validateOps = validateOps;
    }

    protected void initModel(Resource rootResource, ManagementResourceRegistration rootRegistration) {
        this.rootRegistration = rootRegistration;
        rootResource.getModel().get("subsystem");
        rootRegistration.registerOperationHandler("read-resource", GlobalOperationHandlers.READ_RESOURCE, CommonProviders.READ_RESOURCE_PROVIDER, true);
        rootRegistration.registerOperationHandler("read-transformed-resource", (OperationStepHandler)new ReadTransformedResourceOperation(this.extensionRegistry.getTransformerRegistry()), ReadTransformedResourceOperation.DESCRIPTION, true);
        rootRegistration.registerOperationHandler("read-attribute", GlobalOperationHandlers.READ_ATTRIBUTE, CommonProviders.READ_ATTRIBUTE_PROVIDER, true);
        rootRegistration.registerOperationHandler("read-resource-description", GlobalOperationHandlers.READ_RESOURCE_DESCRIPTION, CommonProviders.READ_RESOURCE_DESCRIPTION_PROVIDER, true);
        rootRegistration.registerOperationHandler("read-children-names", GlobalOperationHandlers.READ_CHILDREN_NAMES, CommonProviders.READ_CHILDREN_NAMES_PROVIDER, true);
        rootRegistration.registerOperationHandler("read-children-types", GlobalOperationHandlers.READ_CHILDREN_TYPES, CommonProviders.READ_CHILDREN_TYPES_PROVIDER, true);
        rootRegistration.registerOperationHandler("read-children-resources", GlobalOperationHandlers.READ_CHILDREN_RESOURCES, CommonProviders.READ_CHILDREN_RESOURCES_PROVIDER, true);
        rootRegistration.registerOperationHandler("read-operation-names", GlobalOperationHandlers.READ_OPERATION_NAMES, CommonProviders.READ_OPERATION_NAMES_PROVIDER, true);
        rootRegistration.registerOperationHandler("read-operation-description", GlobalOperationHandlers.READ_OPERATION_DESCRIPTION, CommonProviders.READ_OPERATION_PROVIDER, true);
        rootRegistration.registerOperationHandler("write-attribute", GlobalOperationHandlers.WRITE_ATTRIBUTE, CommonProviders.WRITE_ATTRIBUTE_PROVIDER, true);
        rootRegistration.registerOperationHandler("composite", (OperationStepHandler)CompositeOperationHandler.INSTANCE, (DescriptionProvider)CompositeOperationHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        rootRegistration.registerOperationHandler(AbstractSubsystemTest.RootResourceGrabber.NAME, (OperationStepHandler)AbstractSubsystemTest.RootResourceGrabber.INSTANCE, (DescriptionProvider)AbstractSubsystemTest.RootResourceGrabber.INSTANCE, false);
        ManagementResourceRegistration deployments = rootRegistration.registerSubModel(PathElement.pathElement((String)"deployment"), ServerDescriptionProviders.DEPLOYMENT_PROVIDER);
        rootRegistration.registerOperationHandler("root-resource-hack", (OperationStepHandler)RootResourceHack.INSTANCE, (DescriptionProvider)RootResourceHack.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        this.extensionRegistry.setSubsystemParentResourceRegistrations(rootRegistration, deployments);
        this.controllerInitializer.initializeModel(rootResource, rootRegistration);
        this.additionalInit.initializeExtraSubystemsAndModel(this.extensionRegistry, rootResource, rootRegistration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean boot(List<ModelNode> bootOperations, boolean rollbackOnRuntimeFailure) throws ConfigurationPersistenceException {
        try {
            this.mainExtension.initialize(this.extensionRegistry.getExtensionContext("Test"));
            if (this.validateOps) {
                new OperationValidator((ImmutableManagementResourceRegistration)this.rootRegistration).validateOperations(bootOperations);
            }
            boolean bl = this.bootSuccess = super.boot(this.persister.getBootOperations(), rollbackOnRuntimeFailure);
            return bl;
        }
        catch (Exception e) {
            this.error = e;
        }
        catch (Throwable t) {
            this.error = new Exception(t);
        }
        finally {
            DeployerChainAddHandler.INSTANCE.clearDeployerMap();
            this.latch.countDown();
        }
        return false;
    }

    protected boolean isSuccessfulBoot() {
        return this.bootSuccess;
    }

    public Throwable getBootError() {
        return this.error;
    }

    public void start(StartContext context) throws StartException {
        try {
            super.start(context);
        }
        catch (StartException e) {
            this.error = e;
            this.latch.countDown();
            throw e;
        }
        catch (Exception e) {
            this.error = e;
            this.latch.countDown();
            throw new StartException((Throwable)e);
        }
    }

    public void waitForSetup() throws Exception {
        this.latch.await();
        if (this.error != null) {
            throw this.error;
        }
    }

    public ManagementResourceRegistration getRootRegistration() {
        return this.rootRegistration;
    }
}

