/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import junit.framework.Assert;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.SubsystemInformation;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.SubsystemXmlWriterRegistry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.SubsystemDescriptionDump;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.AdditionalParsers;
import org.jboss.as.subsystem.test.ChildFirstClassLoader;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.as.subsystem.test.KernelServicesBuilder;
import org.jboss.as.subsystem.test.LegacyKernelServicesInitializer;
import org.jboss.as.subsystem.test.ModelDescriptionValidator;
import org.jboss.as.subsystem.test.StringConfigurationPersister;
import org.jboss.as.subsystem.test.TestParser;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLMapper;
import org.junit.After;
import org.junit.Before;
import org.w3c.dom.Document;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;
import org.xnio.IoUtils;

public abstract class AbstractSubsystemTest {
    private static final ThreadLocal<Stack<String>> stack = new ThreadLocal();
    private final String TEST_NAMESPACE = "urn.org.jboss.test:1.0";
    private List<KernelServices> kernelServices = new ArrayList<KernelServices>();
    private final AtomicInteger counter = new AtomicInteger();
    protected final String mainSubsystemName;
    private final Extension mainExtension;
    private ExtensionRegistry extensionParsingRegistry;
    private TestParser testParser;
    private boolean addedExtraParsers;
    private XMLMapper xmlMapper;
    static final DescriptionProvider DESC_PROVIDER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ModelNode model = new ModelNode();
            model.get("description").set("The test model controller");
            return model;
        }
    };
    private final ManagementResourceRegistration MOCK_RESOURCE_REG = new ManagementResourceRegistration(){

        public boolean isRuntimeOnly() {
            return false;
        }

        public boolean isRemote() {
            return false;
        }

        public OperationEntry getOperationEntry(PathAddress address, String operationName) {
            return null;
        }

        public OperationStepHandler getOperationHandler(PathAddress address, String operationName) {
            return null;
        }

        public DescriptionProvider getOperationDescription(PathAddress address, String operationName) {
            return null;
        }

        public Set<OperationEntry.Flag> getOperationFlags(PathAddress address, String operationName) {
            return null;
        }

        public Set<String> getAttributeNames(PathAddress address) {
            return null;
        }

        public AttributeAccess getAttributeAccess(PathAddress address, String attributeName) {
            return null;
        }

        public Set<String> getChildNames(PathAddress address) {
            return null;
        }

        public Set<PathElement> getChildAddresses(PathAddress address) {
            return null;
        }

        public DescriptionProvider getModelDescription(PathAddress address) {
            return null;
        }

        public Map<String, OperationEntry> getOperationDescriptions(PathAddress address, boolean inherited) {
            return null;
        }

        public ProxyController getProxyController(PathAddress address) {
            return null;
        }

        public Set<ProxyController> getProxyControllers(PathAddress address) {
            return null;
        }

        public ManagementResourceRegistration getOverrideModel(String name) {
            return null;
        }

        public ManagementResourceRegistration getSubModel(PathAddress address) {
            return null;
        }

        public ManagementResourceRegistration registerSubModel(PathElement address, DescriptionProvider descriptionProvider) {
            return AbstractSubsystemTest.this.MOCK_RESOURCE_REG;
        }

        public ManagementResourceRegistration registerSubModel(ResourceDefinition resourceDefinition) {
            return AbstractSubsystemTest.this.MOCK_RESOURCE_REG;
        }

        public void unregisterSubModel(PathElement address) {
        }

        public boolean isAllowsOverride() {
            return true;
        }

        public void setRuntimeOnly(boolean runtimeOnly) {
        }

        public ManagementResourceRegistration registerOverrideModel(String name, OverrideDescriptionProvider descriptionProvider) {
            return AbstractSubsystemTest.this.MOCK_RESOURCE_REG;
        }

        public void unregisterOverrideModel(String name) {
        }

        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider) {
        }

        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, EnumSet<OperationEntry.Flag> flags) {
        }

        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited) {
        }

        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, OperationEntry.EntryType entryType) {
        }

        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, EnumSet<OperationEntry.Flag> flags) {
        }

        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, OperationEntry.EntryType entryType, EnumSet<OperationEntry.Flag> flags) {
        }

        public void unregisterOperationHandler(String operationName) {
        }

        public void registerReadWriteAttribute(String attributeName, OperationStepHandler readHandler, OperationStepHandler writeHandler, AttributeAccess.Storage storage) {
        }

        public void registerReadWriteAttribute(String attributeName, OperationStepHandler readHandler, OperationStepHandler writeHandler, EnumSet<AttributeAccess.Flag> flags) {
        }

        public void registerReadWriteAttribute(AttributeDefinition definition, OperationStepHandler readHandler, OperationStepHandler writeHandler) {
        }

        public void registerReadOnlyAttribute(String attributeName, OperationStepHandler readHandler, AttributeAccess.Storage storage) {
        }

        public void registerReadOnlyAttribute(String attributeName, OperationStepHandler readHandler, EnumSet<AttributeAccess.Flag> flags) {
        }

        public void registerReadOnlyAttribute(AttributeDefinition definition, OperationStepHandler readHandler) {
        }

        public void registerMetric(String attributeName, OperationStepHandler metricHandler) {
        }

        public void registerMetric(AttributeDefinition definition, OperationStepHandler metricHandler) {
        }

        public void registerMetric(String attributeName, OperationStepHandler metricHandler, EnumSet<AttributeAccess.Flag> flags) {
        }

        public void unregisterAttribute(String attributeName) {
        }

        public void registerProxyController(PathElement address, ProxyController proxyController) {
        }

        public void unregisterProxyController(PathElement address) {
        }
    };

    protected AbstractSubsystemTest(String mainSubsystemName, Extension mainExtension) {
        this.mainSubsystemName = mainSubsystemName;
        this.mainExtension = mainExtension;
    }

    public String getMainSubsystemName() {
        return this.mainSubsystemName;
    }

    @Before
    public void initializeParser() throws Exception {
        this.xmlMapper = XMLMapper.Factory.create();
        this.testParser = new TestParser(this.mainSubsystemName);
        this.extensionParsingRegistry = new ExtensionRegistry(this.getProcessType(), new RunningModeControl(RunningMode.NORMAL));
        this.xmlMapper.registerRootElement(new QName("urn.org.jboss.test:1.0", "test"), (XMLElementReader)this.testParser);
        this.mainExtension.initializeParsers(this.extensionParsingRegistry.getExtensionParsingContext("Test", this.xmlMapper));
        this.addedExtraParsers = false;
        stack.set(new Stack());
    }

    @After
    public void cleanup() throws Exception {
        for (KernelServices kernelServices : this.kernelServices) {
            try {
                kernelServices.shutdown();
            }
            catch (Exception exception) {}
        }
        this.kernelServices.clear();
        this.xmlMapper = null;
        this.extensionParsingRegistry = null;
        this.testParser = null;
        stack.remove();
    }

    protected Extension getMainExtension() {
        return this.mainExtension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readResource(String name) throws IOException {
        URL configURL = this.getClass().getResource(name);
        Assert.assertNotNull((String)(name + " url is null"), (Object)configURL);
        BufferedReader reader = new BufferedReader(new InputStreamReader(configURL.openStream()));
        StringWriter writer = new StringWriter();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                writer.write(line);
            }
        }
        finally {
            reader.close();
        }
        return writer.toString();
    }

    protected List<ModelNode> parse(String subsystemXml) throws XMLStreamException {
        return this.parse(null, subsystemXml);
    }

    protected List<ModelNode> parse(AdditionalParsers additionalParsers, String subsystemXml) throws XMLStreamException {
        String xml = "<test xmlns=\"urn.org.jboss.test:1.0\">" + subsystemXml + "</test>";
        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(xml));
        this.addAdditionalParsers(additionalParsers);
        ArrayList<ModelNode> operationList = new ArrayList<ModelNode>();
        this.xmlMapper.parseDocument(operationList, reader);
        return operationList;
    }

    protected String outputModel(ModelNode model) throws Exception {
        StringConfigurationPersister persister = new StringConfigurationPersister(Collections.<ModelNode>emptyList(), this.testParser);
        ExtensionRegistry outputExtensionRegistry = new ExtensionRegistry(ProcessType.HOST_CONTROLLER, new RunningModeControl(RunningMode.NORMAL));
        outputExtensionRegistry.setSubsystemParentResourceRegistrations(this.MOCK_RESOURCE_REG, this.MOCK_RESOURCE_REG);
        outputExtensionRegistry.setWriterRegistry((SubsystemXmlWriterRegistry)persister);
        Extension extension = (Extension)this.mainExtension.getClass().newInstance();
        extension.initialize(outputExtensionRegistry.getExtensionContext("Test"));
        ConfigurationPersister.PersistenceResource resource = persister.store(model, Collections.<PathAddress>emptySet());
        resource.commit();
        return persister.marshalled;
    }

    @Deprecated
    protected KernelServices installInController(String subsystemXml) throws Exception {
        return this.createKernelServicesBuilder(null).setSubsystemXml(subsystemXml).build();
    }

    @Deprecated
    protected KernelServices installInController(AdditionalInitialization additionalInit, String subsystemXml) throws Exception {
        return this.createKernelServicesBuilder(additionalInit).setSubsystemXml(subsystemXml).build();
    }

    @Deprecated
    protected KernelServices installInController(List<ModelNode> bootOperations) throws Exception {
        return this.createKernelServicesBuilder(null).setBootOperations(bootOperations).build();
    }

    @Deprecated
    protected KernelServices installInController(AdditionalInitialization additionalInit, List<ModelNode> bootOperations) throws Exception {
        return this.createKernelServicesBuilder(additionalInit).setBootOperations(bootOperations).build();
    }

    protected KernelServicesBuilder createKernelServicesBuilder(AdditionalInitialization additionalInit) {
        return new KernelServicesBuilderImpl(additionalInit);
    }

    protected final ProcessType getProcessType() {
        return ProcessType.EMBEDDED_SERVER;
    }

    protected static ModelNode checkResultAndGetContents(ModelNode result) {
        AbstractSubsystemTest.checkOutcome(result);
        Assert.assertTrue((boolean)result.hasDefined("result"));
        return result.get("result");
    }

    protected static ModelNode checkOutcome(ModelNode result) {
        boolean success = "success".equals(result.get("outcome").asString());
        Assert.assertTrue((String)result.get("failure-description").asString(), (boolean)success);
        return result;
    }

    protected void assertRemoveSubsystemResources(KernelServices kernelServices) {
        this.assertRemoveSubsystemResources(kernelServices, null);
    }

    protected void assertRemoveSubsystemResources(KernelServices kernelServices, Set<PathAddress> ignoredChildAddresses) {
        if (ignoredChildAddresses == null) {
            ignoredChildAddresses = Collections.emptySet();
        } else {
            PathAddress subsystem = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)this.mainSubsystemName)});
            Assert.assertFalse((String)"Cannot exclude removal of subsystem itself", (boolean)ignoredChildAddresses.contains(subsystem));
        }
        Resource rootResource = this.grabRootResource(kernelServices);
        ArrayList<PathAddress> addresses = new ArrayList<PathAddress>();
        PathAddress pathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)this.mainSubsystemName)});
        Resource subsystemResource = rootResource.getChild(pathAddress.getLastElement());
        Assert.assertNotNull((Object)subsystemResource);
        addresses.add(pathAddress);
        this.getAllChildAddressesForRemove(pathAddress, addresses, subsystemResource);
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        composite.get("rollback-on-runtime-failure").set(true);
        ListIterator iterator = addresses.listIterator(addresses.size());
        while (iterator.hasPrevious()) {
            PathAddress cur = (PathAddress)iterator.previous();
            if (ignoredChildAddresses.contains(cur)) continue;
            ModelNode remove = new ModelNode();
            remove.get("operation").set("remove");
            remove.get("address").set(cur.toModelNode());
            composite.get("steps").add(remove);
        }
        ModelNode result = kernelServices.executeOperation(composite);
        ModelNode model = kernelServices.readWholeModel().get(new String[]{"subsystem", this.mainSubsystemName});
        Assert.assertFalse((String)("Subsystem resources were not removed " + model), (boolean)model.isDefined());
    }

    private void getAllChildAddressesForRemove(PathAddress address, List<PathAddress> addresses, Resource resource) {
        ArrayList<PathElement> childElements = new ArrayList<PathElement>();
        for (String type : resource.getChildTypes()) {
            for (String childName : resource.getChildrenNames(type)) {
                PathElement element = PathElement.pathElement((String)type, (String)childName);
                childElements.add(element);
            }
        }
        for (PathElement childElement : childElements) {
            addresses.add(address.append(new PathElement[]{childElement}));
        }
        for (PathElement childElement : childElements) {
            this.getAllChildAddressesForRemove(address.append(new PathElement[]{childElement}), addresses, resource.getChild(childElement));
        }
    }

    protected Resource grabRootResource(KernelServices kernelServices) {
        ModelNode op = new ModelNode();
        op.get("operation").set(RootResourceGrabber.NAME);
        op.get("address").setEmptyList();
        ModelNode result = kernelServices.executeOperation(op);
        Assert.assertEquals((String)result.get("failure-description").asString(), (String)"success", (String)result.get("outcome").asString());
        Resource rootResource = RootResourceGrabber.INSTANCE.resource;
        Assert.assertNotNull((Object)rootResource);
        return rootResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected void generateLegacySubsystemResourceRegistrationDmr(KernelServices kernelServices, ModelVersion modelVersion) throws IOException {
        KernelServices legacy = kernelServices.getLegacyServices(modelVersion);
        PathAddress pathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)this.mainSubsystemName)});
        ModelNode desc = SubsystemDescriptionDump.readFullModelDescription((PathAddress)pathAddress, (ManagementResourceRegistration)legacy.getRootRegistration().getSubModel(pathAddress));
        File file = new File("target/classes").getAbsoluteFile();
        Assert.assertTrue((boolean)file.exists());
        for (String part : TransformerRegistry.class.getPackage().getName().split("\\.")) {
            if ((file = new File(file, part)).exists()) continue;
            file.mkdir();
        }
        PrintWriter pw = new PrintWriter(new File(file, this.mainSubsystemName + "-" + modelVersion.getMajor() + "." + modelVersion.getMinor() + ".dmr"));
        try {
            desc.writeString(pw, false);
        }
        finally {
            IoUtils.safeClose((Closeable)pw);
        }
    }

    protected ModelNode checkSubsystemModelTransformation(KernelServices kernelServices, ModelVersion modelVersion) throws IOException {
        KernelServices legacy = kernelServices.getLegacyServices(modelVersion);
        ModelNode legacyModel = legacy.readWholeModel();
        ModelNode legacySubsystem = legacyModel.require("subsystem");
        legacySubsystem = legacySubsystem.require(this.mainSubsystemName);
        ModelNode transformed = kernelServices.readTransformedModel(modelVersion).get(new String[]{"subsystem", this.mainSubsystemName});
        this.compare(legacySubsystem, transformed, true);
        ResourceDefinition rd = TransformerRegistry.loadSubsystemDefinition((String)this.mainSubsystemName, (ModelVersion)modelVersion);
        ManagementResourceRegistration rr = ManagementResourceRegistration.Factory.create((ResourceDefinition)rd);
        this.checkModelAgainstDefinition(transformed, rr);
        return legacyModel;
    }

    private void checkModelAgainstDefinition(ModelNode model, ManagementResourceRegistration rr) {
        ModelNode value;
        String name;
        Set children = rr.getChildNames(PathAddress.EMPTY_ADDRESS);
        Set attributeNames = rr.getAttributeNames(PathAddress.EMPTY_ADDRESS);
        for (ModelNode el : model.asList()) {
            name = el.asProperty().getName();
            value = el.asProperty().getValue();
            if (attributeNames.contains(name)) {
                AttributeAccess aa = rr.getAttributeAccess(PathAddress.EMPTY_ADDRESS, name);
                Assert.assertNotNull((String)("Attribute " + name + " is not known"), (Object)aa);
                AttributeDefinition ad = aa.getAttributeDefinition();
                if (!value.isDefined()) {
                    Assert.assertTrue((String)("Attribute " + name + " is not allow null"), (boolean)ad.isAllowNull());
                }
                try {
                    if (ad.isAllowNull() || !value.isDefined()) continue;
                    ad.getValidator().validateParameter(name, value);
                }
                catch (OperationFailedException e) {
                    Assert.fail((String)("validation for attribute '" + name + "' failed, " + e.getFailureDescription().asString()));
                }
                continue;
            }
            if (children.contains(name)) continue;
            Assert.fail((String)("Element '" + name + "' is not known in target definition"));
        }
        for (PathElement pe : rr.getChildAddresses(PathAddress.EMPTY_ADDRESS)) {
            if (pe.isWildcard()) {
                if (!children.contains(pe.getKey()) || !model.hasDefined(pe.getKey())) continue;
                for (ModelNode v : model.get(pe.getKey()).asList()) {
                    String name2 = v.asProperty().getName();
                    ModelNode value2 = v.asProperty().getValue();
                    ManagementResourceRegistration sub = rr.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{pe}));
                    Assert.assertNotNull((String)("Child with name '" + name2 + "' not found"), (Object)sub);
                    if (!value2.isDefined()) continue;
                    this.checkModelAgainstDefinition(value2, sub);
                }
                continue;
            }
            if (!children.contains(pe.getKeyValuePair())) continue;
            name = pe.getValue();
            value = model.get(pe.getKeyValuePair());
            ManagementResourceRegistration sub = rr.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{pe}));
            Assert.assertNotNull((String)("Child with name '" + name + "' not found"), (Object)sub);
            if (!value.isDefined()) continue;
            this.checkModelAgainstDefinition(value, sub);
        }
    }

    protected void compare(ModelNode node1, ModelNode node2) {
        this.compare(node1, node2, false);
    }

    protected void compare(ModelNode node1, ModelNode node2, boolean ignoreUndefined) {
        Assert.assertEquals((String)(AbstractSubsystemTest.getCompareStackAsString() + " types"), (Object)node1.getType(), (Object)node2.getType());
        if (node1.getType() == ModelType.OBJECT) {
            ModelNode model1 = ignoreUndefined ? this.trimUndefinedChildren(node1) : node1;
            ModelNode model2 = ignoreUndefined ? this.trimUndefinedChildren(node2) : node2;
            Set keys1 = model1.keys();
            Set keys2 = model2.keys();
            Assert.assertEquals((String)(node1 + "\n" + node2), (int)keys1.size(), (int)keys2.size());
            Assert.assertTrue((boolean)keys1.containsAll(keys2));
            for (String key : keys1) {
                ModelNode child1 = model1.get(key);
                Assert.assertTrue((String)("Missing: " + key + "\n" + node1 + "\n" + node2), (boolean)model2.has(key));
                ModelNode child2 = model2.get(key);
                if (child1.isDefined()) {
                    if (!ignoreUndefined) {
                        Assert.assertTrue((String)("key=" + key + "\n with child1 \n" + child1.toString() + "\n has child2 not defined\n node2 is:\n" + node2.toString()), (boolean)child2.isDefined());
                    }
                    stack.get().push(key + "/");
                    this.compare(child1, child2, ignoreUndefined);
                    stack.get().pop();
                    continue;
                }
                if (ignoreUndefined) continue;
                Assert.assertFalse((String)child2.asString(), (boolean)child2.isDefined());
            }
        } else if (node1.getType() == ModelType.LIST) {
            List list1 = node1.asList();
            List list2 = node2.asList();
            Assert.assertEquals((String)(list1 + "\n" + list2), (int)list1.size(), (int)list2.size());
            for (int i = 0; i < list1.size(); ++i) {
                stack.get().push(i + "/");
                this.compare((ModelNode)list1.get(i), (ModelNode)list2.get(i), ignoreUndefined);
                stack.get().pop();
            }
        } else if (node1.getType() == ModelType.PROPERTY) {
            Property prop1 = node1.asProperty();
            Property prop2 = node2.asProperty();
            Assert.assertEquals((String)(prop1 + "\n" + prop2), (String)prop1.getName(), (String)prop2.getName());
            stack.get().push(prop1.getName() + "/");
            this.compare(prop1.getValue(), prop2.getValue(), ignoreUndefined);
            stack.get().pop();
        } else {
            Assert.assertEquals((String)(AbstractSubsystemTest.getCompareStackAsString() + "\n\"" + node1.asString() + "\"\n\"" + node2.asString() + "\"\n-----"), (String)node2.asString().trim(), (String)node1.asString().trim());
        }
    }

    private ModelNode trimUndefinedChildren(ModelNode model) {
        ModelNode copy = model.clone();
        for (String key : new HashSet(copy.keys())) {
            if (!copy.hasDefined(key)) {
                copy.remove(key);
                continue;
            }
            if (copy.get(key).getType() != ModelType.OBJECT) continue;
            boolean undefined = true;
            for (ModelNode mn : model.get(key).asList()) {
                Property p = mn.asProperty();
                if (p.getValue().getType() != ModelType.OBJECT) continue;
                for (String subKey : new HashSet(p.getValue().keys())) {
                    if (copy.get(new String[]{key, p.getName()}).hasDefined(subKey)) {
                        undefined = false;
                        break;
                    }
                    copy.get(new String[]{key, p.getName()}).remove(subKey);
                }
                if (!undefined) continue;
                copy.get(key).remove(p.getName());
                if (!copy.hasDefined(key)) {
                    copy.remove(key);
                    continue;
                }
                if (copy.get(key).getType() != ModelType.OBJECT || copy.get(key).keys().size() != 0) continue;
                copy.remove(key);
            }
        }
        return copy;
    }

    protected String normalizeXML(String xml) throws Exception {
        xml = xml.replaceAll("\\s*<", "<");
        xml = xml.replaceAll(">\\s*", ">");
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        DOMImplementationLS domLS = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        LSParser lsParser = domLS.createLSParser((short)1, null);
        LSInput input = domLS.createLSInput();
        input.setStringData(xml);
        Document document = lsParser.parse(input);
        LSSerializer lsSerializer = domLS.createLSSerializer();
        lsSerializer.getDomConfig().setParameter("comments", Boolean.FALSE);
        lsSerializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
        return lsSerializer.writeToString(document);
    }

    private static String getCompareStackAsString() {
        String result = "";
        for (String element : stack.get()) {
            result = result + element;
        }
        return result;
    }

    private void addAdditionalParsers(AdditionalParsers additionalParsers) {
        if (additionalParsers != null && !this.addedExtraParsers) {
            additionalParsers.addParsers(this.extensionParsingRegistry, this.xmlMapper);
            this.addedExtraParsers = true;
        }
    }

    private ExtensionRegistry cloneExtensionRegistry(AdditionalInitialization additionalInit) {
        ExtensionRegistry clone = new ExtensionRegistry(additionalInit.getProcessType(), new RunningModeControl(additionalInit.getExtensionRegistryRunningMode()));
        for (String extension : this.extensionParsingRegistry.getExtensionModuleNames()) {
            ExtensionParsingContext epc = clone.getExtensionParsingContext(extension, null);
            for (Map.Entry entry : this.extensionParsingRegistry.getAvailableSubsystems(extension).entrySet()) {
                for (String namespace : ((SubsystemInformation)entry.getValue()).getXMLNamespaces()) {
                    epc.setSubsystemXmlMapping((String)entry.getKey(), namespace, null);
                }
            }
            for (String namespace : this.extensionParsingRegistry.getUnnamedNamespaces(extension)) {
                epc.setSubsystemXmlMapping(namespace, null);
            }
        }
        return clone;
    }

    public static void validateModelDescriptions(PathAddress address, ManagementResourceRegistration reg) {
        ModelNode attributes = reg.getModelDescription(PathAddress.EMPTY_ADDRESS).getModelDescription(Locale.getDefault()).get("attributes");
        Set regAttributeNames = reg.getAttributeNames(PathAddress.EMPTY_ADDRESS);
        HashSet<String> attributeNames = new HashSet<String>();
        if (attributes.isDefined()) {
            if (attributes.asList().size() != regAttributeNames.size()) {
                for (Property p : attributes.asPropertyList()) {
                    attributeNames.add(p.getName());
                }
                if (regAttributeNames.size() > attributeNames.size()) {
                    regAttributeNames.removeAll(attributeNames);
                    Assert.fail((String)("More attributes defined on resource registration than in description, missing: " + regAttributeNames + " for " + address));
                } else if (regAttributeNames.size() < attributeNames.size()) {
                    attributeNames.removeAll(regAttributeNames);
                    Assert.fail((String)("More attributes defined in description than on resource registration, missing: " + attributeNames + " for " + address));
                }
            }
            if (!attributeNames.containsAll(regAttributeNames)) {
                for (Property p : attributes.asPropertyList()) {
                    attributeNames.add(p.getName());
                }
                HashSet missDesc = new HashSet(attributeNames);
                missDesc.removeAll(regAttributeNames);
                HashSet missReg = new HashSet(regAttributeNames);
                missReg.removeAll(attributeNames);
                if (!missReg.isEmpty()) {
                    Assert.fail((String)("There are different attributes defined on resource registration than in description, registered only on Resource Reg: " + missReg + " for " + address));
                }
                if (!missDesc.isEmpty()) {
                    Assert.fail((String)("There are different attributes defined on resource registration than in description, registered only int description: " + missDesc + " for " + address));
                }
            }
        }
        for (PathElement pe : reg.getChildAddresses(PathAddress.EMPTY_ADDRESS)) {
            ManagementResourceRegistration sub = reg.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{pe}));
            AbstractSubsystemTest.validateModelDescriptions(address.append(new PathElement[]{pe}), sub);
        }
    }

    private void validateDescriptionProviders(AdditionalInitialization additionalInit, KernelServices kernelServices) {
        ModelDescriptionValidator.ValidationConfiguration arbitraryDescriptors = additionalInit.getModelValidationConfiguration();
        ModelNode address = new ModelNode();
        address.setEmptyList();
        address.add("subsystem", this.mainSubsystemName);
        ModelNode op = new ModelNode();
        op.get("operation").set("read-resource-description");
        op.get("address").set(address);
        op.get("recursive").set(true);
        op.get("inherited").set(false);
        op.get("operations").set(true);
        ModelNode result = kernelServices.executeOperation(op);
        if (result.hasDefined("failure-description")) {
            throw new RuntimeException(result.get("failure-description").asString());
        }
        ModelNode model = result.get("result");
        ModelDescriptionValidator validator = new ModelDescriptionValidator(address, model, arbitraryDescriptors);
        List<ModelDescriptionValidator.ValidationFailure> validationMessages = validator.validateResource();
        if (validationMessages.size() > 0) {
            StringBuilder builder = new StringBuilder("VALIDATION ERRORS IN MODEL:");
            for (ModelDescriptionValidator.ValidationFailure failure : validationMessages) {
                builder.append(failure);
                builder.append("\n");
            }
            if (arbitraryDescriptors != null) {
                Assert.fail((String)("Failed due to validation errors in the model. Please fix :-) " + builder.toString()));
            }
        }
    }

    protected void compareXml(String configId, String original, String marshalled) throws Exception {
        this.compareXml(configId, original, marshalled, false);
    }

    protected void compareXml(String configId, String original, String marshalled, boolean ignoreNamespace) throws Exception {
        String xmlMarshalled;
        String xmlOriginal;
        if (ignoreNamespace) {
            xmlOriginal = this.removeNamespace(original);
            xmlMarshalled = this.removeNamespace(marshalled);
        } else {
            xmlOriginal = original;
            xmlMarshalled = marshalled;
        }
        Assert.assertEquals((String)this.normalizeXML(xmlOriginal), (String)this.normalizeXML(xmlMarshalled));
    }

    private String removeNamespace(String xml) {
        return xml.replaceFirst(" xmlns=\".*\"", "");
    }

    static class RootResourceGrabber
    implements OperationStepHandler,
    DescriptionProvider {
        static String NAME = "grab-root-resource";
        static RootResourceGrabber INSTANCE = new RootResourceGrabber();
        volatile Resource resource;

        RootResourceGrabber() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            this.resource = context.getRootResource();
            context.getResult().setEmptyObject();
            context.completeStep();
        }

        public ModelNode getModelDescription(Locale locale) {
            ModelNode node = new ModelNode();
            node.get("operation-name").set(NAME);
            node.get("description").set("Grabs the root resource");
            node.get("request-properties").setEmptyObject();
            node.get("reply-properties").setEmptyObject();
            return node;
        }
    }

    private class LegacyKernelServiceInitializerImpl
    implements LegacyKernelServicesInitializer {
        private final AdditionalInitialization additionalInit;
        private String extensionClassName;
        private ModelVersion modelVersion;
        private List<URL> classloaderURLs = new ArrayList<URL>();
        private List<Pattern> parentFirst = new ArrayList<Pattern>();
        private List<Pattern> childFirst = new ArrayList<Pattern>();

        public LegacyKernelServiceInitializerImpl(AdditionalInitialization additionalInit, ModelVersion modelVersion) {
            this.additionalInit = additionalInit == null ? AdditionalInitialization.MANAGEMENT : additionalInit;
            this.modelVersion = modelVersion;
        }

        @Override
        public LegacyKernelServicesInitializer setExtensionClassName(String extensionClassName) {
            this.extensionClassName = extensionClassName;
            return this;
        }

        @Override
        public LegacyKernelServicesInitializer addURL(URL url) {
            this.classloaderURLs.add(url);
            return this;
        }

        @Override
        public LegacyKernelServicesInitializer addSimpleResourceURL(String resource) throws MalformedURLException {
            this.classloaderURLs.add(ChildFirstClassLoader.createSimpleResourceURL(resource));
            return this;
        }

        @Override
        public LegacyKernelServicesInitializer addMavenResourceURL(String artifactGav) throws MalformedURLException {
            this.classloaderURLs.add(ChildFirstClassLoader.createMavenGavURL(artifactGav));
            return this;
        }

        @Override
        public LegacyKernelServiceInitializerImpl addParentFirstClassPattern(String pattern) {
            this.parentFirst.add(this.compilePattern(pattern));
            return this;
        }

        @Override
        public LegacyKernelServiceInitializerImpl addChildFirstClassPattern(String pattern) {
            this.childFirst.add(this.compilePattern(pattern));
            return this;
        }

        private Pattern compilePattern(String pattern) {
            return Pattern.compile(pattern.replace(".", "\\.").replace("*", ".*"));
        }

        private KernelServices install(List<ModelNode> bootOperations) throws Exception {
            ClassLoader parent = this.getClass().getClassLoader() != null ? this.getClass().getClassLoader() : null;
            ChildFirstClassLoader legacyCl = new ChildFirstClassLoader(parent, this.parentFirst, this.childFirst, this.classloaderURLs.toArray(new URL[this.classloaderURLs.size()]));
            Class<?> clazz = legacyCl.loadClass(this.extensionClassName != null ? this.extensionClassName : AbstractSubsystemTest.this.mainExtension.getClass().getName());
            Assert.assertEquals((Object)legacyCl, (Object)clazz.getClassLoader());
            Assert.assertTrue((boolean)Extension.class.isAssignableFrom(clazz));
            Extension extension = (Extension)clazz.newInstance();
            XMLMapper xmlMapper = XMLMapper.Factory.create();
            TestParser testParser = new TestParser(AbstractSubsystemTest.this.mainSubsystemName);
            ExtensionRegistry extensionParsingRegistry = new ExtensionRegistry(this.additionalInit.getProcessType(), new RunningModeControl(this.additionalInit.getExtensionRegistryRunningMode()));
            xmlMapper.registerRootElement(new QName("urn.org.jboss.test:1.0", "test"), (XMLElementReader)testParser);
            extension.initializeParsers(extensionParsingRegistry.getExtensionParsingContext("Test", xmlMapper));
            return KernelServices.create(AbstractSubsystemTest.this.mainSubsystemName, this.additionalInit, AbstractSubsystemTest.this.cloneExtensionRegistry(this.additionalInit), bootOperations, testParser, extension, this.modelVersion);
        }
    }

    private class KernelServicesBuilderImpl
    implements KernelServicesBuilder {
        private final AdditionalInitialization additionalInit;
        private List<ModelNode> bootOperations = Collections.emptyList();
        private String subsystemXml;
        private String subsystemXmlResource;
        private boolean built;
        private Map<ModelVersion, LegacyKernelServiceInitializerImpl> legacyControllerInitializers = new HashMap<ModelVersion, LegacyKernelServiceInitializerImpl>();

        public KernelServicesBuilderImpl(AdditionalInitialization additionalInit) {
            this.additionalInit = additionalInit == null ? new AdditionalInitialization() : additionalInit;
        }

        @Override
        public KernelServicesBuilder setSubsystemXmlResource(String resource) throws IOException, XMLStreamException {
            this.validateNotAlreadyBuilt();
            this.validateSubsystemConfig();
            this.subsystemXmlResource = resource;
            this.internalSetSubsystemXml(AbstractSubsystemTest.this.readResource(resource));
            return this;
        }

        @Override
        public KernelServicesBuilder setSubsystemXml(String subsystemXml) throws XMLStreamException {
            this.validateNotAlreadyBuilt();
            this.validateSubsystemConfig();
            this.subsystemXml = subsystemXml;
            this.internalParseSubsystemXml(subsystemXml);
            return this;
        }

        @Override
        public KernelServicesBuilder setBootOperations(List<ModelNode> bootOperations) {
            this.validateNotAlreadyBuilt();
            this.validateSubsystemConfig();
            this.bootOperations = bootOperations;
            return this;
        }

        @Override
        public LegacyKernelServicesInitializer createLegacyKernelServicesBuilder(AdditionalInitialization additionalInit, ModelVersion modelVersion) {
            this.validateNotAlreadyBuilt();
            if (this.legacyControllerInitializers.containsKey(modelVersion)) {
                throw new IllegalArgumentException("There is already a legacy controller for " + modelVersion);
            }
            if (additionalInit != null && additionalInit.getRunningMode() != RunningMode.ADMIN_ONLY) {
                throw new IllegalArgumentException("The additional initialization must have a running mode of ADMIN_ONLY, it was " + additionalInit.getRunningMode());
            }
            LegacyKernelServiceInitializerImpl initializer = new LegacyKernelServiceInitializerImpl(additionalInit, modelVersion);
            this.legacyControllerInitializers.put(modelVersion, initializer);
            return initializer;
        }

        @Override
        public KernelServices build() throws Exception {
            this.validateNotAlreadyBuilt();
            this.built = true;
            KernelServices kernelServices = KernelServices.create(AbstractSubsystemTest.this.mainSubsystemName, this.additionalInit, AbstractSubsystemTest.this.cloneExtensionRegistry(this.additionalInit), this.bootOperations, AbstractSubsystemTest.this.testParser, AbstractSubsystemTest.this.mainExtension, null);
            AbstractSubsystemTest.this.kernelServices.add(kernelServices);
            AbstractSubsystemTest.this.validateDescriptionProviders(this.additionalInit, kernelServices);
            ManagementResourceRegistration subsystemReg = kernelServices.getRootRegistration().getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)AbstractSubsystemTest.this.mainSubsystemName)}));
            AbstractSubsystemTest.validateModelDescriptions(PathAddress.EMPTY_ADDRESS, subsystemReg);
            for (Map.Entry<ModelVersion, LegacyKernelServiceInitializerImpl> entry : this.legacyControllerInitializers.entrySet()) {
                LegacyKernelServiceInitializerImpl legacyInitializer = entry.getValue();
                ArrayList<ModelNode> transformedBootOperations = new ArrayList<ModelNode>();
                for (ModelNode op : this.bootOperations) {
                    ModelNode transformed = kernelServices.transformOperation(entry.getKey(), op).getTransformedOperation();
                    if (transformed == null) continue;
                    transformedBootOperations.add(transformed);
                }
                KernelServices legacyServices = legacyInitializer.install(transformedBootOperations);
                kernelServices.addLegacyKernelService(entry.getKey(), legacyServices);
            }
            return kernelServices;
        }

        private void internalSetSubsystemXml(String subsystemXml) throws XMLStreamException {
            this.subsystemXml = subsystemXml;
            this.internalParseSubsystemXml(subsystemXml);
        }

        private void internalParseSubsystemXml(String subsystemXml) throws XMLStreamException {
            this.bootOperations = AbstractSubsystemTest.this.parse(this.additionalInit, subsystemXml);
        }

        private void validateSubsystemConfig() {
            if (this.subsystemXmlResource != null) {
                throw new IllegalArgumentException("Xml resource is already set");
            }
            if (this.subsystemXml != null) {
                throw new IllegalArgumentException("Xml string is already set");
            }
            if (this.bootOperations != Collections.EMPTY_LIST) {
                throw new IllegalArgumentException("Boot operations are already set");
            }
        }

        private void validateNotAlreadyBuilt() {
            if (this.built) {
                throw new IllegalStateException("Already built");
            }
        }
    }
}

