/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.AbstractControllerService;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CompositeOperationHandler;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ExtensionContextImpl;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonProviders;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.AbstractConfigurationPersister;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.persistence.SubsystemXmlWriterRegistry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.DeployerChainAddHandler;
import org.jboss.as.server.Services;
import org.jboss.as.server.controller.descriptions.ServerDescriptionProviders;
import org.jboss.as.server.deployment.repository.impl.ContentRepositoryImpl;
import org.jboss.as.server.operations.RootResourceHack;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.AdditionalParsers;
import org.jboss.as.subsystem.test.ControllerInitializer;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.as.subsystem.test.ModelDescriptionValidator;
import org.jboss.as.subsystem.test.OperationValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.jboss.staxmapper.XMLMapper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.w3c.dom.Document;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;

public abstract class AbstractSubsystemTest {
    private static final ThreadLocal<Stack<String>> stack = new ThreadLocal();
    private final String TEST_NAMESPACE = "urn.org.jboss.test:1.0";
    private ExtensionParsingContextImpl parsingContext;
    private List<KernelServices> kernelServices = new ArrayList<KernelServices>();
    private final AtomicInteger counter = new AtomicInteger();
    protected final String mainSubsystemName;
    private final Extension mainExtension;
    private TestParser testParser;
    private boolean addedExtraParsers;
    private StringConfigurationPersister persister;
    private static final DescriptionProvider DESC_PROVIDER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ModelNode model = new ModelNode();
            model.get("description").set("The test model controller");
            return model;
        }
    };
    private final ManagementResourceRegistration MOCK_RESOURCE_REG = new ManagementResourceRegistration(){

        public boolean isRuntimeOnly() {
            return false;
        }

        public boolean isRemote() {
            return false;
        }

        public OperationEntry getOperationEntry(PathAddress address, String operationName) {
            return null;
        }

        public OperationStepHandler getOperationHandler(PathAddress address, String operationName) {
            return null;
        }

        public DescriptionProvider getOperationDescription(PathAddress address, String operationName) {
            return null;
        }

        public Set<OperationEntry.Flag> getOperationFlags(PathAddress address, String operationName) {
            return null;
        }

        public Set<String> getAttributeNames(PathAddress address) {
            return null;
        }

        public AttributeAccess getAttributeAccess(PathAddress address, String attributeName) {
            return null;
        }

        public Set<String> getChildNames(PathAddress address) {
            return null;
        }

        public Set<PathElement> getChildAddresses(PathAddress address) {
            return null;
        }

        public DescriptionProvider getModelDescription(PathAddress address) {
            return null;
        }

        public Map<String, OperationEntry> getOperationDescriptions(PathAddress address, boolean inherited) {
            return null;
        }

        public ProxyController getProxyController(PathAddress address) {
            return null;
        }

        public Set<ProxyController> getProxyControllers(PathAddress address) {
            return null;
        }

        public ManagementResourceRegistration getOverrideModel(String name) {
            return null;
        }

        public ManagementResourceRegistration getSubModel(PathAddress address) {
            return null;
        }

        public ManagementResourceRegistration registerSubModel(PathElement address, DescriptionProvider descriptionProvider) {
            return AbstractSubsystemTest.this.MOCK_RESOURCE_REG;
        }

        public ManagementResourceRegistration registerSubModel(ResourceDefinition resourceDefinition) {
            return AbstractSubsystemTest.this.MOCK_RESOURCE_REG;
        }

        public void unregisterSubModel(PathElement address) {
        }

        public boolean isAllowsOverride() {
            return true;
        }

        public void setRuntimeOnly(boolean runtimeOnly) {
        }

        public ManagementResourceRegistration registerOverrideModel(String name, OverrideDescriptionProvider descriptionProvider) {
            return AbstractSubsystemTest.this.MOCK_RESOURCE_REG;
        }

        public void unregisterOverrideModel(String name) {
        }

        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider) {
        }

        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, EnumSet<OperationEntry.Flag> flags) {
        }

        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited) {
        }

        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, OperationEntry.EntryType entryType) {
        }

        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, OperationEntry.EntryType entryType, EnumSet<OperationEntry.Flag> flags) {
        }

        public void unregisterOperationHandler(String operationName) {
        }

        public void registerReadWriteAttribute(String attributeName, OperationStepHandler readHandler, OperationStepHandler writeHandler, AttributeAccess.Storage storage) {
        }

        public void registerReadWriteAttribute(String attributeName, OperationStepHandler readHandler, OperationStepHandler writeHandler, EnumSet<AttributeAccess.Flag> flags) {
        }

        public void registerReadWriteAttribute(AttributeDefinition definition, OperationStepHandler readHandler, OperationStepHandler writeHandler) {
        }

        public void registerReadOnlyAttribute(String attributeName, OperationStepHandler readHandler, AttributeAccess.Storage storage) {
        }

        public void registerReadOnlyAttribute(String attributeName, OperationStepHandler readHandler, EnumSet<AttributeAccess.Flag> flags) {
        }

        public void registerReadOnlyAttribute(AttributeDefinition definition, OperationStepHandler readHandler) {
        }

        public void registerMetric(String attributeName, OperationStepHandler metricHandler) {
        }

        public void registerMetric(AttributeDefinition definition, OperationStepHandler metricHandler) {
        }

        public void registerMetric(String attributeName, OperationStepHandler metricHandler, EnumSet<AttributeAccess.Flag> flags) {
        }

        public void unregisterAttribute(String attributeName) {
        }

        public void registerProxyController(PathElement address, ProxyController proxyController) {
        }

        public void unregisterProxyController(PathElement address) {
        }
    };

    protected AbstractSubsystemTest(String mainSubsystemName, Extension mainExtension) {
        this.mainSubsystemName = mainSubsystemName;
        this.mainExtension = mainExtension;
    }

    public String getMainSubsystemName() {
        return this.mainSubsystemName;
    }

    @Before
    public void initializeParser() throws Exception {
        XMLMapper mapper = XMLMapper.Factory.create();
        this.testParser = new TestParser();
        mapper.registerRootElement(new QName("urn.org.jboss.test:1.0", "test"), (XMLElementReader)this.testParser);
        this.parsingContext = new ExtensionParsingContextImpl(mapper);
        this.mainExtension.initializeParsers((ExtensionParsingContext)this.parsingContext);
        this.addedExtraParsers = false;
        stack.set(new Stack());
    }

    @After
    public void cleanup() throws Exception {
        for (KernelServices kernelServices : this.kernelServices) {
            try {
                kernelServices.shutdown();
            }
            catch (Exception exception) {}
        }
        this.kernelServices.clear();
        this.parsingContext = null;
        this.testParser = null;
        stack.remove();
    }

    protected Extension getMainExtension() {
        return this.mainExtension;
    }

    protected String readResource(String name) throws IOException {
        String line;
        URL configURL = this.getClass().getResource(name);
        Assert.assertNotNull((String)(name + " url is null"), (Object)configURL);
        BufferedReader reader = new BufferedReader(new InputStreamReader(configURL.openStream()));
        StringWriter writer = new StringWriter();
        while ((line = reader.readLine()) != null) {
            writer.write(line);
        }
        return writer.toString();
    }

    protected List<ModelNode> parse(String subsystemXml) throws XMLStreamException {
        return this.parse(null, subsystemXml);
    }

    protected List<ModelNode> parse(AdditionalParsers additionalParsers, String subsystemXml) throws XMLStreamException {
        this.addAdditionalParsers(additionalParsers);
        String xml = "<test xmlns=\"urn.org.jboss.test:1.0\">" + subsystemXml + "</test>";
        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(xml));
        ArrayList<ModelNode> operationList = new ArrayList<ModelNode>();
        this.parsingContext.getMapper().parseDocument(operationList, reader);
        return operationList;
    }

    protected String outputModel(ModelNode model) throws Exception {
        return this.outputModel(null, model);
    }

    protected String outputModel(AdditionalParsers additionalParsers, ModelNode model) throws Exception {
        this.addAdditionalParsers(additionalParsers);
        StringConfigurationPersister persister = new StringConfigurationPersister(Collections.<ModelNode>emptyList(), this.testParser);
        Extension extension = (Extension)this.mainExtension.getClass().newInstance();
        extension.initialize(new ExtensionContextImpl(this.MOCK_RESOURCE_REG, this.MOCK_RESOURCE_REG, (SubsystemXmlWriterRegistry)persister, ProcessType.EMBEDDED_SERVER).createTracking("Test"));
        ConfigurationPersister.PersistenceResource resource = persister.store(model, Collections.<PathAddress>emptySet());
        resource.commit();
        return persister.marshalled;
    }

    protected KernelServices installInController(String subsystemXml) throws Exception {
        return this.installInController(null, subsystemXml);
    }

    protected KernelServices installInController(AdditionalInitialization additionalInit, String subsystemXml) throws Exception {
        if (additionalInit == null) {
            additionalInit = new AdditionalInitialization();
        }
        List<ModelNode> operations = this.parse(additionalInit, subsystemXml);
        KernelServices services = this.installInController(additionalInit, operations);
        return services;
    }

    protected KernelServices installInController(List<ModelNode> bootOperations) throws Exception {
        return this.installInController(null, bootOperations);
    }

    protected KernelServices installInController(AdditionalInitialization additionalInit, List<ModelNode> bootOperations) throws Exception {
        if (additionalInit == null) {
            additionalInit = new AdditionalInitialization();
        }
        ControllerInitializer controllerInitializer = additionalInit.createControllerInitializer();
        additionalInit.setupController(controllerInitializer);
        ServiceContainer container = ServiceContainer.Factory.create((String)("test" + this.counter.incrementAndGet()));
        ServiceTarget target = container.subTarget();
        ControlledProcessState processState = new ControlledProcessState(true);
        List<ModelNode> extraOps = controllerInitializer.initializeBootOperations();
        ArrayList<ModelNode> allOps = new ArrayList<ModelNode>();
        if (extraOps != null) {
            allOps.addAll(extraOps);
        }
        allOps.addAll(bootOperations);
        StringConfigurationPersister persister = new StringConfigurationPersister(allOps, this.testParser);
        ModelControllerService svc = new ModelControllerService(this.mainExtension, controllerInitializer, additionalInit, processState, persister, additionalInit.isValidateOperations());
        ServiceBuilder builder = target.addService(Services.JBOSS_SERVER_CONTROLLER, (Service)svc);
        builder.install();
        additionalInit.addExtraServices(target);
        svc.latch.await();
        ModelController controller = svc.getValue();
        ModelNode setup = Util.getEmptyOperation((String)"setup", (ModelNode)new ModelNode());
        controller.execute(setup, null, null, null);
        processState.setRunning();
        KernelServices kernelServices = new KernelServices(container, controller, persister, new OperationValidator(svc.rootRegistration));
        this.kernelServices.add(kernelServices);
        if (svc.error != null) {
            throw svc.error;
        }
        this.validateDescriptionProviders(additionalInit, kernelServices);
        return kernelServices;
    }

    protected static ModelNode checkResultAndGetContents(ModelNode result) {
        junit.framework.Assert.assertEquals((String)"success", (String)result.get("outcome").asString());
        junit.framework.Assert.assertTrue((boolean)result.hasDefined("result"));
        return result.get("result");
    }

    protected void assertRemoveSubsystemResources(KernelServices kernelServices) {
        this.assertRemoveSubsystemResources(kernelServices, null);
    }

    protected void assertRemoveSubsystemResources(KernelServices kernelServices, Set<PathAddress> ignoredChildAddresses) {
        if (ignoredChildAddresses == null) {
            ignoredChildAddresses = Collections.emptySet();
        } else {
            PathAddress subsystem = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)this.mainSubsystemName)});
            junit.framework.Assert.assertFalse((String)"Cannot exclude removal of subsystem itself", (boolean)ignoredChildAddresses.contains(subsystem));
        }
        Resource rootResource = this.grabRootResource(kernelServices);
        ArrayList<PathAddress> addresses = new ArrayList<PathAddress>();
        PathAddress pathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)this.mainSubsystemName)});
        Resource subsystemResource = rootResource.getChild(pathAddress.getLastElement());
        junit.framework.Assert.assertNotNull((Object)subsystemResource);
        addresses.add(pathAddress);
        this.getAllChildAddressesForRemove(pathAddress, addresses, subsystemResource);
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        composite.get("rollback-on-runtime-failure").set(true);
        ListIterator iterator = addresses.listIterator(addresses.size());
        while (iterator.hasPrevious()) {
            PathAddress cur = (PathAddress)iterator.previous();
            if (ignoredChildAddresses.contains(cur)) continue;
            ModelNode remove = new ModelNode();
            remove.get("operation").set("remove");
            remove.get("address").set(cur.toModelNode());
            composite.get("steps").add(remove);
        }
        ModelNode result = kernelServices.executeOperation(composite);
        ModelNode model = kernelServices.readWholeModel().get(new String[]{"subsystem", this.mainSubsystemName});
        junit.framework.Assert.assertFalse((String)("Subsystem resources were not removed " + model), (boolean)model.isDefined());
    }

    private void getAllChildAddressesForRemove(PathAddress address, List<PathAddress> addresses, Resource resource) {
        ArrayList<PathElement> childElements = new ArrayList<PathElement>();
        for (String type : resource.getChildTypes()) {
            for (String childName : resource.getChildrenNames(type)) {
                PathElement element = PathElement.pathElement((String)type, (String)childName);
                childElements.add(element);
            }
        }
        for (PathElement childElement : childElements) {
            addresses.add(address.append(new PathElement[]{childElement}));
        }
        for (PathElement childElement : childElements) {
            this.getAllChildAddressesForRemove(address.append(new PathElement[]{childElement}), addresses, resource.getChild(childElement));
        }
    }

    protected Resource grabRootResource(KernelServices kernelServices) {
        ModelNode op = new ModelNode();
        op.get("operation").set(RootResourceGrabber.NAME);
        op.get("address").setEmptyList();
        ModelNode result = kernelServices.executeOperation(op);
        junit.framework.Assert.assertEquals((String)result.get("failure-description").asString(), (String)"success", (String)result.get("outcome").asString());
        Resource rootResource = RootResourceGrabber.INSTANCE.resource;
        junit.framework.Assert.assertNotNull((Object)rootResource);
        return rootResource;
    }

    protected void compare(ModelNode node1, ModelNode node2) {
        junit.framework.Assert.assertEquals((String)(AbstractSubsystemTest.getCompareStackAsString() + " types"), (Object)node1.getType(), (Object)node2.getType());
        if (node1.getType() == ModelType.OBJECT) {
            Set keys1 = node1.keys();
            Set keys2 = node2.keys();
            junit.framework.Assert.assertEquals((String)(node1 + "\n" + node2), (int)keys1.size(), (int)keys2.size());
            for (String key : keys1) {
                ModelNode child1 = node1.get(key);
                junit.framework.Assert.assertTrue((String)("Missing: " + key + "\n" + node1 + "\n" + node2), (boolean)node2.has(key));
                ModelNode child2 = node2.get(key);
                if (child1.isDefined()) {
                    junit.framework.Assert.assertTrue((String)("key=" + key + "\n with child1 \n" + child1.toString() + "\n has child2 not defined\n node2 is:\n" + node2.toString()), (boolean)child2.isDefined());
                    stack.get().push(key + "/");
                    this.compare(child1, child2);
                    stack.get().pop();
                    continue;
                }
                junit.framework.Assert.assertFalse((String)child2.asString(), (boolean)child2.isDefined());
            }
        } else if (node1.getType() == ModelType.LIST) {
            List list1 = node1.asList();
            List list2 = node2.asList();
            junit.framework.Assert.assertEquals((String)(list1 + "\n" + list2), (int)list1.size(), (int)list2.size());
            for (int i = 0; i < list1.size(); ++i) {
                stack.get().push(i + "/");
                this.compare((ModelNode)list1.get(i), (ModelNode)list2.get(i));
                stack.get().pop();
            }
        } else if (node1.getType() == ModelType.PROPERTY) {
            Property prop1 = node1.asProperty();
            Property prop2 = node2.asProperty();
            junit.framework.Assert.assertEquals((String)(prop1 + "\n" + prop2), (String)prop1.getName(), (String)prop2.getName());
            stack.get().push(prop1.getName() + "/");
            this.compare(prop1.getValue(), prop2.getValue());
            stack.get().pop();
        } else {
            junit.framework.Assert.assertEquals((String)(AbstractSubsystemTest.getCompareStackAsString() + "\n\"" + node1.asString() + "\"\n\"" + node2.asString() + "\"\n-----"), (String)node2.asString().trim(), (String)node1.asString().trim());
        }
    }

    protected String normalizeXML(String xml) throws Exception {
        xml = xml.replaceAll("\\s*<", "<");
        xml = xml.replaceAll(">\\s*", ">");
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        DOMImplementationLS domLS = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        LSParser lsParser = domLS.createLSParser((short)1, null);
        LSInput input = domLS.createLSInput();
        input.setStringData(xml);
        Document document = lsParser.parse(input);
        LSSerializer lsSerializer = domLS.createLSSerializer();
        lsSerializer.getDomConfig().setParameter("comments", Boolean.FALSE);
        lsSerializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
        return lsSerializer.writeToString(document);
    }

    private static String getCompareStackAsString() {
        String result = "";
        for (String element : stack.get()) {
            result = result + element;
        }
        return result;
    }

    private void addAdditionalParsers(AdditionalParsers additionalParsers) {
        if (additionalParsers != null && !this.addedExtraParsers) {
            additionalParsers.addParsers(this.parsingContext);
            this.addedExtraParsers = true;
        }
    }

    private void validateDescriptionProviders(AdditionalInitialization additionalInit, KernelServices kernelServices) {
        ModelDescriptionValidator.ValidationConfiguration arbitraryDescriptors = additionalInit.getModelValidationConfiguration();
        ModelNode address = new ModelNode();
        address.setEmptyList();
        address.add("subsystem", this.mainSubsystemName);
        ModelNode op = new ModelNode();
        op.get("operation").set("read-resource-description");
        op.get("address").set(address);
        op.get("recursive").set(true);
        op.get("inherited").set(false);
        op.get("operations").set(true);
        ModelNode result = kernelServices.executeOperation(op);
        if (result.hasDefined("failure-description")) {
            throw new RuntimeException(result.get("failure-description").asString());
        }
        ModelNode model = result.get("result");
        ModelDescriptionValidator validator = new ModelDescriptionValidator(address, model, arbitraryDescriptors);
        List<ModelDescriptionValidator.ValidationFailure> validationMessages = validator.validateResource();
        if (validationMessages.size() > 0) {
            StringBuilder builder = new StringBuilder("VALIDATION ERRORS IN MODEL:");
            for (ModelDescriptionValidator.ValidationFailure failure : validationMessages) {
                builder.append(failure);
                builder.append("\n");
            }
            if (arbitraryDescriptors != null) {
                junit.framework.Assert.fail((String)("Failed due to validation errors in the model. Please fix :-) " + builder.toString()));
            }
        }
    }

    protected void compareXml(String configId, String original, String marshalled) throws Exception {
        this.compareXml(configId, original, marshalled, false);
    }

    protected void compareXml(String configId, String original, String marshalled, boolean ignoreNamespace) throws Exception {
        String xmlMarshalled;
        String xmlOriginal;
        if (ignoreNamespace) {
            xmlOriginal = this.removeNamespace(original);
            xmlMarshalled = this.removeNamespace(marshalled);
        } else {
            xmlOriginal = original;
            xmlMarshalled = marshalled;
        }
        junit.framework.Assert.assertEquals((String)this.normalizeXML(xmlOriginal), (String)this.normalizeXML(xmlMarshalled));
    }

    private String removeNamespace(String xml) {
        return xml.replaceFirst(" xmlns=\".*\"", "");
    }

    private static class RootResourceGrabber
    implements OperationStepHandler,
    DescriptionProvider {
        static String NAME = "grab-root-resource";
        static RootResourceGrabber INSTANCE = new RootResourceGrabber();
        volatile Resource resource;

        private RootResourceGrabber() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            this.resource = context.getRootResource();
            context.getResult().setEmptyObject();
            context.completeStep();
        }

        public ModelNode getModelDescription(Locale locale) {
            ModelNode node = new ModelNode();
            node.get("operation-name").set(NAME);
            node.get("description").set("Grabs the root resource");
            node.get("request-properties").setEmptyObject();
            node.get("reply-properties").setEmptyObject();
            return node;
        }
    }

    private static class TestContentRepository
    extends ContentRepositoryImpl {
        private TestContentRepository(File repoRoot) {
            super(repoRoot);
        }

        public static TestContentRepository createTestContentRepository() {
            File file = new File("target/content-repository");
            if (file.exists()) {
                TestContentRepository.cleanFiles(file);
            }
            file.mkdirs();
            return new TestContentRepository(file);
        }

        private static void cleanFiles(File file) {
            if (file.isDirectory()) {
                for (String name : file.list()) {
                    File current = new File(file, name);
                    if (!current.isDirectory()) continue;
                    TestContentRepository.cleanFiles(current);
                }
            }
            file.delete();
        }
    }

    static class StringConfigurationPersister
    extends AbstractConfigurationPersister {
        private final List<ModelNode> bootOperations;
        volatile String marshalled;

        public StringConfigurationPersister(List<ModelNode> bootOperations, XMLElementWriter<ModelMarshallingContext> rootDeparser) {
            super(rootDeparser);
            this.bootOperations = bootOperations;
        }

        public ConfigurationPersister.PersistenceResource store(ModelNode model, Set<PathAddress> affectedAddresses) throws ConfigurationPersistenceException {
            return new StringPersistenceResource(model, this);
        }

        public List<ModelNode> load() throws ConfigurationPersistenceException {
            return this.bootOperations;
        }

        private class StringPersistenceResource
        implements ConfigurationPersister.PersistenceResource {
            private byte[] bytes;
            private final AbstractConfigurationPersister persister;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            StringPersistenceResource(ModelNode model, AbstractConfigurationPersister persister) throws ConfigurationPersistenceException {
                this.persister = persister;
                ByteArrayOutputStream output = new ByteArrayOutputStream(8192);
                try {
                    try {
                        persister.marshallAsXml(model, (OutputStream)output);
                    }
                    finally {
                        try {
                            output.close();
                        }
                        catch (Exception ignore) {}
                        this.bytes = output.toByteArray();
                    }
                }
                catch (Exception e) {
                    throw new ConfigurationPersistenceException("Failed to marshal configuration", (Throwable)e);
                }
            }

            public void commit() {
                StringConfigurationPersister.this.marshalled = new String(this.bytes);
            }

            public void rollback() {
                StringConfigurationPersister.this.marshalled = null;
            }
        }
    }

    private static class ModelControllerService
    extends AbstractControllerService {
        final AtomicBoolean state = new AtomicBoolean(true);
        final CountDownLatch latch = new CountDownLatch(1);
        final StringConfigurationPersister persister;
        final AdditionalInitialization additionalInit;
        final ControllerInitializer controllerInitializer;
        final Extension mainExtension;
        final boolean validateOps;
        volatile ManagementResourceRegistration rootRegistration;
        volatile Exception error;

        ModelControllerService(Extension mainExtension, ControllerInitializer controllerInitializer, AdditionalInitialization additionalPreStep, ControlledProcessState processState, StringConfigurationPersister persister, boolean validateOps) {
            super(additionalPreStep.getProcessType(), new RunningModeControl(additionalPreStep.getRunningMode()), (ConfigurationPersister)persister, processState, DESC_PROVIDER, null, ExpressionResolver.DEFAULT);
            this.persister = persister;
            this.additionalInit = additionalPreStep;
            this.mainExtension = mainExtension;
            this.controllerInitializer = controllerInitializer;
            this.validateOps = validateOps;
        }

        protected void initModel(Resource rootResource, ManagementResourceRegistration rootRegistration) {
            this.rootRegistration = rootRegistration;
            rootResource.getModel().get("subsystem");
            rootRegistration.registerOperationHandler("read-resource", GlobalOperationHandlers.READ_RESOURCE, CommonProviders.READ_RESOURCE_PROVIDER, true);
            rootRegistration.registerOperationHandler("read-attribute", GlobalOperationHandlers.READ_ATTRIBUTE, CommonProviders.READ_ATTRIBUTE_PROVIDER, true);
            rootRegistration.registerOperationHandler("read-resource-description", GlobalOperationHandlers.READ_RESOURCE_DESCRIPTION, CommonProviders.READ_RESOURCE_DESCRIPTION_PROVIDER, true);
            rootRegistration.registerOperationHandler("read-children-names", GlobalOperationHandlers.READ_CHILDREN_NAMES, CommonProviders.READ_CHILDREN_NAMES_PROVIDER, true);
            rootRegistration.registerOperationHandler("read-children-types", GlobalOperationHandlers.READ_CHILDREN_TYPES, CommonProviders.READ_CHILDREN_TYPES_PROVIDER, true);
            rootRegistration.registerOperationHandler("read-children-resources", GlobalOperationHandlers.READ_CHILDREN_RESOURCES, CommonProviders.READ_CHILDREN_RESOURCES_PROVIDER, true);
            rootRegistration.registerOperationHandler("read-operation-names", GlobalOperationHandlers.READ_OPERATION_NAMES, CommonProviders.READ_OPERATION_NAMES_PROVIDER, true);
            rootRegistration.registerOperationHandler("read-operation-description", GlobalOperationHandlers.READ_OPERATION_DESCRIPTION, CommonProviders.READ_OPERATION_PROVIDER, true);
            rootRegistration.registerOperationHandler("write-attribute", GlobalOperationHandlers.WRITE_ATTRIBUTE, CommonProviders.WRITE_ATTRIBUTE_PROVIDER, true);
            rootRegistration.registerOperationHandler("composite", (OperationStepHandler)CompositeOperationHandler.INSTANCE, (DescriptionProvider)CompositeOperationHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
            rootRegistration.registerOperationHandler(RootResourceGrabber.NAME, (OperationStepHandler)RootResourceGrabber.INSTANCE, (DescriptionProvider)RootResourceGrabber.INSTANCE, false);
            ManagementResourceRegistration deployments = rootRegistration.registerSubModel(PathElement.pathElement((String)"deployment"), ServerDescriptionProviders.DEPLOYMENT_PROVIDER);
            rootRegistration.registerOperationHandler("root-resource-hack", (OperationStepHandler)RootResourceHack.INSTANCE, (DescriptionProvider)RootResourceHack.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
            this.controllerInitializer.initializeModel(rootResource, rootRegistration);
            ExtensionContext context = new ExtensionContextImpl(rootRegistration, deployments, (SubsystemXmlWriterRegistry)this.persister, ProcessType.EMBEDDED_SERVER).createTracking("Test");
            this.additionalInit.initializeExtraSubystemsAndModel(context, rootResource, rootRegistration);
            this.mainExtension.initialize(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void boot(List<ModelNode> bootOperations) throws ConfigurationPersistenceException {
            try {
                if (this.validateOps) {
                    new OperationValidator(this.rootRegistration).validateOperations(bootOperations);
                }
                super.boot(this.persister.bootOperations);
            }
            catch (Exception e) {
                this.error = e;
            }
            catch (Throwable t) {
                this.error = new Exception(t);
            }
            finally {
                DeployerChainAddHandler.INSTANCE.clearDeployerMap();
                this.latch.countDown();
            }
        }

        public void start(StartContext context) throws StartException {
            super.start(context);
        }
    }

    private final class TestParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<ModelMarshallingContext> {
        private TestParser() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeContent(XMLExtendedStreamWriter writer, ModelMarshallingContext context) throws XMLStreamException {
            String defaultNamespace = writer.getNamespaceContext().getNamespaceURI("");
            try {
                XMLElementWriter subsystemWriter;
                ModelNode subsystem = context.getModelNode().get(new String[]{"subsystem", AbstractSubsystemTest.this.mainSubsystemName});
                if (subsystem.isDefined() && (subsystemWriter = context.getSubsystemWriter(AbstractSubsystemTest.this.mainSubsystemName)) != null) {
                    subsystemWriter.writeContent(writer, (Object)new SubsystemMarshallingContext(subsystem, writer));
                }
            }
            finally {
                writer.setDefaultNamespace(defaultNamespace);
            }
            writer.writeEndDocument();
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            while (reader.hasNext() && reader.nextTag() != 2) {
                if (Namespace.forUri((String)reader.getNamespaceURI()) != Namespace.UNKNOWN) {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                if (Element.forName((String)reader.getLocalName()) != Element.SUBSYSTEM) {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                reader.handleAny(operations);
            }
        }
    }

    private final class ExtensionParsingContextImpl
    implements ExtensionParsingContext {
        private final XMLMapper mapper;

        public ExtensionParsingContextImpl(XMLMapper mapper) {
            this.mapper = mapper;
        }

        public void setSubsystemXmlMapping(String namespaceUri, XMLElementReader<List<ModelNode>> reader) {
            this.mapper.registerRootElement(new QName(namespaceUri, "subsystem"), reader);
        }

        public void setDeploymentXmlMapping(String namespaceUri, XMLElementReader<ModelNode> reader) {
        }

        private XMLMapper getMapper() {
            return this.mapper;
        }
    }
}

